/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.core.model.xml;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAnnotationValue;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JPrimitiveType;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.api.ErrorListener;
import com.sun.tools.xjc.api.Mapping;
import com.sun.tools.xjc.api.S2JJAXBModel;
import com.sun.tools.xjc.api.SchemaCompiler;
import com.sun.tools.xjc.api.XJC;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.inst2xsd.Inst2Xsd;
import org.apache.xmlbeans.impl.inst2xsd.Inst2XsdOptions;
import org.apache.xmlbeans.impl.xb.xsdschema.SchemaDocument;
import org.jboss.tools.fuse.transformation.core.internal.DataTransformationCoreActivator;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class XmlModelGenerator {
    private static final String JAVAX_XML_ACCESS_EXTERNAL_SCHEMA = "javax.xml.accessExternalSchema";

    void addMissingSettersForLists(Iterator<JDefinedClass> iterator, JPrimitiveType voidType) {
        while (iterator.hasNext()) {
            JDefinedClass definedClass = iterator.next();
            this.addMissingSettersForLists(definedClass.classes(), voidType);
            HashSet<JMethod> listGetMethods = new HashSet<JMethod>();
            for (JMethod method : definedClass.methods()) {
                if (!method.name().startsWith("get") || !method.type().name().startsWith("List<")) continue;
                listGetMethods.add(method);
            }
            if (listGetMethods.isEmpty()) continue;
            block2: for (JMethod method : definedClass.methods()) {
                if (!method.name().startsWith("set")) continue;
                Iterator iter = listGetMethods.iterator();
                while (iter.hasNext()) {
                    JMethod getMethod = (JMethod)iter.next();
                    if (!method.name().substring(3).equals(getMethod.name().substring(3))) continue;
                    iter.remove();
                    continue block2;
                }
            }
            block4: for (JMethod getMethod : listGetMethods) {
                String name = getMethod.name().substring(3);
                JMethod setMethod = definedClass.method(getMethod.mods().getValue(), (JType)voidType, "set" + name);
                for (String key : definedClass.fields().keySet()) {
                    if (!key.equalsIgnoreCase(name)) continue;
                    JVar prm = setMethod.param(0, getMethod.type(), key);
                    setMethod.body().assign((JAssignmentTarget)JExpr._this().ref(key), (JExpression)prm);
                    continue block4;
                }
            }
        }
    }

    private void addSchemaLocations(NodeList nodes, Map<String, File> fileByNamespace, Element schema, String schemaPrefix, String schemaNamespace) {
        int nodeNdx = 0;
        while (nodeNdx < nodes.getLength()) {
            Node node = nodes.item(nodeNdx);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                NamedNodeMap attrs = element.getAttributes();
                if (attrs != null) {
                    Attr nsAttr = null;
                    int attrNdx = 0;
                    while (attrNdx < attrs.getLength()) {
                        Node attr = attrs.item(attrNdx);
                        if (attr.getNodeName().startsWith("xmlns")) {
                            nsAttr = (Attr)attr;
                            break;
                        }
                        ++attrNdx;
                    }
                    if (nsAttr != null) {
                        element.removeAttributeNode(nsAttr);
                        schema.setAttributeNodeNS(nsAttr);
                        Element importElement = schema.getOwnerDocument().createElementNS(schemaNamespace, String.valueOf(schemaPrefix) + ":import");
                        importElement.setAttribute("namespace", nsAttr.getNodeValue());
                        importElement.setAttribute("schemaLocation", fileByNamespace.get(nsAttr.getNodeValue()).toURI().toString());
                        schema.insertBefore(importElement, schema.getFirstChild());
                    }
                }
                this.addSchemaLocations(element.getChildNodes(), fileByNamespace, schema, schemaPrefix, schemaNamespace);
            }
            ++nodeNdx;
        }
    }

    private SchemaCompiler createSchemaCompiler(File schemaFile) throws FileNotFoundException {
        SchemaCompiler sc = XJC.createSchemaCompiler();
        FileInputStream schemaStream = new FileInputStream(schemaFile);
        InputSource is = new InputSource(schemaStream);
        is.setSystemId(schemaFile.toURI().toString());
        sc.setErrorListener(new ErrorListener(){

            public void warning(SAXParseException arg0) {
                DataTransformationCoreActivator.pluginLog().logWarning((Throwable)arg0);
            }

            public void info(SAXParseException arg0) {
                DataTransformationCoreActivator.pluginLog().logInfo("Info while parsing the xsd", (Throwable)arg0);
            }

            public void fatalError(SAXParseException arg0) {
                DataTransformationCoreActivator.pluginLog().logError((Throwable)arg0);
            }

            public void error(SAXParseException arg0) {
                DataTransformationCoreActivator.pluginLog().logError((Throwable)arg0);
            }
        });
        sc.parseSchema(is);
        return sc;
    }

    public Map<String, String> elementToClassMapping(JCodeModel model) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        Iterator packageIt = model.packages();
        while (packageIt.hasNext()) {
            Iterator classIt = ((JPackage)packageIt.next()).classes();
            while (classIt.hasNext()) {
                JDefinedClass jdClass = (JDefinedClass)classIt.next();
                if (jdClass.name().equals("ObjectFactory")) {
                    for (JMethod method : jdClass.methods()) {
                        JAnnotationUse elementAnnotation = this.getAnnotation((JAnnotatable)method, XmlElementDecl.class.getName());
                        if (elementAnnotation == null) continue;
                        String elementName = this.getAnnotationValue(elementAnnotation, "name");
                        JType returnType = (JType)((JClass)method.type()).getTypeParameters().get(0);
                        mappings.put(elementName, returnType.fullName());
                    }
                    continue;
                }
                JAnnotationUse elementAnnotation = this.getAnnotation((JAnnotatable)jdClass, XmlRootElement.class.getName());
                if (elementAnnotation == null) continue;
                String elementName = this.getAnnotationValue(elementAnnotation, "name");
                mappings.put(elementName, jdClass.fullName());
            }
        }
        return mappings;
    }

    public JCodeModel generateFromInstance(File instanceFile, File schemaFile, String packageName, File targetPath) throws Exception {
        String initialValue_AccessExternalSchema = System.getProperty(JAVAX_XML_ACCESS_EXTERNAL_SCHEMA);
        Inst2XsdOptions options = new Inst2XsdOptions();
        options.setDesign(1);
        XmlObject[] xml = new XmlObject[]{XmlObject.Factory.parse((File)instanceFile)};
        SchemaDocument[] schemaDocs = Inst2Xsd.inst2xsd((XmlObject[])xml, (Inst2XsdOptions)options);
        if (schemaDocs.length == 1) {
            schemaDocs[0].save(schemaFile, new XmlOptions().setSavePrettyPrint());
        } else {
            System.setProperty(JAVAX_XML_ACCESS_EXTERNAL_SCHEMA, "all");
            String namespace = xml[0].getDomNode().getFirstChild().getNamespaceURI();
            HashMap<String, File> fileByNamespace = new HashMap<String, File>();
            SchemaDocument[] schemaDocumentArray = schemaDocs;
            int n = schemaDocs.length;
            int n2 = 0;
            while (n2 < n) {
                File file;
                SchemaDocument schemaDoc = schemaDocumentArray[n2];
                String targetNamespace = schemaDoc.getSchema().getTargetNamespace();
                if (targetNamespace.equals(namespace)) {
                    file = schemaFile;
                } else {
                    String name = new URI(targetNamespace).getSchemeSpecificPart();
                    StringBuilder builder = new StringBuilder();
                    String[] stringArray = name.split("/");
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String part = stringArray[n4];
                        if (!part.isEmpty()) {
                            if (builder.length() > 0) {
                                builder.append('.');
                            }
                            builder.append(part);
                        }
                        ++n4;
                    }
                    file = new File(schemaFile.getParent(), builder + ".xsd");
                }
                schemaDoc.save(file, new XmlOptions().setSavePrettyPrint());
                fileByNamespace.put(targetNamespace, file);
                ++n2;
            }
            for (File file : fileByNamespace.values()) {
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
                NodeList nodes = doc.getChildNodes();
                int nodeNdx = 0;
                while (nodeNdx < nodes.getLength()) {
                    Node node = nodes.item(nodeNdx);
                    if (node.getNodeType() == 1) {
                        String schemaNamespace;
                        Element schema = (Element)node;
                        String schemaPrefix = schema.getNodeName();
                        int ndx = schemaPrefix.indexOf(58);
                        schemaPrefix = ndx > 0 ? schemaPrefix.substring(0, ndx) : "";
                        NamedNodeMap attrs = schema.getAttributes();
                        if (attrs == null) {
                            schemaNamespace = "";
                        } else {
                            Attr nsAttr = null;
                            int attrNdx = 0;
                            while (attrNdx < attrs.getLength()) {
                                Node attr = attrs.item(attrNdx);
                                if (attr.getNodeName().equals("xmlns" + (schemaPrefix.isEmpty() ? "" : ":" + schemaPrefix))) {
                                    nsAttr = (Attr)attr;
                                    break;
                                }
                                ++attrNdx;
                            }
                            schemaNamespace = nsAttr == null ? "" : nsAttr.getValue();
                        }
                        this.addSchemaLocations(node.getChildNodes(), fileByNamespace, schema, schemaPrefix, schemaNamespace);
                    }
                    ++nodeNdx;
                }
                TransformerFactory.newInstance().newTransformer().transform(new DOMSource(doc), new StreamResult(file));
            }
        }
        JCodeModel generatedSchema = this.generateFromSchema(schemaFile, packageName, targetPath);
        this.setBackAccessExternalSchemaProperty(initialValue_AccessExternalSchema);
        return generatedSchema;
    }

    private void setBackAccessExternalSchemaProperty(String initialValue_AccessExternalSchema) {
        if (initialValue_AccessExternalSchema != null) {
            System.setProperty(JAVAX_XML_ACCESS_EXTERNAL_SCHEMA, initialValue_AccessExternalSchema);
        } else {
            System.clearProperty(JAVAX_XML_ACCESS_EXTERNAL_SCHEMA);
        }
    }

    public JCodeModel generateFromSchema(File schemaFile, String packageName, File targetPath) throws Exception {
        String initialValueAccessExternalSchema = System.getProperty(JAVAX_XML_ACCESS_EXTERNAL_SCHEMA);
        System.setProperty(JAVAX_XML_ACCESS_EXTERNAL_SCHEMA, "all");
        SchemaCompiler sc = this.createSchemaCompiler(schemaFile);
        if (packageName != null) {
            sc.forcePackageName(packageName);
        }
        class SchemaErrorListener
        implements ErrorListener {
            Exception exception;

            SchemaErrorListener() {
            }

            public void warning(SAXParseException exception) {
                this.exception = exception;
            }

            public void info(SAXParseException exception) {
                this.exception = exception;
            }

            public void fatalError(SAXParseException exception) {
                this.exception = exception;
            }

            public void error(SAXParseException exception) {
                this.exception = exception;
            }
        }
        SchemaErrorListener listener = new SchemaErrorListener();
        sc.setErrorListener((ErrorListener)listener);
        S2JJAXBModel s2 = sc.bind();
        if (listener.exception != null) {
            this.setBackAccessExternalSchemaProperty(initialValueAccessExternalSchema);
            throw listener.exception;
        }
        if (s2 == null) {
            this.setBackAccessExternalSchemaProperty(initialValueAccessExternalSchema);
            throw new Exception("Failed to parse schema into JAXB Model");
        }
        JCodeModel jcm = s2.generateCode(null, null);
        Iterator iter = jcm.packages();
        while (iter.hasNext()) {
            this.addMissingSettersForLists(((JPackage)iter.next()).classes(), jcm.VOID);
        }
        try {
            Throwable throwable = null;
            Object var10_11 = null;
            try (PrintStream status = new PrintStream(new ByteArrayOutputStream());){
                jcm.build(targetPath, status);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            this.setBackAccessExternalSchemaProperty(initialValueAccessExternalSchema);
        }
        return jcm;
    }

    private JAnnotationUse getAnnotation(JAnnotatable annotated, String type) {
        JAnnotationUse annotation = null;
        for (JAnnotationUse ann : annotated.annotations()) {
            if (!ann.getAnnotationClass().fullName().equals(type)) continue;
            annotation = ann;
            break;
        }
        return annotation;
    }

    private String getAnnotationValue(JAnnotationUse annotation, String elementName) {
        JAnnotationValue jaVal = (JAnnotationValue)annotation.getAnnotationMembers().get(elementName);
        if (jaVal == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        jaVal.generate(new JFormatter((Writer)sw));
        return sw.toString().replaceAll("\"", "");
    }

    public List<QName> getElementsFromSchema(File schemaFile) throws Exception {
        String initialValueAccessExternalSchema = System.getProperty(JAVAX_XML_ACCESS_EXTERNAL_SCHEMA);
        System.setProperty(JAVAX_XML_ACCESS_EXTERNAL_SCHEMA, "all");
        LinkedList<QName> elements = new LinkedList<QName>();
        SchemaCompiler sc = this.createSchemaCompiler(schemaFile);
        S2JJAXBModel s2 = sc.bind();
        if (s2 == null) {
            this.setBackAccessExternalSchemaProperty(initialValueAccessExternalSchema);
            throw new Exception("Failed to parse schema into JAXB Model");
        }
        for (Mapping mapping : s2.getMappings()) {
            elements.add(mapping.getElement());
        }
        this.setBackAccessExternalSchemaProperty(initialValueAccessExternalSchema);
        return elements;
    }

    public QName getRootElementName(File instanceFile) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        Document doc = dbf.newDocumentBuilder().parse(instanceFile);
        Element root = doc.getDocumentElement();
        if (root == null) {
            throw new Exception("Invalid instance document : no root element");
        }
        return new QName(root.getNamespaceURI(), root.getLocalName());
    }
}

