/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.core.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;

public class TestGenerator {
    private static final String TEST_TEMPLATE = "TestTemplate.java.template";
    private static final String ENDPOINT_KEY = "\\$\\[transform-id\\]";
    private static final String PACKAGE_KEY = "\\$\\[package-name\\]";
    private static final String CLASSNAME_KEY = "\\$\\[test-name\\]";

    public static void createTransformTest(String transformId, String packageName, String className, File targetPath) throws Exception {
        String template = TestGenerator.readTemplate().replaceAll(ENDPOINT_KEY, transformId).replaceAll(PACKAGE_KEY, packageName).replaceAll(CLASSNAME_KEY, className);
        File testPath = new File(targetPath, TestGenerator.createTestPath(packageName, className));
        if (testPath.exists()) {
            throw new Exception("Unable to create test, target already exists: " + testPath.getAbsolutePath());
        }
        if (!testPath.getParentFile().exists()) {
            testPath.getParentFile().mkdirs();
        }
        TestGenerator.writeTemplate(template, testPath);
    }

    private static String readTemplate() throws Exception {
        StringBuilder templateStr = new StringBuilder();
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStreamReader reader = new InputStreamReader(TestGenerator.class.getResourceAsStream(TEST_TEMPLATE), StandardCharsets.UTF_8);){
            char[] buf = new char[1024];
            int count = 0;
            while ((count = reader.read(buf)) != -1) {
                templateStr.append(buf, 0, count);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return templateStr.toString();
    }

    private static void writeTemplate(String content, File target) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(target));){
            writer.write(content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static String createTestPath(String packageName, String className) {
        StringBuilder path = new StringBuilder();
        if (packageName != null && packageName.length() > 0) {
            path.append(packageName.replaceAll("\\.", "/"));
            path.append("/");
        }
        path.append(String.valueOf(className) + ".java");
        return path.toString();
    }
}

