/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context;

import org.eclipse.jpt.jpa.core.JpaModel;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.Relationship;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedTable;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJpaProject;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJptPlugin;
import org.jboss.tools.hibernate.jpt.core.internal.validation.HibernateJpaValidationMessage;
import org.jboss.tools.hibernate.runtime.spi.INamingStrategy;

public class NamingStrategyMappingTools {
    public static String buildJoinTableDefaultName(Relationship relationshipReference) {
        if (relationshipReference.getJpaProject().getDataSource().connectionProfileIsActive()) {
            return NamingStrategyMappingTools.buildDbJoinTableDefaultName(relationshipReference);
        }
        RelationshipMapping relationshipMapping = relationshipReference.getMapping();
        if (relationshipMapping == null) {
            return null;
        }
        if (!(relationshipReference.getTypeMapping() instanceof Entity)) {
            return null;
        }
        Entity ownerEntity = (Entity)relationshipReference.getTypeMapping();
        SpecifiedTable ownerTable = ownerEntity.getTable();
        if (ownerTable == null) {
            return null;
        }
        Entity targetEntity = relationshipMapping.getResolvedTargetEntity();
        if (targetEntity == null) {
            return null;
        }
        SpecifiedTable targetTable = targetEntity.getTable();
        if (targetTable == null) {
            return null;
        }
        INamingStrategy ns = NamingStrategyMappingTools.getJpaProject(relationshipReference).getNamingStrategy();
        if (NamingStrategyMappingTools.getJpaProject(relationshipReference).isNamingStrategyEnabled() && ns != null) {
            try {
                String targetEntityName = targetEntity.getPersistentType().getName();
                String ownerEntityName = ownerEntity.getPersistentType().getName();
                String propName = relationshipMapping.getPersistentAttribute().getName();
                return ns.collectionTableName(ownerEntityName, targetTable.getName(), targetEntityName, targetTable.getName(), propName);
            }
            catch (Exception e) {
                IMessage m = HibernateJpaValidationMessage.buildMessage(1, "NAMING_STRATEGY_EXCEPTION", (JpaModel)relationshipReference);
                HibernateJptPlugin.logException(m.getText(), e);
            }
        }
        return String.valueOf(ownerTable.getName()) + '_' + targetTable.getName();
    }

    public static HibernateJpaProject getJpaProject(Relationship relationshipReference) {
        return (HibernateJpaProject)relationshipReference.getJpaProject();
    }

    protected static String buildDbJoinTableDefaultName(Relationship relationshipReference) {
        Table owningTable = relationshipReference.getTypeMapping().getPrimaryDbTable();
        if (owningTable == null) {
            return null;
        }
        RelationshipMapping relationshipMapping = relationshipReference.getMapping();
        if (relationshipMapping == null) {
            return null;
        }
        Entity targetEntity = relationshipMapping.getResolvedTargetEntity();
        if (targetEntity == null) {
            return null;
        }
        Table targetTable = targetEntity.getPrimaryDbTable();
        if (targetTable == null) {
            return null;
        }
        String name = String.valueOf(owningTable.getName()) + '_' + targetTable.getName();
        return owningTable.getDatabase().convertNameToIdentifier(name);
    }

    public static String buildJoinColumnDefaultName(JoinColumn joinColumn, JoinColumn.ParentAdapter parent) {
        String targetColumnName;
        if (parent.getJoinColumnsSize() != 1) {
            return null;
        }
        String prefix = parent.getAttributeName();
        if (prefix == null) {
            Entity targetEntity = parent.getRelationshipTarget();
            if (targetEntity == null) {
                return null;
            }
            prefix = targetEntity.getName();
        }
        if ((targetColumnName = joinColumn.getReferencedColumnName()) == null) {
            return null;
        }
        String name = String.valueOf(prefix) + '_' + targetColumnName;
        return name;
    }
}

