/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context.java;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.jpa.core.context.java.JavaQueryContainer;
import org.eclipse.jpt.jpa.core.context.orm.OrmQueryContainer;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaQuery;
import org.jboss.tools.hibernate.jpt.core.internal.context.CacheModeType;
import org.jboss.tools.hibernate.jpt.core.internal.context.FlushModeType;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernateNamedQuery;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.HibernateJavaQuery;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.HibernateJavaQueryContainer;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.HibernateQueryAnnotation;

public abstract class AbstractHibernateNamedQueryImpl<T extends HibernateQueryAnnotation>
extends AbstractJavaQuery<JavaQueryContainer, T>
implements HibernateJavaQuery {
    private FlushModeType specifiedFlushMode;
    private CacheModeType specifiedCacheMode;
    private Boolean specifiedCacheable;
    private String specifiedCacheRegion;
    private Integer specifiedFetchSize;
    private Integer specifiedTimeout;
    private String specifiedComment;
    private Boolean specifiedReadOnly;

    public AbstractHibernateNamedQueryImpl(JavaQueryContainer parent, T queryAnnotation) {
        super(parent, queryAnnotation);
        this.specifiedFlushMode = this.getResourceFlushMode((HibernateQueryAnnotation)queryAnnotation);
        this.specifiedCacheMode = this.getResourceCacheMode((HibernateQueryAnnotation)queryAnnotation);
        this.specifiedCacheable = queryAnnotation.isCacheable();
        this.specifiedCacheRegion = queryAnnotation.getCacheRegion();
        this.specifiedFetchSize = queryAnnotation.getFetchSize();
        this.specifiedTimeout = queryAnnotation.getTimeout();
        this.specifiedComment = queryAnnotation.getComment();
        this.specifiedReadOnly = queryAnnotation.isReadOnly();
    }

    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        this.setSpecifiedFlushMode_(this.getResourceFlushMode((HibernateQueryAnnotation)this.queryAnnotation));
        this.setSpecifiedCacheMode_(this.getResourceCacheMode((HibernateQueryAnnotation)this.queryAnnotation));
        this.setSpecifiedCacheable_(((HibernateQueryAnnotation)this.queryAnnotation).isCacheable());
        this.setSpecifiedCacheRegion_(((HibernateQueryAnnotation)this.queryAnnotation).getCacheRegion());
        this.setSpecifiedFetchSize_(((HibernateQueryAnnotation)this.queryAnnotation).getFetchSize());
        this.setSpecifiedTimeout_(((HibernateQueryAnnotation)this.queryAnnotation).getTimeout());
        this.setSpecifiedComment_(((HibernateQueryAnnotation)this.queryAnnotation).getComment());
        this.setSpecifiedReadOnly_(((HibernateQueryAnnotation)this.queryAnnotation).isReadOnly());
    }

    private CacheModeType getResourceCacheMode(HibernateQueryAnnotation queryAnnotation) {
        return CacheModeType.fromJavaAnnotationValue(queryAnnotation);
    }

    private FlushModeType getResourceFlushMode(HibernateQueryAnnotation queryAnnotation) {
        return FlushModeType.fromJavaAnnotationValue(queryAnnotation);
    }

    public void convertTo(OrmQueryContainer queryContainer) {
        throw new UnsupportedOperationException();
    }

    public HibernateJavaQueryContainer getParent() {
        return (HibernateJavaQueryContainer)super.getParent();
    }

    @Override
    public FlushModeType getFlushMode() {
        return this.getSpecifiedFlushMode() == null ? this.getDefaultFlushMode() : this.getSpecifiedFlushMode();
    }

    @Override
    public FlushModeType getSpecifiedFlushMode() {
        return this.specifiedFlushMode;
    }

    @Override
    public FlushModeType getDefaultFlushMode() {
        return HibernateNamedQuery.DEFAULT_FLUSH_MODE_TYPE;
    }

    @Override
    public void setSpecifiedFlushMode(FlushModeType flushMode) {
        ((HibernateQueryAnnotation)this.getQueryAnnotation()).setFlushMode(flushMode);
        this.setSpecifiedFlushMode_(flushMode);
    }

    protected void setSpecifiedFlushMode_(FlushModeType flushMode) {
        FlushModeType oldFlushMode = this.specifiedFlushMode;
        this.specifiedFlushMode = flushMode;
        this.firePropertyChanged("specifiedFlushMode", (Object)oldFlushMode, (Object)flushMode);
    }

    @Override
    public CacheModeType getCacheMode() {
        return this.getSpecifiedCacheMode() == null ? this.getDefaultCacheMode() : this.getSpecifiedCacheMode();
    }

    @Override
    public CacheModeType getDefaultCacheMode() {
        return HibernateNamedQuery.DEFAULT_CACHE_MODE_TYPE;
    }

    @Override
    public CacheModeType getSpecifiedCacheMode() {
        return this.specifiedCacheMode;
    }

    @Override
    public void setSpecifiedCacheMode(CacheModeType cacheMode) {
        ((HibernateQueryAnnotation)this.getQueryAnnotation()).setCacheMode(cacheMode);
        this.setSpecifiedCacheMode_(cacheMode);
    }

    public void setSpecifiedCacheMode_(CacheModeType cacheMode) {
        CacheModeType oldCacheMode = this.specifiedCacheMode;
        this.specifiedCacheMode = cacheMode;
        this.firePropertyChanged("specifiedCacheMode", (Object)oldCacheMode, (Object)cacheMode);
    }

    @Override
    public boolean isCacheable() {
        return this.getSpecifiedCacheable() == null ? this.isDefaultCacheable() : this.getSpecifiedCacheable().booleanValue();
    }

    @Override
    public Boolean getSpecifiedCacheable() {
        return this.specifiedCacheable;
    }

    @Override
    public void setSpecifiedCacheable(Boolean newSpecifiedCacheable) {
        ((HibernateQueryAnnotation)this.getQueryAnnotation()).setCacheable(newSpecifiedCacheable);
        this.setSpecifiedCacheable_(newSpecifiedCacheable);
    }

    public void setSpecifiedCacheable_(Boolean newSpecifiedCacheable) {
        Boolean oldSpecifiedCacheable = this.specifiedCacheable;
        this.specifiedCacheable = newSpecifiedCacheable;
        this.firePropertyChanged("specifiedCacheable", oldSpecifiedCacheable, newSpecifiedCacheable);
    }

    @Override
    public boolean isDefaultCacheable() {
        return false;
    }

    @Override
    public String getCacheRegion() {
        return this.getSpecifiedCacheRegion() == null ? this.getDefaultCacheRegion() : this.getSpecifiedCacheRegion();
    }

    @Override
    public String getSpecifiedCacheRegion() {
        return this.specifiedCacheRegion;
    }

    @Override
    public void setSpecifiedCacheRegion(String cacheRegion) {
        ((HibernateQueryAnnotation)this.getQueryAnnotation()).setCacheRegion(cacheRegion);
        this.setSpecifiedCacheRegion_(cacheRegion);
    }

    public void setSpecifiedCacheRegion_(String cacheRegion) {
        String oldSpecifiedCacheRegion = this.specifiedCacheRegion;
        this.specifiedCacheRegion = cacheRegion;
        this.firePropertyChanged("specifiedCacheRegion", oldSpecifiedCacheRegion, cacheRegion);
    }

    @Override
    public String getDefaultCacheRegion() {
        return "";
    }

    @Override
    public int getFetchSize() {
        return this.getSpecifiedFetchSize() == null ? this.getDefaultFetchSize() : this.getSpecifiedFetchSize().intValue();
    }

    @Override
    public Integer getSpecifiedFetchSize() {
        return this.specifiedFetchSize;
    }

    @Override
    public void setSpecifiedFetchSize(Integer newSpecifiedFetchSize) {
        ((HibernateQueryAnnotation)this.getQueryAnnotation()).setFetchSize(newSpecifiedFetchSize);
        this.setSpecifiedFetchSize_(newSpecifiedFetchSize);
    }

    public void setSpecifiedFetchSize_(Integer fetchSize) {
        Integer oldSpecifiedFetchSize = this.specifiedFetchSize;
        this.specifiedFetchSize = fetchSize;
        this.firePropertyChanged("specifiedFetchSize", oldSpecifiedFetchSize, fetchSize);
    }

    @Override
    public int getDefaultFetchSize() {
        return -1;
    }

    @Override
    public int getTimeout() {
        return this.getSpecifiedTimeout() == null ? this.getDefaultTimeout() : this.getSpecifiedTimeout().intValue();
    }

    @Override
    public Integer getSpecifiedTimeout() {
        return this.specifiedTimeout;
    }

    @Override
    public void setSpecifiedTimeout(Integer newSpecifiedTimeout) {
        ((HibernateQueryAnnotation)this.getQueryAnnotation()).setTimeout(newSpecifiedTimeout);
        this.setSpecifiedTimeout_(newSpecifiedTimeout);
    }

    public void setSpecifiedTimeout_(Integer timeout) {
        Integer oldSpecifiedTimeout = this.specifiedTimeout;
        this.specifiedTimeout = timeout;
        this.firePropertyChanged("specifiedTimeout", oldSpecifiedTimeout, timeout);
    }

    @Override
    public int getDefaultTimeout() {
        return -1;
    }

    @Override
    public String getComment() {
        return this.getSpecifiedComment() == null ? this.getDefaultComment() : this.getSpecifiedComment();
    }

    @Override
    public String getSpecifiedComment() {
        return this.specifiedComment;
    }

    @Override
    public void setSpecifiedComment(String newSpecifiedComment) {
        ((HibernateQueryAnnotation)this.getQueryAnnotation()).setComment(newSpecifiedComment);
        this.setSpecifiedComment_(newSpecifiedComment);
    }

    public void setSpecifiedComment_(String comment) {
        String oldSpecifiedComment = this.specifiedComment;
        this.specifiedComment = comment;
        this.firePropertyChanged("specifiedComment", oldSpecifiedComment, comment);
    }

    @Override
    public String getDefaultComment() {
        return "";
    }

    @Override
    public boolean isReadOnly() {
        return this.getSpecifiedReadOnly() == null ? this.isDefaultReadOnly() : this.getSpecifiedReadOnly().booleanValue();
    }

    @Override
    public Boolean getSpecifiedReadOnly() {
        return this.specifiedReadOnly;
    }

    @Override
    public void setSpecifiedReadOnly(Boolean newSpecifiedReadOnly) {
        ((HibernateQueryAnnotation)this.getQueryAnnotation()).setReadOnly(newSpecifiedReadOnly);
        this.setSpecifiedReadOnly_(newSpecifiedReadOnly);
    }

    public void setSpecifiedReadOnly_(Boolean readOnly) {
        Boolean oldSpecifiedReadOnly = this.specifiedReadOnly;
        this.specifiedReadOnly = readOnly;
        this.firePropertyChanged("specifiedReadOnly", oldSpecifiedReadOnly, readOnly);
    }

    @Override
    public boolean isDefaultReadOnly() {
        return false;
    }
}

