/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context.orm;

import org.eclipse.jpt.jpa.core.JpaModel;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.orm.GenericOrmJoinColumn;
import org.eclipse.jpt.jpa.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJpaProject;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJptPlugin;
import org.jboss.tools.hibernate.jpt.core.internal.context.NamingStrategyMappingTools;
import org.jboss.tools.hibernate.jpt.core.internal.context.orm.HibernateOrmJoinColumn;
import org.jboss.tools.hibernate.jpt.core.internal.validation.HibernateJpaValidationMessage;
import org.jboss.tools.hibernate.runtime.spi.INamingStrategy;

public class HibernateOrmJoinColumnImpl
extends GenericOrmJoinColumn
implements HibernateOrmJoinColumn {
    public HibernateOrmJoinColumnImpl(JoinColumn.ParentAdapter owner, XmlJoinColumn resourceJoinColumn) {
        super(owner, resourceJoinColumn);
    }

    protected String buildDefaultName() {
        return NamingStrategyMappingTools.buildJoinColumnDefaultName(this, (JoinColumn.ParentAdapter)this.parentAdapter);
    }

    public HibernateJpaProject getJpaProject() {
        return (HibernateJpaProject)super.getJpaProject();
    }

    public Column getDbColumn() {
        Table table = this.getDbTable();
        return table == null ? null : table.getColumnForIdentifier(this.getDBColumnName());
    }

    @Override
    public String getDBColumnName() {
        return this.getSpecifiedDBColumnName() != null ? this.getSpecifiedDBColumnName() : this.getDefaultDBColumnName();
    }

    @Override
    public String getDefaultDBColumnName() {
        return this.getDefaultName();
    }

    @Override
    public String getSpecifiedDBColumnName() {
        if (this.getSpecifiedName() == null) {
            return null;
        }
        INamingStrategy ns = this.getJpaProject().getNamingStrategy();
        if (this.getJpaProject().isNamingStrategyEnabled() && ns != null) {
            try {
                return ns.columnName(this.getSpecifiedName());
            }
            catch (Exception e) {
                IMessage m = HibernateJpaValidationMessage.buildMessage(1, "NAMING_STRATEGY_EXCEPTION", (JpaModel)this);
                HibernateJptPlugin.logException(m.getText(), e);
            }
        }
        return this.getSpecifiedName();
    }

    public Column getReferencedDbColumn() {
        Table table = this.getReferencedColumnDbTable();
        return table == null ? null : table.getColumnForIdentifier(this.getReferencedDBColumnName());
    }

    @Override
    public String getReferencedDBColumnName() {
        return this.getReferencedSpecifiedDBColumnName() != null ? this.getReferencedSpecifiedDBColumnName() : this.getReferencedDefaultDBColumnName();
    }

    @Override
    public String getReferencedDefaultDBColumnName() {
        return this.defaultReferencedColumnName;
    }

    @Override
    public String getReferencedSpecifiedDBColumnName() {
        if (this.specifiedReferencedColumnName == null) {
            return null;
        }
        INamingStrategy ns = this.getJpaProject().getNamingStrategy();
        if (this.getJpaProject().isNamingStrategyEnabled() && ns != null) {
            try {
                return ns.columnName(this.specifiedReferencedColumnName);
            }
            catch (Exception e) {
                IMessage m = HibernateJpaValidationMessage.buildMessage(1, "NAMING_STRATEGY_EXCEPTION", (JpaModel)this);
                HibernateJptPlugin.logException(m.getText(), e);
            }
        }
        return this.specifiedReferencedColumnName;
    }

    @Override
    public PersistentAttribute getReferencedPersistentAttribute() {
        if (((JoinColumn.ParentAdapter)this.parentAdapter).getJoinColumnsSize() != 1) {
            return null;
        }
        Entity targetEntity = ((JoinColumn.ParentAdapter)this.parentAdapter).getRelationshipTarget();
        if (targetEntity == null) {
            return null;
        }
        PersistentAttribute pAttr = null;
        for (PersistentAttribute attribute : targetEntity.getPersistentType().getAllAttributes()) {
            String name = attribute.getPrimaryKeyColumnName();
            if (name == null) continue;
            if (pAttr == null) {
                pAttr = attribute;
                continue;
            }
            return null;
        }
        return pAttr;
    }
}

