/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.resource.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.CombinationIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementIndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyListIterable;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jpa.core.resource.java.QueryHintAnnotation;
import org.jboss.tools.hibernate.jpt.core.internal.context.CacheModeType;
import org.jboss.tools.hibernate.jpt.core.internal.context.FlushModeType;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.HibernateNamedNativeQueryAnnotation;

public class HibernateSourceNamedNativeQueryAnnotation
extends SourceAnnotation
implements HibernateNamedNativeQueryAnnotation {
    public static final SimpleDeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.hibernate.annotations.NamedNativeQuery");
    private static final DeclarationAnnotationAdapter CONTAINER_DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.hibernate.annotations.NamedNativeQueries");
    private DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter;
    private AnnotationElementAdapter<String> nameAdapter;
    private String name;
    TextRange nameTextRange;
    private DeclarationAnnotationElementAdapter<String> queryDeclarationAdapter;
    private AnnotationElementAdapter<String> queryAdapter;
    private String query;
    List<TextRange> queryTextRanges;
    private DeclarationAnnotationElementAdapter<String> flushModeDeclarationAdapter;
    private AnnotationElementAdapter<String> flushModeAdapter;
    private FlushModeType flushMode;
    TextRange flushModeTextRange;
    private DeclarationAnnotationElementAdapter<String> cacheModeDeclarationAdapter;
    private AnnotationElementAdapter<String> cacheModeAdapter;
    private CacheModeType cacheMode;
    TextRange cacheModeTextRange;
    private DeclarationAnnotationElementAdapter<Boolean> cacheableDeclarationAdapter;
    private AnnotationElementAdapter<Boolean> cacheableAdapter;
    private Boolean cacheable;
    private DeclarationAnnotationElementAdapter<String> cacheRegionDeclarationAdapter;
    private AnnotationElementAdapter<String> cacheRegionAdapter;
    private String cacheRegion;
    private DeclarationAnnotationElementAdapter<Integer> fetchSizeDeclarationAdapter;
    private AnnotationElementAdapter<Integer> fetchSizeAdapter;
    private Integer fetchSize;
    private DeclarationAnnotationElementAdapter<Integer> timeoutDeclarationAdapter;
    private AnnotationElementAdapter<Integer> timeoutAdapter;
    private Integer timeout;
    private DeclarationAnnotationElementAdapter<String> commentDeclarationAdapter;
    private AnnotationElementAdapter<String> commentAdapter;
    private String comment;
    private DeclarationAnnotationElementAdapter<Boolean> readOnlyDeclarationAdapter;
    private AnnotationElementAdapter<Boolean> readOnlyAdapter;
    private Boolean readOnly;
    private DeclarationAnnotationElementAdapter<Boolean> callableDeclarationAdapter;
    private AnnotationElementAdapter<Boolean> callableAdapter;
    private Boolean callable;
    private DeclarationAnnotationElementAdapter<String> resultClassDeclarationAdapter;
    private AnnotationElementAdapter<String> resultClassAdapter;
    private String resultClass;
    TextRange resultClassTextRange;
    private String fullyQualifiedResultClassName;
    private boolean fqResultClassNameStale = true;
    private DeclarationAnnotationElementAdapter<String> resultSetMappingDeclarationAdapter;
    private AnnotationElementAdapter<String> resultSetMappingAdapter;
    private String resultSetMapping;
    private TextRange resultSetMappingTextRange;

    HibernateSourceNamedNativeQueryAnnotation(JavaResourceModel parent, AnnotatedElement annotatedElement, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, annotatedElement, daa, annotationAdapter);
        this.nameDeclarationAdapter = this.buildNameAdapter(daa);
        this.nameAdapter = this.buildAdapter(this.nameDeclarationAdapter);
        this.queryDeclarationAdapter = this.buildQueryAdapter(daa);
        this.queryAdapter = this.buildAdapter(this.queryDeclarationAdapter);
        this.flushModeDeclarationAdapter = this.buildFlushModeAdapter(daa);
        this.flushModeAdapter = new ShortCircuitAnnotationElementAdapter(annotatedElement, this.flushModeDeclarationAdapter);
        this.cacheModeDeclarationAdapter = this.buildCacheModeAdapter(daa);
        this.cacheModeAdapter = new ShortCircuitAnnotationElementAdapter(annotatedElement, this.cacheModeDeclarationAdapter);
        this.cacheableDeclarationAdapter = this.buildCacheableAdapter(daa);
        this.cacheableAdapter = new ShortCircuitAnnotationElementAdapter(annotatedElement, this.cacheableDeclarationAdapter);
        this.cacheRegionDeclarationAdapter = this.buildCacheRegionAdapter(daa);
        this.cacheRegionAdapter = this.buildAdapter(this.cacheRegionDeclarationAdapter);
        this.fetchSizeDeclarationAdapter = this.buildFetchSizeAdapter(daa);
        this.fetchSizeAdapter = new ShortCircuitAnnotationElementAdapter(annotatedElement, this.fetchSizeDeclarationAdapter);
        this.timeoutDeclarationAdapter = this.buildTimeoutAdapter(daa);
        this.timeoutAdapter = new ShortCircuitAnnotationElementAdapter(annotatedElement, this.timeoutDeclarationAdapter);
        this.commentDeclarationAdapter = this.buildCommentAdapter(daa);
        this.commentAdapter = new ShortCircuitAnnotationElementAdapter(annotatedElement, this.commentDeclarationAdapter);
        this.readOnlyDeclarationAdapter = this.buildReadOnlyAdapter(daa);
        this.readOnlyAdapter = new ShortCircuitAnnotationElementAdapter(annotatedElement, this.readOnlyDeclarationAdapter);
        this.callableDeclarationAdapter = this.buildReadOnlyAdapter(daa);
        this.callableAdapter = new ShortCircuitAnnotationElementAdapter(annotatedElement, this.callableDeclarationAdapter);
        this.resultClassDeclarationAdapter = this.buildResultClassAdapter(daa);
        this.resultClassAdapter = this.buildAdapter(this.resultClassDeclarationAdapter);
        this.resultSetMappingDeclarationAdapter = this.buildResultSetMappingAdapter(daa);
        this.resultSetMappingAdapter = this.buildAdapter(this.resultSetMappingDeclarationAdapter);
    }

    public String getAnnotationName() {
        return "org.hibernate.annotations.NamedNativeQuery";
    }

    public void initialize(CompilationUnit astRoot) {
        this.name = this.buildName(astRoot);
        this.nameTextRange = this.buildNameTextRange(astRoot);
        this.query = this.buildQuery(astRoot);
        this.queryTextRanges = this.buildQueryTextRanges(astRoot);
        this.flushMode = this.buildFlushMode(astRoot);
        this.flushModeTextRange = this.buildFlushModeTextRange(astRoot);
        this.cacheMode = this.buildCacheMode(astRoot);
        this.cacheModeTextRange = this.buildCacheModeTextRange(astRoot);
        this.cacheable = this.buildCacheable(astRoot);
        this.cacheRegion = this.buildCacheRegion(astRoot);
        this.fetchSize = this.buildFetchSize(astRoot);
        this.timeout = this.buildTimeout(astRoot);
        this.comment = this.buildComment(astRoot);
        this.readOnly = this.buildReadOnly(astRoot);
        this.callable = this.buildCallable(astRoot);
        this.resultClass = this.buildResultClass(astRoot);
        this.resultClassTextRange = this.buildResultClassTextRange(astRoot);
        this.resultSetMapping = this.buildResultSetMapping(astRoot);
        this.resultSetMappingTextRange = this.buildResultSetMappingTextRange(astRoot);
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncName(this.buildName(astRoot));
        this.nameTextRange = this.buildNameTextRange(astRoot);
        this.syncQuery(this.buildQuery(astRoot));
        this.queryTextRanges = this.buildQueryTextRanges(astRoot);
        this.syncFlushMode(this.buildFlushMode(astRoot));
        this.flushModeTextRange = this.buildFlushModeTextRange(astRoot);
        this.syncCacheMode(this.buildCacheMode(astRoot));
        this.cacheModeTextRange = this.buildCacheModeTextRange(astRoot);
        this.syncCacheable(this.buildCacheable(astRoot));
        this.syncCacheRegion(this.buildCacheRegion(astRoot));
        this.syncFetchSize(this.buildFetchSize(astRoot));
        this.syncTimeout(this.buildTimeout(astRoot));
        this.syncComment(this.buildComment(astRoot));
        this.syncReadOnly(this.buildReadOnly(astRoot));
        this.syncCallable(this.buildCallable(astRoot));
        this.syncResultClass(this.buildResultClass(astRoot));
        this.resultClassTextRange = this.buildResultClassTextRange(astRoot);
        this.syncResultSetMapping(this.buildResultSetMapping(astRoot));
        this.resultSetMappingTextRange = this.buildResultSetMappingTextRange(astRoot);
    }

    AnnotationElementAdapter<String> buildAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new ShortCircuitAnnotationElementAdapter(this.annotatedElement, daea);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (ObjectTools.notEquals((Object)this.name, (Object)name)) {
            this.name = name;
            this.nameAdapter.setValue((Object)name);
        }
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    private String buildName(CompilationUnit astRoot) {
        return (String)this.nameAdapter.getValue(astRoot);
    }

    public TextRange getNameTextRange() {
        return this.nameTextRange;
    }

    private TextRange buildNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.nameDeclarationAdapter, this.getAstAnnotation(astRoot));
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        if (ObjectTools.notEquals((Object)this.query, (Object)query)) {
            this.query = query;
            this.queryAdapter.setValue((Object)query);
        }
    }

    private void syncQuery(String annotationQuery) {
        String old = this.query;
        this.query = annotationQuery;
        this.firePropertyChanged("query", old, annotationQuery);
    }

    private String buildQuery(CompilationUnit astRoot) {
        return (String)this.queryAdapter.getValue(astRoot);
    }

    public List<TextRange> getQueryTextRanges() {
        return this.queryTextRanges;
    }

    private List<TextRange> buildQueryTextRanges(CompilationUnit astRoot) {
        return this.getElementTextRanges(this.queryDeclarationAdapter, this.getAstAnnotation(astRoot));
    }

    public ListIterable<QueryHintAnnotation> getHints() {
        return EmptyListIterable.instance();
    }

    public int getHintsSize() {
        return 0;
    }

    public QueryHintAnnotation hintAt(int index) {
        return null;
    }

    public QueryHintAnnotation addHint(int index) {
        return null;
    }

    public void moveHint(int targetIndex, int sourceIndex) {
    }

    public void removeHint(int index) {
    }

    @Override
    public FlushModeType getFlushMode() {
        return this.flushMode;
    }

    @Override
    public void setFlushMode(FlushModeType flushMode) {
        if (ObjectTools.notEquals((Object)((Object)this.flushMode), (Object)((Object)flushMode))) {
            this.flushMode = flushMode;
            this.flushModeAdapter.setValue((Object)FlushModeType.toJavaAnnotationValue(flushMode));
        }
    }

    private void syncFlushMode(FlushModeType flushMode) {
        FlushModeType old = this.flushMode;
        this.flushMode = flushMode;
        this.firePropertyChanged("flushMode", (Object)old, (Object)flushMode);
    }

    private FlushModeType buildFlushMode(CompilationUnit astRoot) {
        return FlushModeType.fromJavaAnnotationValue(this.flushModeAdapter.getValue(astRoot));
    }

    protected TextRange buildFlushModeTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.flushModeDeclarationAdapter, this.getAstAnnotation(astRoot));
    }

    @Override
    public TextRange getFlushModeTextRange() {
        return this.flushModeTextRange;
    }

    @Override
    public CacheModeType getCacheMode() {
        return this.cacheMode;
    }

    @Override
    public void setCacheMode(CacheModeType cacheMode) {
        if (ObjectTools.notEquals((Object)((Object)this.cacheMode), (Object)((Object)cacheMode))) {
            this.cacheMode = cacheMode;
            this.cacheModeAdapter.setValue((Object)CacheModeType.toJavaAnnotationValue(cacheMode));
        }
    }

    private void syncCacheMode(CacheModeType cacheMode) {
        CacheModeType old = this.cacheMode;
        this.cacheMode = cacheMode;
        this.firePropertyChanged("cacheMode", (Object)old, (Object)cacheMode);
    }

    private CacheModeType buildCacheMode(CompilationUnit astRoot) {
        return CacheModeType.fromJavaAnnotationValue(this.cacheModeAdapter.getValue(astRoot));
    }

    protected TextRange buildCacheModeTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.flushModeDeclarationAdapter, this.getAstAnnotation(astRoot));
    }

    @Override
    public TextRange getCacheModeTextRange() {
        return this.cacheModeTextRange;
    }

    @Override
    public Boolean isCacheable() {
        return this.cacheable;
    }

    @Override
    public void setCacheable(Boolean cacheable) {
        if (ObjectTools.notEquals((Object)this.cacheable, (Object)cacheable)) {
            this.cacheable = cacheable;
            this.cacheableAdapter.setValue((Object)cacheable);
        }
    }

    private void syncCacheable(Boolean cacheable) {
        Boolean old = this.cacheable;
        this.cacheable = cacheable;
        this.firePropertyChanged("cacheable", old, cacheable);
    }

    private Boolean buildCacheable(CompilationUnit astRoot) {
        return (Boolean)this.cacheableAdapter.getValue(astRoot);
    }

    @Override
    public String getCacheRegion() {
        return this.cacheRegion;
    }

    @Override
    public void setCacheRegion(String cacheRegion) {
        if (ObjectTools.notEquals((Object)this.cacheRegion, (Object)cacheRegion)) {
            this.cacheRegion = cacheRegion;
            this.cacheRegionAdapter.setValue((Object)cacheRegion);
        }
    }

    private void syncCacheRegion(String cacheRegion) {
        String old = this.cacheRegion;
        this.cacheRegion = cacheRegion;
        this.firePropertyChanged("cacheRegion", old, cacheRegion);
    }

    private String buildCacheRegion(CompilationUnit astRoot) {
        return (String)this.cacheRegionAdapter.getValue(astRoot);
    }

    @Override
    public Integer getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(Integer fetchSize) {
        if (ObjectTools.notEquals((Object)this.fetchSize, (Object)fetchSize)) {
            this.fetchSize = fetchSize;
            this.fetchSizeAdapter.setValue((Object)fetchSize);
        }
    }

    private void syncFetchSize(Integer fetchSize) {
        Integer old = this.fetchSize;
        this.fetchSize = fetchSize;
        this.firePropertyChanged("fetchSize", old, fetchSize);
    }

    private Integer buildFetchSize(CompilationUnit astRoot) {
        return (Integer)this.fetchSizeAdapter.getValue(astRoot);
    }

    @Override
    public Integer getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(Integer timeout) {
        if (ObjectTools.notEquals((Object)this.timeout, (Object)timeout)) {
            this.timeout = timeout;
            this.timeoutAdapter.setValue((Object)timeout);
        }
    }

    private void syncTimeout(Integer timeout) {
        Integer old = this.timeout;
        this.timeout = timeout;
        this.firePropertyChanged("timeout", old, timeout);
    }

    private Integer buildTimeout(CompilationUnit astRoot) {
        return (Integer)this.timeoutAdapter.getValue(astRoot);
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String comment) {
        if (ObjectTools.notEquals((Object)this.comment, (Object)comment)) {
            this.comment = comment;
            this.commentAdapter.setValue((Object)comment);
        }
    }

    private void syncComment(String comment) {
        String old = this.comment;
        this.comment = comment;
        this.firePropertyChanged("comment", old, comment);
    }

    private String buildComment(CompilationUnit astRoot) {
        return (String)this.commentAdapter.getValue(astRoot);
    }

    @Override
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(Boolean readOnly) {
        if (ObjectTools.notEquals((Object)this.readOnly, (Object)readOnly)) {
            this.readOnly = readOnly;
            this.readOnlyAdapter.setValue((Object)readOnly);
        }
    }

    private void syncReadOnly(Boolean readOnly) {
        Boolean old = this.readOnly;
        this.readOnly = readOnly;
        this.firePropertyChanged("readOnly", old, readOnly);
    }

    private Boolean buildReadOnly(CompilationUnit astRoot) {
        return (Boolean)this.readOnlyAdapter.getValue(astRoot);
    }

    @Override
    public Boolean isCallable() {
        return this.callable;
    }

    @Override
    public void setCallable(Boolean callable) {
        if (ObjectTools.notEquals((Object)this.callable, (Object)callable)) {
            this.callable = callable;
            this.callableAdapter.setValue((Object)callable);
        }
    }

    private void syncCallable(Boolean callable) {
        Boolean old = this.callable;
        this.callable = callable;
        this.firePropertyChanged("callable", old, callable);
    }

    private Boolean buildCallable(CompilationUnit astRoot) {
        return (Boolean)this.callableAdapter.getValue(astRoot);
    }

    public String getResultClass() {
        return this.resultClass;
    }

    public void setResultClass(String resultClass) {
        if (ObjectTools.notEquals((Object)this.resultClass, (Object)resultClass)) {
            this.resultClass = resultClass;
            this.fqResultClassNameStale = true;
            this.resultClassAdapter.setValue((Object)resultClass);
        }
    }

    private void syncResultClass(String resultClass) {
        String old = this.resultClass;
        this.resultClass = resultClass;
        this.fqResultClassNameStale = true;
        this.firePropertyChanged("resultClass", old, resultClass);
    }

    private String buildResultClass(CompilationUnit astRoot) {
        return (String)this.resultClassAdapter.getValue(astRoot);
    }

    public TextRange getResultClassTextRange() {
        return this.resultClassTextRange;
    }

    private TextRange buildResultClassTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.nameDeclarationAdapter, this.getAstAnnotation(astRoot));
    }

    public String getFullyQualifiedResultClassName() {
        if (this.fqResultClassNameStale) {
            this.fullyQualifiedResultClassName = this.buildFullyQualifiedResultClassName();
            this.fqResultClassNameStale = false;
        }
        return this.fullyQualifiedResultClassName;
    }

    private String buildFullyQualifiedResultClassName() {
        return this.resultClass == null ? null : this.buildFullyQualifiedResultClassName_();
    }

    private String buildFullyQualifiedResultClassName_() {
        return ASTTools.resolveFullyQualifiedName((Expression)this.resultClassAdapter.getExpression(this.buildASTRoot()));
    }

    public String getResultSetMapping() {
        return this.resultSetMapping;
    }

    public void setResultSetMapping(String resultSetMapping) {
        if (ObjectTools.notEquals((Object)this.resultSetMapping, (Object)resultSetMapping)) {
            this.resultSetMapping = resultSetMapping;
            this.resultSetMappingAdapter.setValue((Object)resultSetMapping);
        }
    }

    private void syncResultSetMapping(String resultSetMapping) {
        String old = this.resultSetMapping;
        this.resultSetMapping = resultSetMapping;
        this.firePropertyChanged("resultSetMapping", old, resultSetMapping);
    }

    private String buildResultSetMapping(CompilationUnit astRoot) {
        return (String)this.resultSetMappingAdapter.getValue(astRoot);
    }

    public TextRange getResultSetMappingTextRange() {
        return this.resultSetMappingTextRange;
    }

    private TextRange buildResultSetMappingTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.resultSetMappingDeclarationAdapter, this.getAstAnnotation(astRoot));
    }

    public boolean isUnset() {
        return super.isUnset() && this.name == null && this.query == null && this.flushMode == null && this.cacheMode == null && this.cacheable == null && this.cacheRegion == null && this.fetchSize == null && this.comment == null && this.readOnly == null;
    }

    public static HibernateNamedNativeQueryAnnotation createNamedNativeQuery(JavaResourceModel parent, AnnotatedElement member) {
        return new HibernateSourceNamedNativeQueryAnnotation(parent, member, (DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER, (AnnotationAdapter)new ElementAnnotationAdapter(member, (DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER));
    }

    protected DeclarationAnnotationElementAdapter<String> buildNameAdapter(DeclarationAnnotationAdapter daAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daAdapter, (String)"name");
    }

    protected DeclarationAnnotationElementAdapter<String> buildQueryAdapter(DeclarationAnnotationAdapter daAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daAdapter, (String)"query");
    }

    protected DeclarationAnnotationElementAdapter<String> buildFlushModeAdapter(DeclarationAnnotationAdapter daAdapter) {
        return new EnumDeclarationAnnotationElementAdapter(daAdapter, "flushMode");
    }

    protected DeclarationAnnotationElementAdapter<String> buildCacheModeAdapter(DeclarationAnnotationAdapter daAdapter) {
        return new EnumDeclarationAnnotationElementAdapter(daAdapter, "cacheMode");
    }

    protected DeclarationAnnotationElementAdapter<Boolean> buildCacheableAdapter(DeclarationAnnotationAdapter daAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forBooleans((DeclarationAnnotationAdapter)daAdapter, (String)"cacheable");
    }

    protected DeclarationAnnotationElementAdapter<String> buildCacheRegionAdapter(DeclarationAnnotationAdapter daAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daAdapter, (String)"cacheRegion");
    }

    protected DeclarationAnnotationElementAdapter<Integer> buildFetchSizeAdapter(DeclarationAnnotationAdapter daAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forNumbers((DeclarationAnnotationAdapter)daAdapter, (String)"fetchSize");
    }

    protected DeclarationAnnotationElementAdapter<Integer> buildTimeoutAdapter(DeclarationAnnotationAdapter daAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forNumbers((DeclarationAnnotationAdapter)daAdapter, (String)"timeout");
    }

    protected DeclarationAnnotationElementAdapter<String> buildCommentAdapter(DeclarationAnnotationAdapter daAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daAdapter, (String)"comment");
    }

    protected DeclarationAnnotationElementAdapter<Boolean> buildReadOnlyAdapter(DeclarationAnnotationAdapter daAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forBooleans((DeclarationAnnotationAdapter)daAdapter, (String)"readOnly");
    }

    protected DeclarationAnnotationElementAdapter<Boolean> buildCallableAdapter(DeclarationAnnotationAdapter daAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forBooleans((DeclarationAnnotationAdapter)daAdapter, (String)"callable");
    }

    private DeclarationAnnotationElementAdapter<String> buildResultClassAdapter(DeclarationAnnotationAdapter daAdapter) {
        return new ConversionDeclarationAnnotationElementAdapter(daAdapter, "resultClass", SimpleTypeStringExpressionConverter.instance());
    }

    private DeclarationAnnotationElementAdapter<String> buildResultSetMappingAdapter(DeclarationAnnotationAdapter daAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daAdapter, (String)"resultSetMapping");
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    public static HibernateSourceNamedNativeQueryAnnotation buildHibernateSourceNamedNativeQueryAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element, int index) {
        IndexedDeclarationAnnotationAdapter idaa = HibernateSourceNamedNativeQueryAnnotation.buildHibernateNamedNativeQueryDeclarationAnnotationAdapter(index);
        IndexedAnnotationAdapter iaa = HibernateSourceNamedNativeQueryAnnotation.buildHibernateNamedNativeQueryAnnotationAdapter(element, idaa);
        return new HibernateSourceNamedNativeQueryAnnotation((JavaResourceModel)parent, element, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)iaa);
    }

    private static IndexedAnnotationAdapter buildHibernateNamedNativeQueryAnnotationAdapter(AnnotatedElement annotatedElement, IndexedDeclarationAnnotationAdapter idaa) {
        return new ElementIndexedAnnotationAdapter(annotatedElement, idaa);
    }

    private static IndexedDeclarationAnnotationAdapter buildHibernateNamedNativeQueryDeclarationAnnotationAdapter(int index) {
        CombinationIndexedDeclarationAnnotationAdapter idaa = new CombinationIndexedDeclarationAnnotationAdapter((DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER, CONTAINER_DECLARATION_ANNOTATION_ADAPTER, index, "org.hibernate.annotations.NamedNativeQuery");
        return idaa;
    }
}

