/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.resource.java;

import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ShortCircuitArrayAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.StringArrayExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.StringExpressionConverter;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.ExpressionConverter;
import org.eclipse.jpt.common.core.utility.jdt.Member;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.IndexAnnotation;

public class IndexAnnotationImpl
extends SourceAnnotation
implements IndexAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.hibernate.annotations.Index");
    private static final DeclarationAnnotationElementAdapter<String> NAME_ADAPTER = IndexAnnotationImpl.buildNameAdapter(DECLARATION_ANNOTATION_ADAPTER);
    private final AnnotationElementAdapter<String> nameAdapter = this.buildNameAdapter(NAME_ADAPTER);
    private String name;
    private static DeclarationAnnotationElementAdapter<String[]> COLUMN_NAMES_ADAPTER = IndexAnnotationImpl.buildColumnNamesAdapter(DECLARATION_ANNOTATION_ADAPTER);
    private AnnotationElementAdapter<String[]> columnNamesAdapter = this.buildColumnNamesAdapter(COLUMN_NAMES_ADAPTER);
    private String[] columnNames;
    private CompilationUnit astRoot;

    protected IndexAnnotationImpl(JavaResourceModel parent, Member member) {
        super(parent, (AnnotatedElement)member, DECLARATION_ANNOTATION_ADAPTER);
    }

    public String getAnnotationName() {
        return "org.hibernate.annotations.Index";
    }

    public void initialize(CompilationUnit astRoot) {
        this.astRoot = astRoot;
        this.name = this.buildName(astRoot);
        this.columnNames = this.buildColumnNames(astRoot);
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        this.astRoot = astRoot;
        this.syncName(this.buildName(astRoot));
        this.syncColumnNames(this.buildColumnNames(astRoot));
    }

    @Override
    public String[] getColumnNames() {
        return this.columnNames;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        if (ObjectTools.notEquals((Object)this.name, (Object)newName)) {
            this.name = newName;
            this.nameAdapter.setValue((Object)newName);
        }
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    @Override
    public void setColumnNames(String[] newColumnNames) {
        if (ObjectTools.notEquals((Object)this.columnNames, (Object)newColumnNames)) {
            this.columnNames = newColumnNames;
            this.columnNamesAdapter.setValue((Object)newColumnNames);
        }
    }

    private void syncColumnNames(String[] columnNames) {
        String[] old = this.columnNames;
        this.columnNames = columnNames;
        this.firePropertyChanged("columnNames", old, columnNames);
    }

    private String buildName(CompilationUnit astRoot) {
        return (String)this.nameAdapter.getValue(astRoot);
    }

    private String[] buildColumnNames(CompilationUnit astRoot) {
        return (String[])this.columnNamesAdapter.getValue(astRoot);
    }

    private static DeclarationAnnotationElementAdapter<String> buildNameAdapter(DeclarationAnnotationAdapter adapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)adapter, (String)"name");
    }

    AnnotationElementAdapter<String> buildNameAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new ShortCircuitAnnotationElementAdapter(this.annotatedElement, daea);
    }

    private static DeclarationAnnotationElementAdapter<String[]> buildColumnNamesAdapter(DeclarationAnnotationAdapter adapter) {
        return new ConversionDeclarationAnnotationElementAdapter(adapter, "columnNames", (ExpressionConverter)new StringArrayExpressionConverter(StringExpressionConverter.instance()));
    }

    AnnotationElementAdapter<String[]> buildColumnNamesAdapter(DeclarationAnnotationElementAdapter<String[]> daea) {
        return new ShortCircuitArrayAnnotationElementAdapter(this.annotatedElement, daea);
    }

    @Override
    public TextRange getNameTextRange() {
        return this.getElementTextRange(NAME_ADAPTER, this.getAstAnnotation(this.astRoot));
    }

    @Override
    public TextRange getColumnNamesTextRange() {
        return this.getElementTextRange(COLUMN_NAMES_ADAPTER, this.getAstAnnotation(this.astRoot));
    }

    public static class IndexAnnotationDefinition
    implements AnnotationDefinition {
        private static final IndexAnnotationDefinition INSTANCE = new IndexAnnotationDefinition();

        public static AnnotationDefinition instance() {
            return INSTANCE;
        }

        private IndexAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement annotatedElement) {
            return new IndexAnnotationImpl((JavaResourceModel)parent, (Member)annotatedElement);
        }

        public String getAnnotationName() {
            return "org.hibernate.annotations.Index";
        }

        public Annotation buildAnnotation(JavaResourceAnnotatedElement arg0, IAnnotation arg1) {
            throw new UnsupportedOperationException();
        }

        public Annotation buildNullAnnotation(JavaResourceAnnotatedElement parent) {
            throw new UnsupportedOperationException();
        }
    }
}

