/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.resource.java;

import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.Member;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.TypeAnnotation;

public class TypeAnnotationImpl
extends SourceAnnotation
implements TypeAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.hibernate.annotations.Type");
    private static final DeclarationAnnotationElementAdapter<String> TYPE_ADAPTER = TypeAnnotationImpl.buildTypeAdapter(DECLARATION_ANNOTATION_ADAPTER);
    private final AnnotationElementAdapter<String> typeAdapter = this.buildTypeAdapter(TYPE_ADAPTER);
    private String type;
    private CompilationUnit astRoot;

    protected TypeAnnotationImpl(JavaResourceModel parent, Member attribute) {
        super(parent, (AnnotatedElement)attribute, DECLARATION_ANNOTATION_ADAPTER);
    }

    public void initialize(CompilationUnit astRoot) {
        this.astRoot = astRoot;
        this.type = this.buildType(astRoot);
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        this.astRoot = astRoot;
        this.syncType(this.buildType(astRoot));
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        if (ObjectTools.notEquals((Object)this.type, (Object)type)) {
            this.type = type;
            this.typeAdapter.setValue((Object)type);
        }
    }

    private void syncType(String type) {
        String old = this.type;
        this.type = type;
        this.firePropertyChanged("type", old, type);
    }

    private String buildType(CompilationUnit astRoot) {
        return (String)this.typeAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getTypeTextRange() {
        return this.getElementTextRange(TYPE_ADAPTER, this.getAstAnnotation(this.astRoot));
    }

    public String getAnnotationName() {
        return "org.hibernate.annotations.Type";
    }

    AnnotationElementAdapter<String> buildTypeAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new ShortCircuitAnnotationElementAdapter(this.annotatedElement, daea);
    }

    private static DeclarationAnnotationElementAdapter<String> buildTypeAdapter(DeclarationAnnotationAdapter adapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)adapter, (String)"type");
    }

    public static class TypeAnnotationDefinition
    implements AnnotationDefinition {
        private static final TypeAnnotationDefinition INSTANCE = new TypeAnnotationDefinition();

        public static AnnotationDefinition instance() {
            return INSTANCE;
        }

        private TypeAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement annotatedElement) {
            return new TypeAnnotationImpl((JavaResourceModel)parent, (Member)annotatedElement);
        }

        public String getAnnotationName() {
            return "org.hibernate.annotations.Type";
        }

        public Annotation buildAnnotation(JavaResourceAnnotatedElement arg0, IAnnotation arg1) {
            throw new UnsupportedOperationException();
        }

        public Annotation buildNullAnnotation(JavaResourceAnnotatedElement parent) {
            throw new UnsupportedOperationException();
        }
    }
}

