/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.ui.internal.mapping.details;

import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jpt.common.ui.internal.widgets.ClassChooserPane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.swt.widgets.Composite;
import org.jboss.tools.hibernate.jpt.core.internal.context.ParametrizedElement;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.JavaTypeDef;
import org.jboss.tools.hibernate.jpt.ui.internal.mapping.details.HibernateUIMappingMessages;
import org.jboss.tools.hibernate.jpt.ui.internal.mapping.details.ParametersComposite;

public class TypeDefPropertyComposite<T extends JavaTypeDef>
extends Pane<T> {
    public TypeDefPropertyComposite(Pane<?> parentPane, PropertyValueModel<T> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    protected void initializeLayout(Composite container) {
        this.addLabel(container, HibernateUIMappingMessages.TypeDefPropertyComposite_Name);
        this.addText(container, this.buildNameTextHolder());
        this.addTypeClassChooser(container);
        this.addDefForTypeClassChooser2(container);
        new ParametersComposite(this, container, (PropertyValueModel<? extends ParametrizedElement>)this.getSubjectHolder());
    }

    protected ModifiablePropertyValueModel<String> buildNameTextHolder() {
        return new PropertyAspectAdapter<JavaTypeDef, String>(this.getSubjectHolder(), new String[]{"name"}){

            protected String buildValue_() {
                return ((JavaTypeDef)this.subject).getName();
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((JavaTypeDef)this.subject).setName(value);
            }
        };
    }

    private ClassChooserPane<JavaTypeDef> addTypeClassChooser(Composite container) {
        return new ClassChooserPane<JavaTypeDef>((Pane)this, container){
            private List<String> superInterfaces;
            {
                this.superInterfaces = Collections.singletonList("org.hibernate.usertype.UserType");
            }

            protected ModifiablePropertyValueModel<String> buildTextHolder() {
                return new PropertyAspectAdapter<JavaTypeDef, String>(this.getSubjectHolder(), new String[]{"specifiedTypeClass"}){

                    protected String buildValue_() {
                        return ((JavaTypeDef)this.subject).getTypeClass();
                    }

                    protected void setValue_(String value) {
                        if (StringTools.isBlank((String)value)) {
                            value = null;
                        }
                        ((JavaTypeDef)this.subject).setTypeClass(value);
                    }
                };
            }

            protected String getClassName() {
                return ((JavaTypeDef)this.getSubject()).getTypeClass();
            }

            protected List<String> getSuperInterfaceNames() {
                return this.superInterfaces;
            }

            protected IJavaProject getJavaProject() {
                return ((JavaTypeDef)this.getSubject()).getJpaProject().getJavaProject();
            }

            protected void setClassName(String className) {
                ((JavaTypeDef)this.getSubject()).setTypeClass(className);
            }

            protected char getEnclosingTypeSeparator() {
                return ((JavaTypeDef)this.getSubject()).getTypeClassEnclosingTypeSeparator();
            }
        };
    }

    private ClassChooserPane<JavaTypeDef> addDefForTypeClassChooser2(Composite container) {
        return new ClassChooserPane<JavaTypeDef>((Pane)this, container){

            protected ModifiablePropertyValueModel<String> buildTextHolder() {
                return new PropertyAspectAdapter<JavaTypeDef, String>(this.getSubjectHolder(), new String[]{"defaultForTypeClass"}){

                    protected String buildValue_() {
                        return ((JavaTypeDef)this.subject).getDefaultForTypeClass();
                    }

                    protected void setValue_(String value) {
                        if (StringTools.isBlank((String)value)) {
                            value = null;
                        }
                        ((JavaTypeDef)this.subject).setDefaultForTypeClass(value);
                    }
                };
            }

            protected String getClassName() {
                return ((JavaTypeDef)this.getSubject()).getDefaultForTypeClass();
            }

            protected IJavaProject getJavaProject() {
                return ((JavaTypeDef)this.getSubject()).getJpaProject().getJavaProject();
            }

            protected void setClassName(String className) {
                ((JavaTypeDef)this.getSubject()).setDefaultForTypeClass(className);
            }

            protected char getEnclosingTypeSeparator() {
                return ((JavaTypeDef)this.getSubject()).getTypeClassEnclosingTypeSeparator();
            }
        };
    }
}

