/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.runtime.common;

import java.util.HashMap;
import java.util.Map;
import org.jboss.tools.hibernate.runtime.common.AbstractFacade;
import org.jboss.tools.hibernate.runtime.common.IFacadeFactory;
import org.jboss.tools.hibernate.runtime.common.Util;
import org.jboss.tools.hibernate.runtime.spi.IClassMetadata;
import org.jboss.tools.hibernate.runtime.spi.ICollectionMetadata;
import org.jboss.tools.hibernate.runtime.spi.ISession;
import org.jboss.tools.hibernate.runtime.spi.ISessionFactory;

public abstract class AbstractSessionFactoryFacade
extends AbstractFacade
implements ISessionFactory {
    protected Map<String, IClassMetadata> allClassMetadata = null;
    protected Map<String, ICollectionMetadata> allCollectionMetadata = null;

    public AbstractSessionFactoryFacade(IFacadeFactory facadeFactory, Object target) {
        super(facadeFactory, target);
    }

    public void close() {
        Util.invokeMethod(this.getTarget(), "close", new Class[0], new Object[0]);
    }

    public Map<String, IClassMetadata> getAllClassMetadata() {
        if (this.allClassMetadata == null) {
            this.initializeAllClassMetadata();
        }
        return this.allClassMetadata;
    }

    public Map<String, ICollectionMetadata> getAllCollectionMetadata() {
        if (this.allCollectionMetadata == null) {
            this.initializeAllCollectionMetadata();
        }
        return this.allCollectionMetadata;
    }

    public ISession openSession() {
        Object targetSession = Util.invokeMethod(this.getTarget(), "openSession", new Class[0], new Object[0]);
        return this.getFacadeFactory().createSession(targetSession);
    }

    public IClassMetadata getClassMetadata(Class<?> clazz) {
        if (this.allClassMetadata == null) {
            this.initializeAllClassMetadata();
        }
        return this.allClassMetadata.get(clazz.getName());
    }

    public IClassMetadata getClassMetadata(String entityName) {
        if (this.allClassMetadata == null) {
            this.initializeAllClassMetadata();
        }
        return this.allClassMetadata.get(entityName);
    }

    public ICollectionMetadata getCollectionMetadata(String string) {
        if (this.allCollectionMetadata == null) {
            this.initializeAllCollectionMetadata();
        }
        return this.allCollectionMetadata.get(string);
    }

    protected void initializeAllClassMetadata() {
        Map targetAllClassMetadata = (Map)Util.invokeMethod(this.getTarget(), "getAllClassMetadata", new Class[0], new Object[0]);
        this.allClassMetadata = new HashMap<String, IClassMetadata>(targetAllClassMetadata.size());
        for (Map.Entry entry : targetAllClassMetadata.entrySet()) {
            this.allClassMetadata.put((String)entry.getKey(), this.getFacadeFactory().createClassMetadata(entry.getValue()));
        }
    }

    protected void initializeAllCollectionMetadata() {
        Map targetAllCollectionMetadata = (Map)Util.invokeMethod(this.getTarget(), "getAllCollectionMetadata", new Class[0], new Object[0]);
        this.allCollectionMetadata = new HashMap<String, ICollectionMetadata>(targetAllCollectionMetadata.size());
        for (Map.Entry entry : targetAllCollectionMetadata.entrySet()) {
            this.allCollectionMetadata.put((String)entry.getKey(), this.getFacadeFactory().createCollectionMetadata(entry.getValue()));
        }
    }
}

