/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.runtime.common;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Currency;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.jboss.tools.hibernate.runtime.common.AbstractFacade;
import org.jboss.tools.hibernate.runtime.common.IFacadeFactory;
import org.jboss.tools.hibernate.runtime.common.Util;
import org.jboss.tools.hibernate.runtime.spi.ITable;
import org.jboss.tools.hibernate.runtime.spi.IType;
import org.jboss.tools.hibernate.runtime.spi.ITypeFactory;

public abstract class AbstractTypeFactoryFacade
extends AbstractFacade
implements ITypeFactory {
    private static IType BOOLEAN_TYPE = null;
    private static IType BYTE_TYPE = null;
    private static IType BIG_INTEGER_TYPE = null;
    private static IType SHORT_TYPE = null;
    private static IType CALENDAR_TYPE = null;
    private static IType CALENDAR_DATE_TYPE = null;
    private static IType INTEGER_TYPE = null;
    private static IType BIG_DECIMAL_TYPE = null;
    private static IType CHARACTER_TYPE = null;
    private static IType CLASS_TYPE = null;
    private static IType CURRENCY_TYPE = null;
    private static IType DATE_TYPE = null;
    private static IType DOUBLE_TYPE = null;
    private static IType FLOAT_TYPE = null;
    private static IType LOCALE_TYPE = null;
    private static IType LONG_TYPE = null;
    private static IType STRING_TYPE = null;
    private static IType TEXT_TYPE = null;
    private static IType TIME_TYPE = null;
    private static IType TIMESTAMP_TYPE = null;
    private static IType TIMEZONE_TYPE = null;
    private static IType TRUE_FALSE_TYPE = null;
    private static IType YES_NO_TYPE = null;
    protected Map<IType, String> typeFormats = null;
    protected Object typeRegistry = null;

    public AbstractTypeFactoryFacade(IFacadeFactory facadeFactory, Object target) {
        super(facadeFactory, target);
    }

    public IType getBooleanType() {
        if (BOOLEAN_TYPE == null) {
            BOOLEAN_TYPE = this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "BOOLEAN", null));
        }
        return BOOLEAN_TYPE;
    }

    public IType getByteType() {
        if (BYTE_TYPE == null) {
            BYTE_TYPE = this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "BYTE", null));
        }
        return BYTE_TYPE;
    }

    public IType getBigIntegerType() {
        if (BIG_INTEGER_TYPE == null) {
            BIG_INTEGER_TYPE = this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "BIG_INTEGER", null));
        }
        return BIG_INTEGER_TYPE;
    }

    public IType getShortType() {
        if (SHORT_TYPE == null) {
            SHORT_TYPE = this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "SHORT", null));
        }
        return SHORT_TYPE;
    }

    public IType getCalendarType() {
        if (CALENDAR_TYPE == null) {
            CALENDAR_TYPE = this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "CALENDAR", null));
        }
        return CALENDAR_TYPE;
    }

    public IType getCalendarDateType() {
        if (CALENDAR_DATE_TYPE == null) {
            CALENDAR_DATE_TYPE = this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "CALENDAR_DATE", null));
        }
        return CALENDAR_DATE_TYPE;
    }

    public IType getIntegerType() {
        if (INTEGER_TYPE == null) {
            INTEGER_TYPE = this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "INTEGER", null));
        }
        return INTEGER_TYPE;
    }

    public IType getBigDecimalType() {
        if (BIG_DECIMAL_TYPE == null) {
            BIG_DECIMAL_TYPE = this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "BIG_DECIMAL", null));
        }
        return BIG_DECIMAL_TYPE;
    }

    public IType getCharacterType() {
        if (CHARACTER_TYPE == null) {
            CHARACTER_TYPE = this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "CHARACTER", null));
        }
        return CHARACTER_TYPE;
    }

    public IType getClassType() {
        if (CLASS_TYPE == null) {
            CLASS_TYPE = this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "CLASS", null));
        }
        return CLASS_TYPE;
    }

    public IType getCurrencyType() {
        if (CURRENCY_TYPE == null) {
            CURRENCY_TYPE = this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "CURRENCY", null));
        }
        return CURRENCY_TYPE;
    }

    public IType getDateType() {
        if (DATE_TYPE == null) {
            DATE_TYPE = this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "DATE", null));
        }
        return DATE_TYPE;
    }

    public IType getDoubleType() {
        if (DOUBLE_TYPE == null) {
            DOUBLE_TYPE = this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "DOUBLE", null));
        }
        return DOUBLE_TYPE;
    }

    public IType getFloatType() {
        if (FLOAT_TYPE == null) {
            FLOAT_TYPE = this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "FLOAT", null));
        }
        return FLOAT_TYPE;
    }

    public IType getLocaleType() {
        if (LOCALE_TYPE == null) {
            LOCALE_TYPE = this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "LOCALE", null));
        }
        return LOCALE_TYPE;
    }

    public IType getLongType() {
        if (LONG_TYPE == null) {
            LONG_TYPE = this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "LONG", null));
        }
        return LONG_TYPE;
    }

    public IType getStringType() {
        if (STRING_TYPE == null) {
            STRING_TYPE = this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "STRING", null));
        }
        return STRING_TYPE;
    }

    public IType getTextType() {
        if (TEXT_TYPE == null) {
            TEXT_TYPE = this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "TEXT", null));
        }
        return TEXT_TYPE;
    }

    public IType getTimeType() {
        if (TIME_TYPE == null) {
            TIME_TYPE = this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "TIME", null));
        }
        return TIME_TYPE;
    }

    public IType getTimestampType() {
        if (TIMESTAMP_TYPE == null) {
            TIMESTAMP_TYPE = this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "TIMESTAMP", null));
        }
        return TIMESTAMP_TYPE;
    }

    public IType getTimezoneType() {
        if (TIMEZONE_TYPE == null) {
            TIMEZONE_TYPE = this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "TIMEZONE", null));
        }
        return TIMEZONE_TYPE;
    }

    public IType getTrueFalseType() {
        if (TRUE_FALSE_TYPE == null) {
            TRUE_FALSE_TYPE = this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "TRUE_FALSE", null));
        }
        return TRUE_FALSE_TYPE;
    }

    public IType getYesNoType() {
        if (YES_NO_TYPE == null) {
            YES_NO_TYPE = this.getFacadeFactory().createType(Util.getFieldValue(this.getStandardBasicTypesClass(), "YES_NO", null));
        }
        return YES_NO_TYPE;
    }

    public Map<IType, String> getTypeFormats() {
        if (this.typeFormats == null) {
            this.initializeTypeFormats();
        }
        return this.typeFormats;
    }

    public IType getNamedType(String typeName) {
        Object typeTarget = Util.invokeMethod(this.getTypeRegistry(), "getRegisteredType", new Class[]{String.class}, new Object[]{typeName});
        return this.getFacadeFactory().createType(typeTarget);
    }

    public IType getBasicType(String typeName) {
        return this.getNamedType(typeName);
    }

    protected Class<?> getStandardBasicTypesClass() {
        return Util.getClass(this.getStandardBasicTypesClassName(), this.getFacadeFactoryClassLoader());
    }

    protected String getStandardBasicTypesClassName() {
        return "org.hibernate.type.StandardBasicTypes";
    }

    protected void initializeTypeFormats() {
        this.typeFormats = new HashMap<IType, String>();
        this.addTypeFormat(this.getBooleanType(), Boolean.TRUE);
        this.addTypeFormat(this.getByteType(), (byte)42);
        this.addTypeFormat(this.getBigIntegerType(), BigInteger.valueOf(42L));
        this.addTypeFormat(this.getShortType(), (short)42);
        this.addTypeFormat(this.getCalendarType(), new GregorianCalendar());
        this.addTypeFormat(this.getCalendarDateType(), new GregorianCalendar());
        this.addTypeFormat(this.getIntegerType(), 42);
        this.addTypeFormat(this.getBigDecimalType(), new BigDecimal(42.0));
        this.addTypeFormat(this.getCharacterType(), Character.valueOf('h'));
        this.addTypeFormat(this.getClassType(), ITable.class);
        this.addTypeFormat(this.getCurrencyType(), Currency.getInstance(Locale.getDefault()));
        this.addTypeFormat(this.getDateType(), new Date());
        this.addTypeFormat(this.getDoubleType(), 42.42);
        this.addTypeFormat(this.getFloatType(), Float.valueOf(42.42f));
        this.addTypeFormat(this.getLocaleType(), Locale.getDefault());
        this.addTypeFormat(this.getLongType(), 42L);
        this.addTypeFormat(this.getStringType(), "a string");
        this.addTypeFormat(this.getTextType(), "a text");
        this.addTypeFormat(this.getTimeType(), new Date());
        this.addTypeFormat(this.getTimestampType(), new Date());
        this.addTypeFormat(this.getTimezoneType(), TimeZone.getDefault());
        this.addTypeFormat(this.getTrueFalseType(), Boolean.TRUE);
        this.addTypeFormat(this.getYesNoType(), Boolean.TRUE);
    }

    protected void addTypeFormat(IType type, Object value) {
        this.typeFormats.put(type, type.toString(value));
    }

    protected Object getTypeRegistry() {
        if (this.typeRegistry == null) {
            this.typeRegistry = Util.getInstance(this.getTypeRegistryClassName(), this.getFacadeFactoryClassLoader());
        }
        return this.typeRegistry;
    }

    protected String getTypeRegistryClassName() {
        return "org.hibernate.type.BasicTypeRegistry";
    }
}

