/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.runtime.v_5_1.internal;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Environment;
import org.hibernate.engine.jdbc.dialect.spi.DialectFactory;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.util.MetadataHelper;
import org.jboss.tools.hibernate.runtime.common.AbstractConfigurationFacade;
import org.jboss.tools.hibernate.runtime.common.IFacadeFactory;
import org.jboss.tools.hibernate.runtime.spi.IConfiguration;
import org.jboss.tools.hibernate.runtime.spi.INamingStrategy;
import org.jboss.tools.hibernate.runtime.spi.IPersistentClass;
import org.jboss.tools.hibernate.runtime.spi.ITable;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;

public class ConfigurationFacadeImpl
extends AbstractConfigurationFacade {
    EntityResolver entityResolver = null;
    INamingStrategy namingStrategy = null;
    ArrayList<IPersistentClass> addedClasses = new ArrayList();

    public ConfigurationFacadeImpl(IFacadeFactory facadeFactory, Object target) {
        super(facadeFactory, target);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setNamingStrategy(INamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public IConfiguration configure(Document document) {
        File tempFile = null;
        IConfiguration result = null;
        try {
            try {
                tempFile = File.createTempFile(document.toString(), "cfg.xml");
                DOMSource domSource = new DOMSource(document);
                StringWriter stringWriter = new StringWriter();
                StreamResult stream = new StreamResult(stringWriter);
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                transformer.transform(domSource, stream);
                FileWriter fileWriter = new FileWriter(tempFile);
                fileWriter.write(stringWriter.toString());
                fileWriter.close();
                result = this.configure(tempFile);
            }
            catch (IOException | TransformerException e) {
                throw new RuntimeException("Problem while configuring", e);
            }
        }
        finally {
            tempFile.delete();
        }
        return result;
    }

    public void addClass(IPersistentClass persistentClass) {
        this.addedClasses.add(persistentClass);
    }

    public void buildMappings() {
        this.getMetadata();
    }

    public INamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setProperty(String name, String value) {
        if ("hibernate.hbm2ddl.auto".equals(name) && "false".equals(value)) {
            return;
        }
        super.setProperty(name, value);
    }

    public String getDefaultCatalogName() {
        return Environment.getProperties().getProperty("hibernate.default_catalog");
    }

    public String getDefaultSchemaName() {
        return Environment.getProperties().getProperty("hibernate.default_schema");
    }

    protected Object createTargetMapping() {
        return this.getMetadata();
    }

    protected void initializeClassMappings() {
        HashMap<String, IPersistentClass> classMappings = new HashMap<String, IPersistentClass>();
        Iterator origin = this.getMetadata().getEntityBindings().iterator();
        while (origin.hasNext()) {
            IPersistentClass pc = this.getFacadeFactory().createPersistentClass(origin.next());
            classMappings.put(pc.getEntityName(), pc);
        }
        for (IPersistentClass pc : this.addedClasses) {
            classMappings.put(pc.getEntityName(), pc);
        }
        this.setClassMappings(classMappings);
    }

    protected void initializeTableMappings() {
        HashSet<ITable> tableMappings = new HashSet<ITable>();
        Iterator origin = this.getMetadata().collectTableMappings().iterator();
        while (origin.hasNext()) {
            ITable table = this.getFacadeFactory().createTable(origin.next());
            tableMappings.add(table);
        }
        this.setTableMappings(tableMappings);
    }

    protected Object buildTargetDialect() {
        return ((DialectFactory)this.buildServiceRegistry().getService(DialectFactory.class)).buildDialect((Map)this.getProperties(), null);
    }

    private ServiceRegistry buildServiceRegistry() {
        StandardServiceRegistryBuilder builder = new StandardServiceRegistryBuilder();
        builder.applySettings((Map)((Configuration)this.getTarget()).getProperties());
        return builder.build();
    }

    private Metadata getMetadata() {
        return MetadataHelper.getMetadata((Configuration)((Configuration)this.getTarget()));
    }
}

