/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.core.tree;

import java.io.IOException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.jmx.core.IAsyncRefreshable;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.core.IJMXRunnable;
import org.jboss.tools.jmx.core.JMXActivator;
import org.jboss.tools.jmx.core.MBeanInfoWrapper;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.core.tree.PropertyNode;
import org.jboss.tools.jmx.core.tree.Root;

public class ObjectNameNode
extends PropertyNode
implements IAsyncRefreshable {
    private ObjectName on;
    private Exception loadError;
    private MBeanInfoWrapper wrapper;

    public ObjectNameNode(Node parent, String key, String value, ObjectName on) {
        this(parent, key, value, on, null);
    }

    public ObjectNameNode(Node parent, String key, String value, ObjectName on, MBeanServerConnection mbsc) {
        this(parent, key, value, on, mbsc, true);
    }

    public ObjectNameNode(Node parent, String key, String value, ObjectName on, MBeanServerConnection mbsc, boolean lazy) {
        super(parent, key, value);
        this.on = on;
        if (!lazy) {
            this.loadInfo(mbsc);
        }
    }

    private synchronized void loadInfo(MBeanServerConnection mbsc) {
        this.loadInfo(mbsc, (IProgressMonitor)new NullProgressMonitor());
    }

    private synchronized void loadInfo(MBeanServerConnection mbsc, IProgressMonitor mon) {
        mon.beginTask("Loading Object Name Node " + this.on.getCanonicalName(), 100);
        mon.worked(5);
        Root root = ObjectNameNode.getRoot(this.parent);
        IConnectionWrapper connectionWrapper = root.getConnection();
        final MBeanInfoWrapper[] array = new MBeanInfoWrapper[1];
        try {
            if (mbsc != null) {
                array[0] = this.loadInfoInternal(mbsc);
            } else {
                connectionWrapper.run(new IJMXRunnable(){

                    @Override
                    public void run(MBeanServerConnection mbsc) throws Exception {
                        array[0] = ObjectNameNode.this.loadInfoInternal(mbsc);
                    }
                });
            }
            mon.worked(95);
        }
        catch (Exception e) {
            JMXActivator.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.jmx.core", "Error loading object name details for JMX object: " + this.on.toString(), (Throwable)e));
            this.loadError = e;
        }
        mon.done();
        this.wrapper = array[0];
    }

    private synchronized MBeanInfoWrapper loadInfoInternal(MBeanServerConnection mbsc) throws Exception {
        ObjectName on2 = this.on;
        MBeanInfo mbi = null;
        try {
            mbi = mbsc.getMBeanInfo(on2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (mbi != null) {
            return new MBeanInfoWrapper(on2, mbi, mbsc, this);
        }
        return null;
    }

    public boolean hasLoadError() {
        return this.loadError != null;
    }

    public ObjectName getObjectName() {
        return this.on;
    }

    public synchronized MBeanInfoWrapper getMbeanInfoWrapper() {
        return this.getMbeanInfoWrapper((IProgressMonitor)new NullProgressMonitor());
    }

    public synchronized MBeanInfoWrapper getMbeanInfoWrapper(IProgressMonitor mon) {
        if (this.wrapper == null) {
            this.loadInfo(null, mon);
        }
        return this.wrapper;
    }

    public boolean isLoaded() {
        return this.wrapper != null || this.loadError != null;
    }

    @Override
    public String toString() {
        return "ObjectNameNode[on=" + this.on.getKeyPropertyListString() + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.on == null ? 0 : this.on.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ObjectNameNode)) {
            return false;
        }
        ObjectNameNode other = (ObjectNameNode)obj;
        return !(this.on == null ? other.on != null : !this.on.equals(other.on));
    }

    private void refreshInternal(IAsyncRefreshable.ICallback cb) {
        this.wrapper = null;
        this.loadInfo(null);
        cb.refreshComplete();
    }

    @Override
    public void refresh(final IAsyncRefreshable.ICallback cb) {
        new Thread("Refresh JMX Node"){

            @Override
            public void run() {
                ObjectNameNode.this.refreshInternal(cb);
            }
        }.start();
    }
}

