/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.jolokia.internal.connection;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import org.jboss.tools.jmx.jolokia.internal.Activator;
import org.jboss.tools.jmx.jolokia.internal.connection.JolokiaJavaTypeConverter;
import org.jboss.tools.jmx.jolokia.internal.connection.JolokiaMBeanUtility;
import org.jolokia.client.J4pClient;
import org.jolokia.client.exception.J4pException;
import org.jolokia.client.request.J4pExecRequest;
import org.jolokia.client.request.J4pExecResponse;
import org.jolokia.client.request.J4pListRequest;
import org.jolokia.client.request.J4pListResponse;
import org.jolokia.client.request.J4pQueryParameter;
import org.jolokia.client.request.J4pReadRequest;
import org.jolokia.client.request.J4pReadResponse;
import org.jolokia.client.request.J4pRequest;
import org.jolokia.client.request.J4pResponse;
import org.jolokia.client.request.J4pSearchRequest;
import org.jolokia.client.request.J4pSearchResponse;
import org.jolokia.client.request.J4pWriteRequest;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class JolokiaMBeanServerConnection
implements MBeanServerConnection {
    private J4pClient j4pClient;
    private String type;
    private JolokiaJavaTypeConverter converter = new JolokiaJavaTypeConverter();

    public JolokiaMBeanServerConnection(J4pClient j4pClient, String type) {
        this.j4pClient = j4pClient;
        this.type = type;
    }

    @Override
    public String getDefaultDomain() throws IOException {
        throw new IOException("Unsupported");
    }

    @Override
    public String[] getDomains() throws IOException {
        try {
            Set<ObjectName> on = this.queryNames(new ObjectName("*:*"), null);
            return (String[])on.stream().map(ObjectName::getDomain).toArray(String[]::new);
        }
        catch (MalformedObjectNameException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Integer getMBeanCount() throws IOException {
        try {
            return this.queryNames(new ObjectName("*:*"), null).size();
        }
        catch (MalformedObjectNameException e) {
            throw new IOException(e);
        }
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        try {
            J4pListRequest request = new J4pListRequest(name);
            J4pListResponse resp = (J4pListResponse)this.j4pClient.execute((J4pRequest)request, this.type);
            JSONObject o = (JSONObject)resp.getValue();
            return new JolokiaMBeanUtility().createMBeanInfoFromSingletonList(o);
        }
        catch (J4pException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean isRegistered(ObjectName name) throws IOException {
        return !this.queryNames(name, null).isEmpty();
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) throws IOException {
        try {
            J4pSearchRequest request = new J4pSearchRequest(name.getCanonicalName());
            EnumMap<J4pQueryParameter, String> processingOptions = new EnumMap<J4pQueryParameter, String>(J4pQueryParameter.class);
            processingOptions.put(J4pQueryParameter.CANONICAL_NAMING, Boolean.FALSE.toString());
            J4pSearchResponse resp = (J4pSearchResponse)this.j4pClient.execute((J4pRequest)request, this.type, processingOptions);
            HashSet<ObjectName> toFilter = new HashSet<ObjectName>(resp.getObjectNames());
            return toFilter;
        }
        catch (MalformedObjectNameException | J4pException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        J4pWriteRequest req = new J4pWriteRequest(name, attribute.getName(), this.converter.getJson(attribute.getValue()), new String[0]);
        try {
            J4pResponse r = this.j4pClient.execute((J4pRequest)req, this.type);
            Object o = r.asJSONObject().get((Object)"status");
            if (o != null && !o.equals(200L)) {
                throw new IOException("Failed to update attribute " + attribute.getName() + " on object " + name.getCanonicalName());
            }
        }
        catch (J4pException e) {
            throw new IOException(e);
        }
    }

    @Override
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        AttributeList result = new AttributeList();
        for (Attribute attribute : attributes.asList()) {
            try {
                this.setAttribute(name, attribute);
                result.add(attribute);
            }
            catch (AttributeNotFoundException | InvalidAttributeValueException | MBeanException e) {
                Activator.pluginLog().logError((Throwable)e);
            }
        }
        return result;
    }

    @Override
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        AttributeList l = this.getAttributes(name, new String[]{attribute});
        if (!l.isEmpty()) {
            return l.get(0);
        }
        return null;
    }

    @Override
    public AttributeList getAttributes(ObjectName name, String[] attributeNames) throws InstanceNotFoundException, ReflectionException, IOException {
        List<MBeanAttributeInfo> attributesInfos = this.getAttributesInfos(name);
        AttributeList al = new AttributeList();
        J4pReadRequest req = new J4pReadRequest(name, attributeNames);
        J4pResponse response = null;
        try {
            response = this.j4pClient.execute((J4pRequest)req, this.type);
        }
        catch (J4pException e) {
            throw new IOException(e);
        }
        if (response instanceof List) {
            List resp = (List)response;
            Iterator c = resp.iterator();
            while (c.hasNext()) {
                al.addAll((Collection<?>)this.extractAttributesFromResponse(attributesInfos, (J4pResponse)c.next()));
            }
        } else if (response instanceof J4pReadResponse) {
            if (attributeNames.length == 1) {
                MBeanAttributeInfo mBeanAttributeInfo = this.findAttributeInfoWithName(attributesInfos, attributeNames[0]);
                al.add(this.converter.getConvertedToCorrectTypeReturnedValue(mBeanAttributeInfo, ((J4pReadResponse)response).getValue()));
            } else {
                al.addAll((Collection<?>)this.extractAttributesFromResponse(attributesInfos, (J4pResponse<?>)((J4pReadResponse)response)));
            }
        }
        return al;
    }

    private List<MBeanAttributeInfo> getAttributesInfos(ObjectName name) throws InstanceNotFoundException, ReflectionException, IOException {
        try {
            MBeanInfo mBeanInfo = this.getMBeanInfo(name);
            return Arrays.asList(mBeanInfo.getAttributes());
        }
        catch (IntrospectionException e) {
            Activator.pluginLog().logError((Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<Object> extractAttributesFromResponse(List<MBeanAttributeInfo> attributesInfos, J4pResponse<?> response) {
        ArrayList<Object> extractedAttributes = new ArrayList<Object>();
        Object o22 = response.getValue();
        if (o22 instanceof JSONObject) {
            Set entrySet = ((JSONObject)o22).entrySet();
            for (Map.Entry entry : entrySet) {
                String attributeName = (String)entry.getKey();
                MBeanAttributeInfo mBeanAttributeInfo = this.findAttributeInfoWithName(attributesInfos, attributeName);
                Object jolokiaReturnedValue = entry.getValue();
                Object convertedToCorrectTypeReturnedValue = this.converter.getConvertedToCorrectTypeReturnedValue(mBeanAttributeInfo, jolokiaReturnedValue);
                extractedAttributes.add(new Attribute(attributeName, convertedToCorrectTypeReturnedValue));
            }
        } else {
            extractedAttributes.add(o22);
        }
        return extractedAttributes;
    }

    private MBeanAttributeInfo findAttributeInfoWithName(List<MBeanAttributeInfo> attributesInfos, String attributeName) {
        return attributesInfos.parallelStream().filter(attributeInfo -> attributeName.equals(attributeInfo.getName())).findAny().orElse(null);
    }

    @Override
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        String operationNameWithSignature = this.createOperationNameWithSignature(operationName, signature);
        String specifiedReturnedType = this.getSpecifiedReturnedType(name, operationName, params);
        J4pExecRequest req = this.createJ4pExecRequest(name, params, operationNameWithSignature);
        try {
            J4pExecResponse resp = (J4pExecResponse)this.j4pClient.execute((J4pRequest)req, this.type);
            return this.converter.getConvertedToCorrectType(resp.getValue(), specifiedReturnedType);
        }
        catch (J4pException e) {
            throw new IOException("Operation Signature of failed request: " + operationNameWithSignature, e);
        }
    }

    private String getSpecifiedReturnedType(ObjectName name, String operationName, Object[] params) throws InstanceNotFoundException, ReflectionException, IOException {
        try {
            MBeanInfo mBeanInfo = this.getMBeanInfo(name);
            if (mBeanInfo != null && params != null) {
                List operations = Arrays.asList(mBeanInfo.getOperations()).stream().filter(operationInfo -> operationName.equals(operationInfo.getName())).filter(operationInfo -> operationInfo.getSignature() != null && params.length == operationInfo.getSignature().length).collect(Collectors.toList());
                if (operations.size() == 1) {
                    return ((MBeanOperationInfo)operations.get(0)).getReturnType();
                }
                Activator.pluginLog().logInfo("Method invocation of " + operationName + " might return the wrong Return Type due to current implementation limitations.");
            }
        }
        catch (IntrospectionException e1) {
            Activator.pluginLog().logError((Throwable)e1);
        }
        return null;
    }

    private J4pExecRequest createJ4pExecRequest(ObjectName name, Object[] params, String operationNameWithSignature) {
        if (params == null || params.length == 0) {
            return new J4pExecRequest(name, operationNameWithSignature, new Object[0]);
        }
        return new J4pExecRequest(name, operationNameWithSignature, params);
    }

    private String createOperationNameWithSignature(String operationName, String[] signature) {
        StringJoiner stringJoiner = new StringJoiner(",", "(", ")");
        Stream.of(signature).forEach(stringJoiner::add);
        return String.valueOf(operationName) + stringJoiner.toString();
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException, IOException {
        return this.createObjectInstance(name);
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) throws IOException {
        HashSet<ObjectInstance> res = new HashSet<ObjectInstance>();
        try {
            J4pSearchRequest req = new J4pSearchRequest(name.getCanonicalName());
            J4pResponse j4pResponse = this.j4pClient.execute((J4pRequest)req, this.type);
            Object value = j4pResponse.getValue();
            if (value instanceof JSONArray) {
                for (Object mbean : (JSONArray)value) {
                    if (!(mbean instanceof String)) continue;
                    res.add(this.createObjectInstance((String)mbean));
                }
            }
        }
        catch (MalformedObjectNameException | J4pException e) {
            Activator.pluginLog().logError(e);
        }
        return res;
    }

    private ObjectInstance createObjectInstance(String mbean) throws MalformedObjectNameException {
        ObjectName objectName = new ObjectName(mbean);
        return this.createObjectInstance(objectName);
    }

    private ObjectInstance createObjectInstance(ObjectName objectName) {
        String classname = this.retrieveClassName(objectName);
        return new ObjectInstance(objectName, classname);
    }

    private String retrieveClassName(ObjectName objectName) {
        String escapedCanonicalPropertyList = objectName.getCanonicalKeyPropertyListString().replaceAll("/", "!/");
        J4pListRequest listAttributes = new J4pListRequest(String.valueOf(objectName.getDomain()) + "/" + escapedCanonicalPropertyList + "/class");
        try {
            J4pResponse listAttributesResponse = this.j4pClient.execute((J4pRequest)listAttributes, this.type);
            return (String)listAttributesResponse.getValue();
        }
        catch (J4pException e) {
            Activator.pluginLog().logError((Throwable)e);
            return "";
        }
    }

    @Override
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException, IOException {
        String mBeanClass = this.retrieveClassName(name);
        if (className != null && className.equals(mBeanClass)) {
            return true;
        }
        try {
            return Class.forName(mBeanClass).isInstance(Class.forName(className));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    @Override
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, IOException {
        return null;
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        return null;
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, IOException {
        return null;
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        return null;
    }

    @Override
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
    }

    @Override
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
    }
}

