/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.ui;

import javax.management.MBeanServerConnection;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.jboss.tools.foundation.ui.plugin.BaseUIPlugin;
import org.jboss.tools.foundation.ui.plugin.BaseUISharedImages;
import org.jboss.tools.jmx.ui.internal.adapters.JMXAdapterFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class JMXUIActivator
extends BaseUIPlugin {
    public static final String PLUGIN_ID = "org.jboss.tools.jmx.ui";
    private static JMXUIActivator plugin;
    private JMXAdapterFactory adapterFactory;
    private MBeanServerConnection connection;
    public static final String CONNECT_DEBUGGER_SHARED_IMAGE = "icons/full/obj16/debug_view.gif";

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.registerAdapters();
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        this.unregisterAdapters();
        super.stop(context);
    }

    public static JMXUIActivator getDefault() {
        return plugin;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = JMXUIActivator.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return JMXUIActivator.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        return JMXUIActivator.getDefault().internalGetActivePage();
    }

    private IWorkbenchPage internalGetActivePage() {
        IWorkbenchWindow window = this.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    public void setCurrentConnection(MBeanServerConnection connection) {
        this.connection = connection;
    }

    public MBeanServerConnection getCurrentConnection() {
        return this.connection;
    }

    public static void log(IStatus status) {
        JMXUIActivator.getDefault().getLog().log(status);
    }

    public static void log(int severity, String message, Throwable e) {
        JMXUIActivator.log((IStatus)new Status(severity, PLUGIN_ID, 0, message, e));
    }

    private void registerAdapters() {
        this.adapterFactory = new JMXAdapterFactory();
        Class<?>[] classArray = this.adapterFactory.getAdapterClasses();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> aClass = classArray[n2];
            Platform.getAdapterManager().registerAdapters((IAdapterFactory)this.adapterFactory, aClass);
            ++n2;
        }
    }

    private void unregisterAdapters() {
        Class<?>[] classArray = this.adapterFactory.getAdapterClasses();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> aClass = classArray[n2];
            Platform.getAdapterManager().unregisterAdapters((IAdapterFactory)this.adapterFactory, aClass);
            ++n2;
        }
    }

    protected BaseUISharedImages createSharedImages() {
        return new JMXUISharedImages(this.getBundle());
    }

    private static class JMXUISharedImages
    extends BaseUISharedImages {
        public JMXUISharedImages(Bundle pluginBundle) {
            super(pluginBundle);
            this.addImage(JMXUIActivator.CONNECT_DEBUGGER_SHARED_IMAGE, JMXUIActivator.CONNECT_DEBUGGER_SHARED_IMAGE);
        }
    }
}

