/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.ui;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jboss.tools.foundation.ui.xpl.taskwizard.WizardFragment;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.ui.JMXUIActivator;
import org.jboss.tools.jmx.ui.Messages;

public class UIExtensionManager {
    private static final String CONNECTION_UI_EXT_PT = "org.jboss.tools.jmx.ui.providerUI";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String ICON = "icon";
    private static final String CLASS = "class";
    private static final String EDITABLE = "editable";
    private static HashMap<String, ConnectionProviderUI> connectionUIElements;
    private static HashMap<String, ConnectionCategoryUI> connectionCategoryUIElements;

    private static void ensureLoaded() {
        if (connectionUIElements == null) {
            UIExtensionManager.loadConnectionUI();
        }
        if (connectionCategoryUIElements == null) {
            UIExtensionManager.loadConnectionCategoryUI();
        }
    }

    public static HashMap<String, ConnectionProviderUI> getConnectionUIElements() {
        UIExtensionManager.ensureLoaded();
        return connectionUIElements;
    }

    public static ConnectionProviderUI getConnectionProviderUI(String id) {
        UIExtensionManager.ensureLoaded();
        return connectionUIElements.get(id);
    }

    public static ConnectionCategoryUI getConnectionCategoryUI(String id) {
        UIExtensionManager.ensureLoaded();
        return connectionCategoryUIElements.get(id);
    }

    private static void loadConnectionUI() {
        HashMap<String, ConnectionProviderUI> map = new HashMap<String, ConnectionProviderUI>();
        IExtension[] extensions = UIExtensionManager.findExtension(CONNECTION_UI_EXT_PT);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                if (elements[j].getName().equals("providerUI")) {
                    try {
                        ConnectionProviderUI pUI = new ConnectionProviderUI(elements[j]);
                        map.put(pUI.getId(), pUI);
                    }
                    catch (InvalidRegistryObjectException invalidRegistryObjectException) {
                        // empty catch block
                    }
                }
                ++j;
            }
            ++i;
        }
        connectionUIElements = map;
    }

    private static void loadConnectionCategoryUI() {
        HashMap<String, ConnectionCategoryUI> map = new HashMap<String, ConnectionCategoryUI>();
        IExtension[] extensions = UIExtensionManager.findExtension(CONNECTION_UI_EXT_PT);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                if (elements[j].getName().equals("providerCategoryUI")) {
                    try {
                        ConnectionCategoryUI pUI = new ConnectionCategoryUI(elements[j]);
                        map.put(pUI.getId(), pUI);
                    }
                    catch (InvalidRegistryObjectException invalidRegistryObjectException) {
                        // empty catch block
                    }
                }
                ++j;
            }
            ++i;
        }
        connectionCategoryUIElements = map;
    }

    private static IExtension[] findExtension(String extensionId) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(extensionId);
        return extensionPoint.getExtensions();
    }

    public static class ConnectionCategoryUI {
        String id;
        String name;
        String icon;
        ImageDescriptor imageDescriptor;

        public ConnectionCategoryUI(IConfigurationElement element) {
            this.id = element.getAttribute(UIExtensionManager.ID);
            this.name = element.getAttribute(UIExtensionManager.NAME);
            this.icon = element.getAttribute(UIExtensionManager.ICON);
            String pluginName = element.getDeclaringExtension().getContributor().getName();
            this.imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginName, (String)this.icon);
            if (this.imageDescriptor == null) {
                Status s = new Status(2, "org.jboss.tools.jmx.ui", NLS.bind((String)Messages.JMXUIImageDescriptorNotFound, (Object)this.icon, (Object)pluginName));
                JMXUIActivator.log((IStatus)s);
            }
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getIcon() {
            return this.icon;
        }

        public ImageDescriptor getImageDescriptor() {
            return this.imageDescriptor;
        }
    }

    public static class ConnectionProviderUI
    extends ConnectionCategoryUI {
        String id;
        String name;
        String icon;
        boolean editable;
        IConfigurationElement labelProviderElement;
        ILabelProvider labelProvider;
        IConfigurationElement rootFragment;
        ImageDescriptor imageDescriptor;

        public ConnectionProviderUI(IConfigurationElement element) {
            super(element);
            this.editable = Boolean.parseBoolean(element.getAttribute(UIExtensionManager.EDITABLE));
            IConfigurationElement[] children = element.getChildren();
            ArrayList wizardPageList = new ArrayList();
            this.labelProviderElement = null;
            boolean multipleFragments = false;
            int i = 0;
            while (i < children.length) {
                if ("wizardFragment".equals(children[i].getName())) {
                    if (this.rootFragment != null && !multipleFragments) {
                        String msg = "providerUI " + element.getAttribute(UIExtensionManager.ID) + " in contributor " + element.getContributor().getName() + " declares more than 1 wizard fragment";
                        JMXUIActivator.log(2, msg, null);
                        multipleFragments = true;
                    }
                    this.rootFragment = children[i];
                } else if ("connectionLabelProvider".equals(children[i].getName())) {
                    this.labelProviderElement = children[i];
                }
                ++i;
            }
        }

        public void dispose() {
            if (this.hasLabelProvider()) {
                this.getLabelProvider().dispose();
                this.labelProvider = null;
            }
        }

        public boolean hasLabelProvider() {
            return this.getLabelProvider() != null;
        }

        public Image getImageForConnection(IConnectionWrapper connection) {
            if (this.hasLabelProvider()) {
                return this.getLabelProvider().getImage((Object)connection);
            }
            return null;
        }

        public String getTextForConnection(IConnectionWrapper connection) {
            if (this.hasLabelProvider()) {
                return this.getLabelProvider().getText((Object)connection);
            }
            return null;
        }

        private ILabelProvider getLabelProvider() {
            if (this.labelProvider == null && this.labelProviderElement != null) {
                try {
                    this.labelProvider = (ILabelProvider)this.labelProviderElement.createExecutableExtension(UIExtensionManager.CLASS);
                }
                catch (CoreException ce) {
                    JMXUIActivator.log(ce.getStatus());
                }
            }
            return this.labelProvider;
        }

        public boolean isEditable() {
            return this.editable;
        }

        public WizardFragment createFragments() {
            try {
                Object o = this.rootFragment.createExecutableExtension(UIExtensionManager.CLASS);
                if (o instanceof WizardFragment) {
                    return (WizardFragment)o;
                }
            }
            catch (CoreException ce) {
                JMXUIActivator.log(ce.getStatus());
            }
            return null;
        }
    }
}

