/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.ui.internal.editors;

import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.core.IJMXRunnable;
import org.jboss.tools.jmx.core.JMXException;
import org.jboss.tools.jmx.core.MBeanOperationInfoWrapper;
import org.jboss.tools.jmx.core.util.StringUtils;
import org.jboss.tools.jmx.ui.JMXUIActivator;
import org.jboss.tools.jmx.ui.Messages;
import org.jboss.tools.jmx.ui.internal.MBeanUtils;
import org.jboss.tools.jmx.ui.internal.dialogs.OperationInvocationResultDialog;

public class OperationDetails
extends AbstractFormPart
implements IDetailsPage {
    private FormToolkit toolkit;
    private Composite container;
    private MBeanOperationInfoWrapper opInfoWrapper;
    private Section section;

    public OperationDetails(IFormPart masterSection) {
    }

    public void createContents(Composite parent) {
        TableWrapLayout layout = new TableWrapLayout();
        parent.setLayout((Layout)layout);
        this.toolkit = this.getManagedForm().getToolkit();
        this.section = this.toolkit.createSection(parent, 448);
        this.section.marginWidth = 10;
        this.section.setText(Messages.OperationDetails_title);
        this.section.setDescription("");
        this.section.setLayoutData((Object)new TableWrapData(256));
        this.container = this.toolkit.createComposite((Composite)this.section);
        this.section.setClient((Control)this.container);
        GridLayout glayout = new GridLayout();
        glayout.marginHeight = 0;
        glayout.marginWidth = 0;
        glayout.numColumns = 2;
        glayout.makeColumnsEqualWidth = false;
        this.container.setLayout((Layout)glayout);
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (obj instanceof MBeanOperationInfoWrapper) {
            MBeanOperationInfoWrapper wrapper = (MBeanOperationInfoWrapper)obj;
            if (wrapper == this.opInfoWrapper) {
                return;
            }
            this.opInfoWrapper = wrapper;
            this.drawInvocationDetails(wrapper);
        } else {
            this.clear();
        }
    }

    public void clear() {
        this.drawInvocationDetails(null);
    }

    protected void drawInvocationDetails(MBeanOperationInfoWrapper wrapper) {
        Control[] childs;
        if (this.container != null && !this.container.isDisposed() && (childs = this.container.getChildren()).length > 0) {
            int i = 0;
            while (i < childs.length) {
                childs[i].dispose();
                ++i;
            }
        }
        if (wrapper == null) {
            return;
        }
        MBeanOperationInfo opInfo = wrapper.getMBeanOperationInfo();
        String desc = opInfo.getDescription();
        if (desc != null) {
            this.section.setDescription(desc);
        }
        Composite operationComposite = this.toolkit.createComposite(this.container, 2048);
        GridLayout gl = new GridLayout(5, false);
        gl.verticalSpacing = 10;
        operationComposite.setLayout((Layout)gl);
        String returnString = opInfo.getReturnType() != null ? StringUtils.toString((String)opInfo.getReturnType()) : "void";
        Label returnTypeLabel = this.toolkit.createLabel(operationComposite, returnString);
        returnTypeLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        InvokeOperationButton invocationButton = new InvokeOperationButton(operationComposite, 8);
        Label leftParenthesis = this.toolkit.createLabel(operationComposite, "(");
        GridData leftParenData = new GridData(1, 0x1000000, false, false);
        leftParenData.horizontalSpan = 3;
        leftParenthesis.setLayoutData((Object)leftParenData);
        MBeanParameterInfo[] params = opInfo.getSignature();
        Text[] textParams = null;
        if (params.length > 0) {
            textParams = new Text[params.length];
            int j = 0;
            while (j < params.length) {
                new Label(operationComposite, 0);
                MBeanParameterInfo param = params[j];
                textParams[j] = new Text(operationComposite, 2052);
                textParams[j].setText(StringUtils.toString((String)param.getType()));
                GridData textData = new GridData(16384, 128, true, true);
                textData.minimumWidth = 100;
                textParams[j].setLayoutData((Object)textData);
                Label name = new Label(operationComposite, 0);
                name.setText(params[j].getName() == null ? "" : params[j].getName());
                name.setLayoutData((Object)new GridData(4, 128, true, true));
                Label paramDesc = new Label(operationComposite, 64);
                paramDesc.setText(params[j].getDescription() == null ? "" : params[j].getDescription());
                GridData gd = new GridData(4, 1024, false, true);
                gd.horizontalSpan = 2;
                gd.widthHint = 250;
                paramDesc.setLayoutData((Object)gd);
                ++j;
            }
        }
        Label rightParenthesis = this.toolkit.createLabel(operationComposite, ")");
        rightParenthesis.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        invocationButton.setTextParams(textParams);
        this.container.pack();
        this.container.layout();
    }

    private class InvokeOperationButton
    extends SelectionAdapter {
        private Text[] textParams;
        private Button button;

        public InvokeOperationButton(Composite parent, int style) {
            this.button = OperationDetails.this.toolkit.createButton(parent, OperationDetails.this.opInfoWrapper.getMBeanOperationInfo().getName(), style);
            this.button.addSelectionListener((SelectionListener)this);
            this.button.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        }

        void setTextParams(Text[] textParams) {
            this.textParams = textParams;
        }

        public void widgetSelected(SelectionEvent event) {
            String[] strs;
            String[] stringArray = strs = this.textParams == null ? null : new String[this.textParams.length];
            if (this.textParams != null) {
                int i = 0;
                while (i < strs.length) {
                    strs[i] = this.textParams[i].getText();
                    ++i;
                }
            }
            new Thread(){

                @Override
                public void run() {
                    IConnectionWrapper connection = OperationDetails.this.opInfoWrapper.getMBeanInfoWrapper().getParent().getConnection();
                    try {
                        connection.run(new IJMXRunnable(){

                            public void run(MBeanServerConnection connection) throws Exception {
                                InvokeOperationButton.this.widgetSelected2(connection, strs);
                            }
                        });
                    }
                    catch (JMXException jMXException) {
                        // empty catch block
                    }
                }
            }.start();
        }

        protected void widgetSelected2(MBeanServerConnection connection, String[] strs) {
            try {
                Object result;
                MBeanParameterInfo[] paramInfos = OperationDetails.this.opInfoWrapper.getMBeanOperationInfo().getSignature();
                Object[] paramList = null;
                if (this.textParams != null) {
                    paramList = MBeanUtils.getParameters((String[])strs, (MBeanParameterInfo[])paramInfos);
                }
                ObjectName objectName = OperationDetails.this.opInfoWrapper.getObjectName();
                String methodName = OperationDetails.this.opInfoWrapper.getMBeanOperationInfo().getName();
                if (paramList != null) {
                    String[] paramSig = new String[paramInfos.length];
                    int i = 0;
                    while (i < paramSig.length) {
                        paramSig[i] = paramInfos[i].getType();
                        ++i;
                    }
                    result = connection.invoke(objectName, methodName, paramList, paramSig);
                } else {
                    result = connection.invoke(objectName, methodName, new Object[0], new String[0]);
                }
                if ("void".equals(OperationDetails.this.opInfoWrapper.getMBeanOperationInfo().getReturnType())) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openInformation((Shell)OperationDetails.this.container.getShell(), (String)Messages.OperationDetails_invocationResult, (String)Messages.OperationDetails_invocationSuccess);
                        }
                    });
                    return;
                }
                final Object result2 = result;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        OperationInvocationResultDialog.open(OperationDetails.this.container.getShell(), result2);
                    }
                });
            }
            catch (Exception e) {
                String message = String.valueOf(e.getClass().getName()) + ": " + e.getLocalizedMessage();
                JMXUIActivator.log(4, e.getClass().getName(), e);
                if (e.getCause() != null) {
                    message = String.valueOf(e.getCause().getClass().getName()) + ": " + e.getCause().getLocalizedMessage();
                }
                final String message2 = message;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)OperationDetails.this.container.getShell(), (String)Messages.OperationDetails_invocationError, (String)message2);
                    }
                });
            }
        }
    }
}

