/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.text.ext.hyperlink;

import java.text.MessageFormat;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IRegion;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jsf.text.ext.JSFTextExtMessages;
import org.jboss.tools.jst.web.project.list.WebPromptingProvider;
import org.jboss.tools.jst.web.ui.internal.text.ext.util.TaglibManagerWrapper;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JsfJSPTagAttributeHyperlink
extends AbstractHyperlink {
    protected void doHyperlink(IRegion region) {
        IFile documentFile = this.getFile();
        XModel xModel = JsfJSPTagAttributeHyperlink.getXModel((IFile)documentFile);
        if (xModel == null) {
            this.openFileFailed();
            return;
        }
        WebPromptingProvider provider = WebPromptingProvider.getInstance();
        Properties p = this.getRequestProperties(region);
        p.put("file", documentFile);
        List list = provider.getList(xModel, "jsf.open.taglibrary", p.getProperty("prefix"), p);
        if (list != null && list.size() >= 1) {
            this.openFileInEditor((String)list.get(0));
            return;
        }
        String error = p.getProperty("error");
        if (error != null && error.length() > 0) {
            this.openFileFailed();
        }
    }

    protected Properties getRequestProperties(IRegion region) {
        Properties p = new Properties();
        String value = this.getURI(region);
        if (value != null) {
            p.setProperty("prefix", value);
        }
        if ((value = this.getTagName(region)) != null) {
            p.setProperty("name", value);
        }
        if ((value = this.getTagAttributeName(region)) != null) {
            p.setProperty("attribute", value);
        }
        return p;
    }

    private String getURI(IRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            Node node = null;
            node = n instanceof Attr ? ((Attr)n).getOwnerElement() : n.getParentNode();
            if (!(node instanceof Element)) {
                return null;
            }
            String nodeName = node.getNodeName();
            if (nodeName.indexOf(58) == -1) {
                return null;
            }
            String nodePrefix = nodeName.substring(0, nodeName.indexOf(":"));
            if (nodePrefix == null || nodePrefix.length() == 0) {
                return null;
            }
            TaglibManagerWrapper tmw = new TaglibManagerWrapper();
            tmw.init(this.getDocument(), region.getOffset());
            if (!tmw.exists()) {
                return null;
            }
            String string = tmw.getUri(nodePrefix);
            return string;
        }
        finally {
            smw.dispose();
        }
    }

    private String getTagName(IRegion region) {
        if (region == null) {
            return null;
        }
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            Node node = null;
            node = n instanceof Attr ? ((Attr)n).getOwnerElement() : n.getParentNode();
            if (!(node instanceof Element)) {
                return null;
            }
            String tagName = node.getNodeName();
            if (tagName.indexOf(58) == -1) {
                return null;
            }
            String string = tagName.substring(tagName.indexOf(58) + 1);
            return string;
        }
        finally {
            smw.dispose();
        }
    }

    private String getTagAttributeName(IRegion region) {
        if (region == null) {
            return null;
        }
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            if (n instanceof Attr) {
                String string = ((Attr)n).getName();
                return string;
            }
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    public String getHyperlinkText() {
        String tagName = this.getTagName(this.getHyperlinkRegion());
        String attrName = this.getTagAttributeName(this.getHyperlinkRegion());
        if (tagName == null || attrName == null) {
            return JSFTextExtMessages.OpenTagLibraryForAnAttribute;
        }
        return MessageFormat.format(JSFTextExtMessages.OpenTagLibraryForAttributeName, attrName, tagName);
    }
}

