/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.editor.check;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.common.log.LogHelper;
import org.jboss.tools.common.model.options.Preference;
import org.jboss.tools.jsf.ui.JsfUIMessages;
import org.jboss.tools.jsf.ui.editor.check.KBNaturesInfoDialog;
import org.jboss.tools.jsf.ui.editor.check.ProjectNaturesPartListener;
import org.jboss.tools.jst.web.kb.internal.KbProject;
import org.jboss.tools.jst.web.ui.internal.editor.util.FileUtil;

public class ProjectNaturesChecker
implements IResourceChangeListener {
    private ProjectNaturesPartListener partListener = new ProjectNaturesPartListener();
    private static final String SEARCH_CLASS = "javax.faces.webapp.FacesServlet";
    public static final QualifiedName IS_JSF_CHECK_NEED = new QualifiedName("", JsfUIMessages.IS_JSF_CHECK_NEED);
    private Set<IProject> projectsCollection = new HashSet<IProject>(0);
    private static ProjectNaturesChecker checker;

    public static ProjectNaturesChecker getInstance() {
        if (checker == null) {
            checker = new ProjectNaturesChecker();
        }
        return checker;
    }

    private ProjectNaturesChecker() {
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        if (windows != null) {
            IWorkbenchWindow[] iWorkbenchWindowArray = windows;
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                window.getPartService().addPartListener((IPartListener)this.partListener);
                ++n2;
            }
        }
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)new WindowListener());
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        Display display = Display.getDefault();
        if (display != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ProjectNaturesChecker.this.handleResourceChangeEvent(event);
                }
            });
        }
    }

    public void checkNatures(IProject project) throws CoreException {
        if (project != null && project.isAccessible()) {
            this.addProject(project);
            boolean isKBNaturesCheck = Preference.SHOW_NATURE_WARNING.getValue().equals("yes");
            KbProject.checkKBBuilderInstalled((IResource)project);
            String missingNature = this.checkMissingNatures(project);
            if (missingNature != null) {
                KBNaturesInfoDialog dialog = null;
                if ("org.jboss.tools.jst.web.kb.kbnature".equals(missingNature) && isKBNaturesCheck) {
                    dialog = new KBNaturesInfoDialog(project);
                }
                if (dialog != null) {
                    dialog.open();
                }
            }
        }
    }

    private String checkMissingNatures(IProject project) throws CoreException {
        if (this.getKBProblemMarker(project) != null) {
            return "org.jboss.tools.jst.web.kb.kbnature";
        }
        return null;
    }

    private void handleResourceChangeEvent(IResourceChangeEvent changeEvent) {
        IResourceDelta[] affectedChildren = changeEvent.getDelta().getAffectedChildren();
        int i = 0;
        while (i < affectedChildren.length) {
            IResourceDelta resourceDelta = affectedChildren[i];
            if (resourceDelta.getResource() instanceof IProject) {
                IProject project = (IProject)resourceDelta.getResource();
                try {
                    if (resourceDelta.getKind() == 1) {
                        this.processAddProject(project);
                    } else if (resourceDelta.getKind() == 2) {
                        this.processRemoveProject(project);
                    } else {
                        this.updateProjectJSFPersistents(project);
                    }
                }
                catch (CoreException e) {
                    LogHelper.logError((String)"org.jboss.tools.jst.web.ui", (Throwable)e);
                }
            }
            ++i;
        }
    }

    public IProject getProject(IProject project) {
        return this.projectsCollection.contains(project) ? project : null;
    }

    public void addProject(IProject project) {
        if (!this.projectsCollection.contains(project)) {
            this.projectsCollection.add(project);
        }
    }

    public void dispose() {
        this.partListener = null;
        this.projectsCollection.clear();
    }

    private void processAddProject(IProject project) throws CoreException {
        this.addProject(project);
        this.updateProjectJSFPersistents(project);
    }

    private void processRemoveProject(IProject project) {
        this.projectsCollection.remove(project);
    }

    private void updateProjectJSFPersistents(IProject project) throws CoreException {
        if (project.isAccessible()) {
            IJavaElement javaElement = null;
            try {
                javaElement = FileUtil.searchForClass((IJavaProject)JavaCore.create((IProject)project), (String)SEARCH_CLASS);
            }
            finally {
                if (javaElement == null) {
                    project.setPersistentProperty(IS_JSF_CHECK_NEED, Boolean.FALSE.toString());
                } else {
                    project.setPersistentProperty(IS_JSF_CHECK_NEED, Boolean.TRUE.toString());
                }
            }
        }
    }

    private IMarker getKBProblemMarker(IProject project) throws CoreException {
        IMarker[] markers;
        IMarker kbProblemMarker = null;
        IMarker[] iMarkerArray = markers = project.findMarkers(null, false, 1);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if ("org.jboss.tools.jst.web.kb.kbBuilderProblemMarker".equals(marker.getType())) {
                kbProblemMarker = marker;
                break;
            }
            ++n2;
        }
        return kbProblemMarker;
    }

    class WindowListener
    implements IWindowListener {
        WindowListener() {
        }

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            window.getPartService().removePartListener((IPartListener)ProjectNaturesChecker.this.partListener);
        }

        public void windowOpened(IWorkbenchWindow window) {
            window.getPartService().addPartListener((IPartListener)ProjectNaturesChecker.this.partListener);
        }
    }
}

