/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.editor.edit;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.dnd.DnDUtil;
import org.jboss.tools.jsf.ui.JsfUiPlugin;
import org.jboss.tools.jsf.ui.editor.edit.GroupEditPolicy;
import org.jboss.tools.jsf.ui.editor.edit.JSFDiagramEditPart;
import org.jboss.tools.jsf.ui.editor.edit.JSFEditPart;
import org.jboss.tools.jsf.ui.editor.edit.JSFFlowEditPolicy;
import org.jboss.tools.jsf.ui.editor.edit.PageEditPart;
import org.jboss.tools.jsf.ui.editor.figures.GroupFigure;
import org.jboss.tools.jsf.ui.editor.model.IGroup;
import org.jboss.tools.jsf.ui.editor.model.IGroupListener;
import org.jboss.tools.jsf.ui.editor.model.ILink;
import org.jboss.tools.jsf.ui.editor.model.IPage;

public class GroupEditPart
extends JSFEditPart
implements PropertyChangeListener,
IGroupListener,
EditPartListener {
    private GroupFigure fig = null;
    private boolean single = true;
    Dimension size;

    public boolean isSingle() {
        return this.single;
    }

    @Override
    public void doControlUp() {
    }

    @Override
    public void doControlDown() {
    }

    @Override
    public void doMouseHover(boolean cf) {
    }

    @Override
    public void doDoubleClick(boolean cf) {
        try {
            XAction action = DnDUtil.getEnabledAction((XModelObject)((XModelObject)this.getGroupModel().getSource()), null, (String)"OpenPage");
            if (action != null) {
                action.executeHandler((XModelObject)this.getGroupModel().getSource(), null);
            }
        }
        catch (XModelException e) {
            JsfUiPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public void setModel(Object model) {
        super.setModel(model);
        ((IGroup)model).addPropertyChangeListener(this);
        ((IGroup)model).addGroupListener(this);
        this.addEditPartListener(this);
        this.single = this.getGroupModel().getPageList().size() <= 1;
        this.layoutPages();
    }

    public void childAdded(EditPart child, int index) {
    }

    public void partActivated(EditPart editpart) {
    }

    public void partDeactivated(EditPart editpart) {
    }

    public void removingChild(EditPart child, int index) {
    }

    public void selectedStateChanged(EditPart editpart) {
        if (this.getSelected() == 2) {
            ((JSFDiagramEditPart)this.getParent()).setToFront((EditPart)this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("name")) {
            this.fig.setPath(this.getGroupModel().getVisiblePath());
        } else if (evt.getPropertyName().equals("path")) {
            this.fig.setPath(this.getGroupModel().getVisiblePath());
        } else if (!evt.getPropertyName().equals("selected") && evt.getPropertyName().equals("shape")) {
            this.refreshVisuals();
        }
    }

    @Override
    public boolean isGroupListenerEnable() {
        return true;
    }

    @Override
    public void groupChange() {
        this.layoutPages();
        this.refresh();
        this.fig.setIcon(this.getGroupModel().getImage());
        this.fig.refreshFont();
        this.fig.repaint();
    }

    @Override
    public void pageAdd(IGroup group, IPage page) {
        if (this.getGroupModel().getPageList().size() > 1) {
            if (this.single) {
                this.single = false;
            }
            this.layoutPages();
            this.refresh();
        }
    }

    @Override
    public void pageRemove(IGroup group, IPage page) {
        if (this.getGroupModel().getPageList().size() == 1 && !this.single) {
            this.fig.init(this.getGroupModel().getListOutputLinks().size());
            this.single = true;
        }
        this.layoutPages();
        this.refresh();
    }

    @Override
    public void pageChange(IGroup group, IPage page, PropertyChangeEvent evet) {
        this.layoutPages();
        this.refresh();
    }

    @Override
    public void linkAdd(IPage page, ILink link) {
        this.layoutPages();
        if (this.single) {
            this.fig.addConnectionAnchor(this.getGroupModel().getListOutputLinks().size());
        }
        this.refreshTargetLink(link);
        this.refresh();
    }

    private void refreshTargetLink(ILink link) {
        if (link == null) {
            return;
        }
        GroupEditPart gep = (GroupEditPart)this.getViewer().getEditPartRegistry().get(link.getToGroup());
        if (gep == null) {
            return;
        }
        gep.refreshTargetConnections();
    }

    @Override
    public void linkRemove(IPage page, ILink link) {
        this.layoutPages();
        this.refresh();
        if (this.single) {
            this.fig.removeConnectionAnchor();
        }
        this.refreshTargetLink(link);
        this.refresh();
    }

    @Override
    public void linkChange(IPage page, ILink link, PropertyChangeEvent evet) {
        this.refresh();
    }

    @Override
    protected AccessibleEditPart createAccessible() {
        return new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

            public void getName(AccessibleEvent e) {
                e.result = "EditPart";
            }

            public void getValue(AccessibleControlEvent e) {
            }
        };
    }

    protected List getModelTargetConnections() {
        return this.getGroupModel().getListInputLinks();
    }

    protected List getModelSourceConnections() {
        if (this.single) {
            return this.getGroupModel().getListOutputLinks();
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("NodeEditPolicy", null);
        this.installEditPolicy("Selection Feedback", null);
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new GroupEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new JSFFlowEditPolicy());
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new GroupEditPolicy());
    }

    protected IFigure createFigure() {
        this.fig = new GroupFigure(this.getGroupModel());
        this.fig.setGroupEditPart(this);
        return this.fig;
    }

    public GroupFigure getGroupFigure() {
        return (GroupFigure)this.getFigure();
    }

    public IGroup getGroupModel() {
        return (IGroup)this.getModel();
    }

    public void layoutPages() {
        this.size = new Dimension();
        int start = 0;
        this.size.width = 50;
        this.size.height = 23;
        if (this.getGroupModel().isPattern()) {
            this.size.width += 3;
            start += 3;
        }
        int i = 0;
        while (i < this.getGroupModel().getPageList().size()) {
            IPage page = (IPage)this.getGroupModel().getPageList().get(i);
            int height = page.getLinkList().size() * 16 - 1;
            if (page.getLinkList().size() == 0) {
                height = 15;
            }
            if (this.getGroupModel().isPattern()) {
                page.setBounds(start, this.size.height, this.size.width - 6, height);
            } else {
                page.setBounds(start, this.size.height, this.size.width - 3, height);
            }
            this.size.height += height + 1;
            ++i;
        }
        this.size.height += 2;
        if (this.getGroupModel().isPattern()) {
            ++this.size.height;
        }
    }

    @Override
    protected void refreshVisuals() {
        Point loc = this.getGroupModel().getPosition();
        loc.x -= loc.x % 8;
        loc.y -= loc.y % 8;
        Rectangle r = new Rectangle(loc, this.size);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)r);
    }

    @Override
    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connEditPart) {
        ConnectionAnchor anc = this.getNodeFigure().getConnectionAnchor("1_IN");
        return anc;
    }

    @Override
    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        Point pt = new Point(((DropRequest)request).getLocation());
        return this.getNodeFigure().getTargetConnectionAnchorAt(pt);
    }

    @Override
    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connEditPart) {
        if (this.single) {
            ILink link = (ILink)connEditPart.getModel();
            int index = this.getGroupModel().getListOutputLinks().indexOf(link);
            return this.getNodeFigure().getConnectionAnchor(String.valueOf(index + 1) + "_OUT");
        }
        return super.getSourceConnectionAnchor(connEditPart);
    }

    @Override
    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        if (this.single) {
            Point pt = new Point(((DropRequest)request).getLocation());
            return this.getNodeFigure().getSourceConnectionAnchorAt(pt);
        }
        return super.getSourceConnectionAnchor(request);
    }

    protected List getModelChildren() {
        return this.single ? Collections.EMPTY_LIST : this.getGroupModel().getPageList().getElements();
    }

    protected void refreshChildren() {
        super.refreshChildren();
        int i = 0;
        while (i < this.getChildren().size()) {
            ((PageEditPart)this.getChildren().get(i)).refresh();
            ++i;
        }
    }
}

