/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.editor.edit;

import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.dnd.DnDUtil;
import org.jboss.tools.jsf.ui.JsfUiPlugin;
import org.jboss.tools.jsf.ui.editor.edit.GroupEditPart;
import org.jboss.tools.jsf.ui.editor.edit.JSFEditPart;
import org.jboss.tools.jsf.ui.editor.edit.PageEditPolicy;
import org.jboss.tools.jsf.ui.editor.figures.PageFigure;
import org.jboss.tools.jsf.ui.editor.model.ILink;
import org.jboss.tools.jsf.ui.editor.model.IPage;
import org.jboss.tools.jsf.ui.editor.model.IPageListener;

public class PageEditPart
extends JSFEditPart
implements EditPartListener,
IPageListener {
    private PageFigure fig = null;

    @Override
    public void doMouseUp(boolean cf) {
    }

    @Override
    public void doMouseDown(boolean cf) {
    }

    @Override
    public void doMouseHover(boolean cf) {
    }

    @Override
    public void doDoubleClick(boolean cf) {
        try {
            XAction action = DnDUtil.getEnabledAction((XModelObject)((XModelObject)this.getPageModel().getSource()), null, (String)"OpenPage");
            if (action != null) {
                action.executeHandler((XModelObject)this.getPageModel().getSource(), null);
            }
        }
        catch (XModelException e) {
            JsfUiPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public void setModel(Object model) {
        super.setModel(model);
        this.addEditPartListener(this);
        this.getPageModel().addPageListener(this);
    }

    public void childAdded(EditPart child, int index) {
    }

    public void partActivated(EditPart editpart) {
    }

    public void partDeactivated(EditPart editpart) {
    }

    public void removingChild(EditPart child, int index) {
    }

    public void selectedStateChanged(EditPart editpart) {
        this.fig.repaint();
    }

    @Override
    public boolean isPageListenerEnable() {
        return true;
    }

    @Override
    public void pageRemoved(IPage page) {
    }

    @Override
    public void pageChange() {
        this.refresh();
    }

    @Override
    public void linkAdd(IPage page, ILink link) {
        this.fig.addConnectionAnchor(this.getPageModel().getLinkList().size());
        this.refresh();
    }

    @Override
    public void linkRemove(IPage page, ILink link) {
        this.fig.removeConnectionAnchor();
        this.refresh();
    }

    @Override
    public void linkChange(IPage page, ILink link, PropertyChangeEvent event) {
        this.refreshSourceConnections();
    }

    @Override
    protected AccessibleEditPart createAccessible() {
        return new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

            public void getName(AccessibleEvent e) {
                e.result = "EditPart";
            }

            public void getValue(AccessibleControlEvent e) {
            }
        };
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new PageEditPolicy());
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new PageEditPolicy());
    }

    protected IFigure createFigure() {
        this.fig = new PageFigure(this);
        return this.fig;
    }

    public PageFigure getPageFigure() {
        return (PageFigure)this.getFigure();
    }

    public IPage getPageModel() {
        return (IPage)this.getModel();
    }

    protected List getModelSourceConnections() {
        if (this.getParent() == null) {
            return Collections.EMPTY_LIST;
        }
        if (((GroupEditPart)this.getParent()).isSingle()) {
            return Collections.EMPTY_LIST;
        }
        return this.getPageModel().getLinkList().getElements();
    }

    protected List getModelTargetConnections() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connEditPart) {
        ILink link = (ILink)connEditPart.getModel();
        int index = this.getPageModel().getLinkList().indexOf(link);
        ConnectionAnchor anc = this.getNodeFigure().getConnectionAnchor(String.valueOf(index + 1) + "_OUT");
        return anc;
    }

    @Override
    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        Point pt = new Point(((DropRequest)request).getLocation());
        return this.getNodeFigure().getSourceConnectionAnchorAt(pt);
    }

    public void setSelected(int i) {
        super.setSelected(i);
        this.refreshVisuals();
    }

    @Override
    protected void refreshVisuals() {
        if (this.getParent() == null) {
            return;
        }
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)this.getPageModel().getBounds());
    }
}

