/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.editor.form;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.editor.form.RightFormContainer;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.attribute.XAttributeSupport;
import org.jboss.tools.common.model.ui.attribute.adapter.XChildrenTableStructuredAdapter;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.JavaHyperlinkLineFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.TableStructuredEditor;
import org.jboss.tools.common.model.ui.attribute.editor.TableStructuredFieldEditor;
import org.jboss.tools.common.model.ui.forms.ExpandableForm;
import org.jboss.tools.common.model.ui.forms.IFormContainer;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;
import org.jboss.tools.common.model.ui.widgets.WhiteSettings;
import org.jboss.tools.jsf.ui.JsfUiPlugin;
import org.jboss.tools.jsf.ui.editor.FacesConfigEditorMessages;

public class MapEntries
extends ExpandableForm {
    private XAttributeSupport support;
    private XModelObject xmo;
    private TableStructuredEditor tableEditor;
    private XChildrenTableStructuredAdapter tableAdapter;
    private IPropertyEditor valueClass;
    private IPropertyEditor keyClass;
    private IWidgetSettings settings = WhiteSettings.getWhite();

    public MapEntries() {
        this.support = new XAttributeSupport(this.settings);
        this.setCollapsable(Boolean.TRUE);
    }

    public void dispose() {
        super.dispose();
        if (this.support != null) {
            this.support.dispose();
        }
        this.support = null;
        if (this.valueClass != null) {
            this.valueClass.dispose();
        }
        this.valueClass = null;
        if (this.keyClass != null) {
            this.keyClass.dispose();
        }
        this.keyClass = null;
        if (this.tableEditor != null) {
            this.tableEditor.dispose();
        }
        this.tableEditor = null;
        if (this.tableAdapter != null) {
            this.tableAdapter.dispose();
        }
        this.tableAdapter = null;
    }

    protected Control createClientArea(Composite parent, IWidgetSettings settings) {
        GridData gd;
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        settings.setupControl((Control)composite);
        GridLayout layout = new GridLayout(2, Boolean.FALSE.booleanValue());
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        composite.setLayout((Layout)layout);
        String description = FacesConfigEditorMessages.MAPENTRIESFORM_DESCRIPTION;
        if (description != null && description.length() > 0) {
            Label label = new Label(composite, 64);
            settings.setupControl((Control)label);
            label.setText(description);
            gd = new GridData();
            gd.horizontalSpan = 2;
            label.setLayoutData((Object)gd);
        }
        if (this.xmo == null) {
            return composite;
        }
        this.putFieldEditorInToComposit(composite, this.valueClass);
        this.putFieldEditorInToComposit(composite, this.keyClass);
        TableStructuredFieldEditor tbEd = (TableStructuredFieldEditor)this.tableEditor.getFieldEditor(composite);
        Control[] control = tbEd.getControls(composite);
        tbEd.getTableViewer().setLabelProvider((IBaseLabelProvider)new XMOTableLabelProvider());
        control[0].dispose();
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        control[1].setLayoutData((Object)gd);
        return composite;
    }

    private void putFieldEditorInToComposit(Composite composite, IPropertyEditor propertyEditor) {
        if (propertyEditor != null) {
            JavaHyperlinkLineFieldEditor sb = new JavaHyperlinkLineFieldEditor(this.settings);
            sb.setLabelText(propertyEditor.getLabelText());
            sb.setPropertyEditor(propertyEditor);
            sb.fillIntoGrid(composite, 2);
            this.support.registerFieldEditor(propertyEditor.getAttributeName(), (FieldEditor)sb);
        }
    }

    public void initialize(Object model) {
        this.setHeadingText(FacesConfigEditorMessages.MAPENTRIESFORM_HEADER);
        this.xmo = (XModelObject)model;
        if (this.xmo == null) {
            JsfUiPlugin.getPluginLog().logInfo("Error to create form " + FacesConfigEditorMessages.MAPENTRIESFORM_HEADER + ". Model object cannot be null.", (Throwable)new Exception());
            return;
        }
        this.model = this.xmo.getModel();
        this.support.init(this.xmo);
        this.support.setAutoStore(Boolean.TRUE.booleanValue());
        this.valueClass = this.support.getPropertyEditorByName("value-class");
        this.keyClass = this.support.getPropertyEditorByName("key-class");
        this.tableAdapter = new XChildrenTableStructuredAdapter();
        this.tableAdapter.setShownEntities(new String[]{"JSFMapEntry"});
        this.tableAdapter.getActionMapping().clear();
        this.tableAdapter.getActionMapping().put("ADD_ACTION", "CreateActions.AddEntry");
        this.tableAdapter.getActionMapping().put("REMOVE_ACTION", "DeleteActions.Delete");
        this.tableAdapter.getActionMapping().put("EDIT_ACTION", "%SelectIt%");
        this.tableAdapter.getActionMapping().put("UP_ACTION", "%internal%");
        this.tableAdapter.getActionMapping().put("DOWN_ACTION", "%internal%");
        this.tableAdapter.setShownProperties(new String[]{"key", "value"});
        this.tableAdapter.setColumnLabels(new String[]{FacesConfigEditorMessages.MAPENTRIESFORM_ENTRY_KEY_COLUMN_LABEL, FacesConfigEditorMessages.MAPENTRIESFORM_ENTRY_VALUE_COLUMN_LABEL});
        this.tableAdapter.setWidths(new int[]{50, 50});
        this.tableAdapter.setModelObject(this.xmo);
        this.tableEditor = new TableStructuredEditor(this.settings);
        this.tableEditor.setLabelText("");
        this.tableEditor.setInput((Object)this.tableAdapter);
    }

    private ISelectionChangedListener findSelectionChangedListener(IFormContainer container) {
        if (container == null) {
            return null;
        }
        if (container instanceof RightFormContainer) {
            return ((RightFormContainer)container).getSelectionChangedListener();
        }
        return this.findSelectionChangedListener(container.getParent());
    }

    public void setParent(IFormContainer container) {
        super.setParent(container);
        if (this.tableAdapter != null) {
            this.tableAdapter.setSelectionChangedListener(this.findSelectionChangedListener(container));
        }
    }

    public void update() {
        if (this.support != null) {
            this.support.load();
            this.support.updateEnablementByModelObject();
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    public boolean doGlobalAction(String actionId) {
        return this.support.doGlobalAction(actionId);
    }

    public class XMOTableLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            XModelObject xmo = (XModelObject)element;
            if (columnIndex == 1) {
                String value = xmo.getAttributeValue("null-value");
                if ("true".equals(value)) {
                    return "[null-value]";
                }
                return xmo.getAttributeValue("value");
            }
            return xmo.getAttributeValue("key");
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

