/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.editor.model.impl;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.action.XModelObjectActionList;
import org.jboss.tools.jsf.ui.editor.model.IJSFElement;
import org.jboss.tools.jsf.ui.editor.model.IJSFModel;
import org.jboss.tools.jsf.ui.editor.model.impl.JSFModel;

public class JSFElement
implements IJSFElement {
    protected String name = "";
    protected boolean visible = false;
    protected boolean hidden = false;
    protected boolean deleted = false;
    protected boolean global = false;
    protected Dimension size;
    protected Point position;
    protected IJSFElement parent;
    protected IJSFModel jsfModel;
    protected String iconPath;
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    protected VetoableChangeSupport vetoableChangeSupport = new VetoableChangeSupport(this);
    protected XModelObject source;
    protected Hashtable map = new Hashtable();

    public JSFElement() {
    }

    public JSFElement(IJSFElement parent) {
        this.parent = parent;
        this.jsfModel = this.getJSFModel();
    }

    public JSFElement(IJSFElement parent, XModelObject source) {
        this.parent = parent;
        this.source = source;
        this.jsfModel = this.getJSFModel();
        ((JSFModel)this.jsfModel).putToMap(source.getPath(), this);
    }

    public void dispose() {
        this.vetoableChangeSupport = null;
        this.propertyChangeSupport = null;
        if (this.map != null) {
            this.map.clear();
        }
        this.map = null;
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    @Override
    public void setSource(Object obj) {
        this.source = (XModelObject)obj;
    }

    @Override
    public String getText() {
        return "";
    }

    @Override
    public IJSFElement getRoot() {
        IJSFElement current = this;
        while (current.getParentJSFElement() != null) {
            current = current.getParentJSFElement();
        }
        return current;
    }

    @Override
    public IJSFModel getJSFModel() {
        IJSFElement model = this.getRoot();
        if (model instanceof IJSFElement) {
            return (IJSFModel)model;
        }
        return null;
    }

    @Override
    public String getJSFElementPath() {
        IJSFElement current = this;
        String path = current.getName();
        while (current.getParentJSFElement() != null) {
            current = current.getParentJSFElement();
            path = String.valueOf(current.getName()) + "/" + path;
        }
        return path;
    }

    public void updateModelModifiedProperty(Object oldValue, Object newValue) {
        if (!(this.getJSFModel() == null || oldValue != null && oldValue.equals(newValue))) {
            this.getJSFModel().setModified(true);
        }
    }

    public void updateModelModifiedProperty(int oldValue, int newValue) {
        if (this.getJSFModel() != null) {
            if (newValue != oldValue) {
                // empty if block
            }
            this.getJSFModel().setModified(true);
        }
    }

    public void updateModelModifiedProperty(boolean oldValue, boolean newValue) {
        if (this.getJSFModel() != null) {
            if (newValue != oldValue) {
                // empty if block
            }
            this.getJSFModel().setModified(true);
        }
    }

    public void fireModelElementChanged() {
    }

    @Override
    public String getIconPath() {
        return this.iconPath;
    }

    @Override
    public void setIconPath(String path) {
        String oldValue = this.iconPath;
        this.iconPath = path;
        this.propertyChangeSupport.firePropertyChange("iconPath", oldValue, this.iconPath);
        this.updateModelModifiedProperty(oldValue, path);
    }

    @Override
    public IJSFElement getParentJSFElement() {
        return this.parent;
    }

    @Override
    public void setParentJSFElement(IJSFElement element) {
        IJSFElement oldValue = this.parent;
        this.parent = element;
        this.jsfModel = this.getJSFModel();
        this.propertyChangeSupport.firePropertyChange("parent", oldValue, element);
        this.updateModelModifiedProperty(oldValue, element);
    }

    @Override
    public String getName() {
        return this.source.getAttributeValue("title");
    }

    public String getPath() {
        return this.getJSFModel().getHelper().getPath(this.source);
    }

    @Override
    public String getType() {
        return this.source.getAttributeValue("type");
    }

    public String getTarget() {
        return this.source.getAttributeValue("target");
    }

    @Override
    public void setName(String name) throws PropertyVetoException {
        String oldValue = this.name;
        this.vetoableChangeSupport.fireVetoableChange("name", oldValue, name);
        this.name = name;
    }

    @Override
    public Dimension getSize() {
        int[] bounds = this.jsfModel.getHelper().asIntArray(this.source, "shape");
        if (bounds.length < 4) {
            return new Dimension(0, 0);
        }
        return new Dimension(bounds[2], bounds[3]);
    }

    @Override
    public void setSize(Dimension size) {
        Dimension oldValue = this.size;
        this.size = size;
        this.updateSourceProperty("shape", this.getPosition(), size);
        this.propertyChangeSupport.firePropertyChange("shape", oldValue, size);
        this.updateModelModifiedProperty(oldValue, size);
    }

    @Override
    public Point getPosition() {
        int[] bounds = this.jsfModel.getHelper().asIntArray(this.source, "shape");
        if (bounds.length < 2) {
            return DEFAULT_POINT;
        }
        if (bounds[0] == 0 && bounds[1] == 0) {
            return DEFAULT_POINT;
        }
        return new Point(bounds[0], bounds[1]);
    }

    @Override
    public void setPosition(Point point) {
        Point oldValue = this.position != null ? new Point(this.position.x, this.position.y) : null;
        this.position = point;
        this.updateSourceProperty("shape", point, this.getSize());
        this.propertyChangeSupport.firePropertyChange("shape", oldValue, point);
        this.updateModelModifiedProperty(oldValue, point);
    }

    @Override
    public Rectangle getBounds() {
        int[] bounds = this.jsfModel.getHelper().asIntArray(this.source, "shape");
        if (bounds.length < 4) {
            return new Rectangle(0, 0, 0, 0);
        }
        return new Rectangle(bounds[0], bounds[1], bounds[2], bounds[3]);
    }

    @Override
    public void setBounds(Rectangle rec) {
        Rectangle oldBounds = this.getBounds();
        this.updateSourceProperty("shape", new Point(rec.x, rec.y), new Dimension(rec.width, rec.height));
        this.propertyChangeSupport.firePropertyChange("shape", oldBounds, new Rectangle(rec.x, rec.y, rec.width, rec.height));
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        this.setBounds(new Rectangle(x, y, w, h));
    }

    @Override
    public void setSourceProperty(String name, Object value) {
    }

    @Override
    public Object getSourceProperty(String name) {
        return this.source.getAttributeValue(name);
    }

    @Override
    public Object getSourceProperty(int index) {
        return null;
    }

    @Override
    public int getSourcePropertyCounter() {
        return 0;
    }

    @Override
    public String[] getSourcePropertyNames() {
        XModelObject mobject = this.source;
        XAttribute[] attributes = mobject.getModelEntity().getAttributes();
        String[] attributeNames = new String[attributes.length];
        int i = 0;
        while (i < attributeNames.length) {
            attributeNames[i] = attributes[i].getName();
            ++i;
        }
        return attributeNames;
    }

    @Override
    public String[] getSourcePropertyDisplayNames() {
        XModelObject mobject = this.source;
        XAttribute[] attributes = mobject.getModelEntity().getAttributes();
        String[] attributeNames = new String[attributes.length];
        int i = 0;
        while (i < attributeNames.length) {
            attributeNames[i] = attributes[i].getName();
            ++i;
        }
        return attributeNames;
    }

    @Override
    public void remove() {
    }

    public void addVetoableChangeListener(VetoableChangeListener l) {
        this.vetoableChangeSupport.addVetoableChangeListener(l);
    }

    public void removeVetoableChangeListener(VetoableChangeListener l) {
        this.vetoableChangeSupport.removeVetoableChangeListener(l);
    }

    public void addVetoableChangeListener(String propertyName, VetoableChangeListener l) {
        this.vetoableChangeSupport.addVetoableChangeListener(propertyName, l);
    }

    public void removeVetoableChangeListener(String propertyName, VetoableChangeListener l) {
        this.vetoableChangeSupport.removeVetoableChangeListener(propertyName, l);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, l);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, l);
    }

    @Override
    public Object clone() {
        JSFElement newElement = new JSFElement();
        newElement.source = this.source.copy();
        return newElement;
    }

    public Enumeration children() {
        return null;
    }

    public boolean isLeaf() {
        return true;
    }

    public void removeAllListeners() {
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    void updateSourceProperty(String name, Point position, Dimension size) {
        if (this.source != null) {
            this.jsfModel.getHelper().setAttributeValue(this.source, name, position.x + "," + position.y + "," + size.width + "," + size.height);
        }
    }

    @Override
    public void structureChanged(Object eventData) {
    }

    @Override
    public void nodeChanged(Object eventData) {
    }

    @Override
    public void nodeAdded(Object eventData) {
    }

    @Override
    public void nodeRemoved(Object eventData) {
    }

    public JSFModel.JSFHashtable getMap() {
        return ((JSFModel)this.getJSFModel()).getMap();
    }

    public void removeFromMap(Object key) {
        ((JSFModel)this.getJSFModel()).removeFromMap(key);
    }

    public IJSFElement getFromMap(Object key) {
        return ((JSFModel)this.getJSFModel()).getFromMap(key);
    }

    @Override
    public Menu getPopupMenu(Control control, Object environment) {
        if (this.getSource() == null) {
            return null;
        }
        if (((XModelObject)this.getSource()).getModelEntity().getActionList().getActionItems().length != 0) {
            XModelObjectActionList l = new XModelObjectActionList(((XModelObject)this.getSource()).getModelEntity().getActionList(), (XModelObject)this.getSource(), null, environment);
            Menu menu = l.createMenu(control);
            return menu;
        }
        return null;
    }

    @Override
    public Menu getPopupMenu(Control control) {
        return this.getPopupMenu(control, null);
    }

    @Override
    public boolean isConfirmed() {
        return false;
    }
}

