/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.marker;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.validation.IMutableValidator;
import org.eclipse.wst.validation.MutableProjectSettings;
import org.eclipse.wst.validation.MutableWorkspaceSettings;
import org.eclipse.wst.validation.ValidationFramework;
import org.jboss.tools.jsf.ui.JsfUIMessages;
import org.jboss.tools.jsf.ui.JsfUiPlugin;

public class DisableFaceletHTMLValidatorMarkerResolution
implements IMarkerResolution2 {
    private static final String MARKER_TYPE = "org.eclipse.jst.jsf.facelet.ui.FaceletValidationMarker";
    private IFile file;
    private String label;

    public DisableFaceletHTMLValidatorMarkerResolution(IFile file) {
        this.file = file;
        this.label = JsfUIMessages.DISABLE_FACELET_HTML_VALIDATOR_MARKER_RESOLUTION_TITLE;
    }

    public String getLabel() {
        return this.label;
    }

    public static Shell getShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows.length > 0) {
                return windows[0].getShell();
            }
        } else {
            return window.getShell();
        }
        return null;
    }

    public void run(IMarker marker) {
        MessageDialog dialog = null;
        dialog = new MessageDialog(DisableFaceletHTMLValidatorMarkerResolution.getShell(), this.label, null, String.valueOf(NLS.bind((String)JsfUIMessages.DISABLE_FACELET_HTML_VALIDATOR_MARKER_RESOLUTION_MESSAGE, (Object)this.file.getName())) + NLS.bind((String)JsfUIMessages.DISABLE_FACELET_HTML_VALIDATOR_MARKER_RESOLUTION_PROJECT_QUESTION, (Object)this.file.getProject().getName()), 6, new String[]{"Cancel", "Workspace", this.file.getProject().getName()}, 0);
        int result = dialog.open();
        if (result == 1) {
            this.disableOnWorkspace();
        } else if (result == 2) {
            this.disableOnProject();
        }
    }

    private void disableOnWorkspace() {
        try {
            MutableWorkspaceSettings workspaceSettings = ValidationFramework.getDefault().getWorkspaceSettings();
            IMutableValidator[] validators = workspaceSettings.getValidators();
            if (DisableFaceletHTMLValidatorMarkerResolution.disableValidator(validators, "org.eclipse.jst.jsf.facelet.ui.FaceletHTMLValidator")) {
                ValidationFramework.getDefault().applyChanges(workspaceSettings, true);
                try {
                    this.file.getProject().getParent().deleteMarkers(MARKER_TYPE, true, 2);
                }
                catch (CoreException e) {
                    JsfUiPlugin.getPluginLog().logError((Throwable)e);
                }
            }
        }
        catch (InvocationTargetException e) {
            JsfUiPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    private void disableOnProject() {
        MutableProjectSettings projectSettings = ValidationFramework.getDefault().getProjectSettings(this.file.getProject());
        projectSettings.setOverride(true);
        IMutableValidator[] validators = projectSettings.getValidators();
        if (!DisableFaceletHTMLValidatorMarkerResolution.disableValidator(validators, "org.eclipse.jst.jsf.facelet.ui.FaceletHTMLValidator")) {
            IMutableValidator[] workspaceValidators;
            IMutableValidator faceletHTMLValidator;
            projectSettings = null;
            MutableWorkspaceSettings workspaceSettings = null;
            try {
                workspaceSettings = ValidationFramework.getDefault().getWorkspaceSettings();
            }
            catch (InvocationTargetException e) {
                JsfUiPlugin.getPluginLog().logError((Throwable)e);
            }
            if (workspaceSettings != null && (faceletHTMLValidator = DisableFaceletHTMLValidatorMarkerResolution.findValidator(workspaceValidators = workspaceSettings.getValidators(), "org.eclipse.jst.jsf.facelet.ui.FaceletHTMLValidator")) != null) {
                faceletHTMLValidator.setBuildValidation(false);
                faceletHTMLValidator.setManualValidation(false);
                validators = new IMutableValidator[]{faceletHTMLValidator};
                projectSettings = new MutableProjectSettings(this.file.getProject(), validators);
                projectSettings.setOverride(true);
            }
        }
        if (projectSettings != null) {
            ValidationFramework.getDefault().applyChanges(projectSettings, true);
            try {
                this.file.getProject().deleteMarkers(MARKER_TYPE, true, 2);
            }
            catch (CoreException e) {
                JsfUiPlugin.getPluginLog().logError((Throwable)e);
            }
        }
    }

    public static boolean disableValidator(IMutableValidator[] validators, String id) {
        IMutableValidator validator = DisableFaceletHTMLValidatorMarkerResolution.findValidator(validators, id);
        if (validator != null) {
            validator.setBuildValidation(false);
            validator.setManualValidation(false);
            return true;
        }
        return false;
    }

    public static IMutableValidator findValidator(IMutableValidator[] validators, String id) {
        IMutableValidator[] iMutableValidatorArray = validators;
        int n = validators.length;
        int n2 = 0;
        while (n2 < n) {
            IMutableValidator validator = iMutableValidatorArray[n2];
            if (validator.getId().equals(id)) {
                return validator;
            }
            ++n2;
        }
        return null;
    }

    public String getDescription() {
        return this.label;
    }

    public Image getImage() {
        return null;
    }
}

