/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.operation;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.jboss.tools.common.model.XJob;
import org.jboss.tools.common.model.XModelConstants;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jsf.JSFModelPlugin;
import org.jboss.tools.jsf.JSFPreference;
import org.jboss.tools.jsf.project.JSFAutoLoad;
import org.jboss.tools.jsf.web.JSFTemplate;
import org.jboss.tools.jsf.web.helpers.context.AdoptJSFProjectFinisher;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.context.IImportWebProjectContext;
import org.jboss.tools.jst.web.kb.internal.KbBuilder;
import org.jboss.tools.jst.web.ui.operation.WebProjectAdoptOperation;

public class JSFProjectAdoptOperation
extends WebProjectAdoptOperation {
    public JSFProjectAdoptOperation(IImportWebProjectContext context) {
        super(context);
    }

    protected void execute() throws XModelException {
        AdoptJSFProjectFinisher finisher = new AdoptJSFProjectFinisher();
        finisher.setContext(this.model, this.context);
        finisher.execute();
    }

    protected void copyLibraries() {
        if (!this.context.getAddLibraries()) {
            return;
        }
        String version = this.context.getTemplateVersion();
        JSFTemplate template = new JSFTemplate();
        String[] jars = template.getLibraries(version);
        String libDir = this.context.getLibLocation();
        if (libDir == null || libDir.trim().length() == 0) {
            return;
        }
        int i = 0;
        while (i < jars.length) {
            File source = new File(jars[i]);
            FileUtil.copyFile((File)source, (File)new File(libDir, source.getName()), (boolean)true);
            ++i;
        }
    }

    protected void postCreateWebNature() {
        final File projectFile = this.getEclipseFile();
        final IProject p = this.getProject();
        this.model.getProperties().put(XModelConstants.AUTOLOAD, new JSFAutoLoad());
        if (projectFile != null && projectFile.isFile()) {
            XJob.addRunnable((XJob.XRunnable)new XJob.XRunnable(){

                public String getId() {
                    return "Remove temporary working files.";
                }

                public void run() {
                    IFile f = EclipseResourceUtil.getFile((String)projectFile.getAbsolutePath());
                    if (f != null && f.exists()) {
                        try {
                            f.delete(true, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (CoreException e) {
                            JSFModelPlugin.getPluginLog().logError((Throwable)e);
                            this.deleteExternally();
                        }
                    } else {
                        this.deleteExternally();
                    }
                }

                private void deleteExternally() {
                    projectFile.delete();
                    if (p != null && p.exists()) {
                        try {
                            p.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (CoreException e2) {
                            JSFModelPlugin.getPluginLog().logError((Throwable)e2);
                        }
                    }
                }
            });
        }
        try {
            WebModelPlugin.addNatureToProjectWithValidationSupport((IProject)this.getProject(), (String)KbBuilder.BUILDER_ID, (String)"org.jboss.tools.jst.web.kb.kbnature");
        }
        catch (CoreException e) {
            JSFModelPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    private File getEclipseFile() {
        String fn = String.valueOf(this.getProject().getLocation().toString()) + "/" + ".settings/org.jboss.tools.jst.web.xml";
        File f = new File(fn);
        if (f.exists()) {
            return f;
        }
        return null;
    }

    protected String getNatureID() {
        return "org.jboss.tools.jsf.jsfnature";
    }

    protected String getDefaultServletVersion() {
        return JSFPreference.DEFAULT_JSF_IMPORT_SERVLET_VERSION.getValue();
    }
}

