/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.jsf2.bean.model.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.common.java.IAnnotated;
import org.jboss.tools.common.java.IAnnotationDeclaration;
import org.jboss.tools.common.java.IJavaAnnotation;
import org.jboss.tools.common.java.IJavaSourceReference;
import org.jboss.tools.common.java.impl.AnnotationDeclaration;
import org.jboss.tools.common.java.impl.JavaAnnotation;
import org.jboss.tools.jsf.JSFModelPlugin;
import org.jboss.tools.jsf.jsf2.bean.model.impl.AbstractTypeDefinition;
import org.jboss.tools.jsf.jsf2.bean.model.impl.DefinitionContext;

public abstract class AbstractMemberDefinition
implements IAnnotated {
    public static int FLAG_NO_ANNOTATIONS = 1;
    public static int FLAG_ALL_MEMBERS = 2;
    protected List<IAnnotationDeclaration> annotations = new ArrayList<IAnnotationDeclaration>();
    protected IAnnotatable member;
    protected Map<String, AnnotationDeclaration> annotationsByType = new HashMap<String, AnnotationDeclaration>();
    protected IResource resource;

    protected void setAnnotatable(IAnnotatable member, IType contextType, DefinitionContext context, int flags) {
        this.member = member;
        try {
            this.init(contextType, context, flags);
        }
        catch (CoreException e) {
            JSFModelPlugin.getDefault().logError(e);
        }
    }

    public IAnnotatable getMember() {
        return this.member;
    }

    public AbstractTypeDefinition getTypeDefinition() {
        return null;
    }

    protected void init(IType contextType, DefinitionContext context, int flags) throws CoreException {
        this.resource = ((IJavaElement)this.member).getResource();
        if ((flags & FLAG_NO_ANNOTATIONS) == 0) {
            IAnnotation[] ts = this.member.getAnnotations();
            int i = 0;
            while (i < ts.length) {
                JavaAnnotation ja = new JavaAnnotation(ts[i], contextType);
                this.addAnnotation((IJavaAnnotation)ja, context);
                ++i;
            }
        }
    }

    public void addAnnotation(IJavaAnnotation ja, DefinitionContext context) {
        AnnotationDeclaration a = new AnnotationDeclaration();
        a.setDeclaration(ja);
        this.addAnnotation(a, context);
    }

    private void addAnnotation(AnnotationDeclaration a, DefinitionContext context) {
        this.annotations.add((IAnnotationDeclaration)a);
        if (a.getTypeName() != null) {
            this.annotationsByType.put(a.getTypeName(), a);
        }
    }

    public void removeAnnotation(IAnnotationDeclaration a) {
        String name = ((AnnotationDeclaration)a).getTypeName();
        IAnnotationDeclaration b = (IAnnotationDeclaration)this.annotationsByType.get(name);
        if (a == b) {
            this.annotationsByType.remove(name);
            this.annotations.remove(a);
        }
    }

    public List<IAnnotationDeclaration> getAnnotations() {
        return this.annotations;
    }

    public AnnotationDeclaration getAnnotation(String typeName) {
        return this.annotationsByType.get(typeName);
    }

    public IJavaSourceReference getAnnotationPosition(String annotationTypeName) {
        return this.getAnnotation(annotationTypeName);
    }

    public boolean isAnnotationPresent(String annotationTypeName) {
        return this.getAnnotation(annotationTypeName) != null;
    }

    public AnnotationDeclaration getManagedBeanAnnotation() {
        return this.annotationsByType.get("javax.faces.bean.ManagedBean");
    }

    public IResource getResource() {
        return this.resource;
    }
}

