/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.jsf2.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.internal.core.JarEntryFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.wst.html.core.internal.encoding.HTMLModelLoader;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.text.JobSafeStructuredDocument;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.parser.XMLSourceParser;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.format.DocumentNodeFormatter;
import org.jboss.tools.jsf.JSFModelPlugin;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JSF2ComponentModelManager {
    public static final String INTERFACE = "interface";
    public static final String ATTRIBUTE = "attribute";
    public static final String NAME = "name";
    public static final String XMLNS = "xmlns";
    public static final String COLON = ":";
    public static final String DEFAULT_COMPOSITE_PREFIX = "composite";
    public static final String XHTML_URI = "http://www.w3.org/1999/xhtml";
    public static final String HTML = "html";
    public static final String HTML_URI = "http://java.sun.com/jsf/html";
    public static final String HTML_PREFIX = "h";
    private static JSF2ComponentModelManager instance = new JSF2ComponentModelManager();

    private JSF2ComponentModelManager() {
    }

    public static JSF2ComponentModelManager getManager() {
        return instance;
    }

    public IFile updateJSF2CompositeComponentFile(final IFile componentFileContatiner, final String[] attrNames) {
        IFile file = this.updateFileContent(new EditableDOMFile(this){

            @Override
            public IFile getFile() {
                return componentFileContatiner;
            }

            @Override
            protected void edit(IDOMModel model) throws CoreException, IOException {
                FileEditorInput input = new FileEditorInput(this.getFile());
                IDocumentProvider provider = DocumentProviderRegistry.getDefault().getDocumentProvider((IEditorInput)input);
                provider.connect((Object)input);
                IDocument document = provider.getDocument((Object)input);
                this.updateJSF2CompositeComponent(model.getDocument(), attrNames);
                provider.aboutToChange((Object)input);
                provider.saveDocument((IProgressMonitor)new NullProgressMonitor(), (Object)input, document, true);
                provider.changed((Object)input);
                provider.disconnect((Object)input);
            }
        });
        return file;
    }

    private void updateJSF2CompositeComponent(IDOMDocument componentDoc, String[] attrNames) {
        Element interfaceElement = this.findInterfaceComponent((Node)componentDoc);
        if (interfaceElement == null) {
            interfaceElement = this.createCompositeInterface((Document)componentDoc);
        }
        this.createCompositeCompInterface(interfaceElement, attrNames);
    }

    private Element findInterfaceComponent(Node node) {
        IDOMDocument document;
        Element element;
        if (node instanceof IDOMDocument && (element = this.findInterfaceComponent((document = (IDOMDocument)node).getDocumentElement())) != null) {
            return element;
        }
        if (node instanceof ElementImpl) {
            ElementImpl impl = (ElementImpl)node;
            String nameSpace = impl.getNamespaceURI();
            if ("http://java.sun.com/jsf/composite".equals(nameSpace)) {
                String nodeName = impl.getLocalName();
                if (INTERFACE.equals(nodeName)) {
                    return impl;
                }
            } else {
                NodeList nodeList = node.getChildNodes();
                if (nodeList != null) {
                    int i = 0;
                    while (i < nodeList.getLength()) {
                        Element element2 = this.findInterfaceComponent(nodeList.item(i));
                        if (element2 != null) {
                            return element2;
                        }
                        ++i;
                    }
                }
            }
        }
        return null;
    }

    private void createCompositeCompInterface(Element element, String[] attrNames) {
        int i;
        Document document = element.getOwnerDocument();
        String prefix = element.getPrefix();
        Set<String> existInerfaceAttrs = this.getInterfaceAttrs(element);
        if (prefix != null && !"".equals(prefix)) {
            i = 0;
            while (i < attrNames.length) {
                if (!existInerfaceAttrs.contains(attrNames[i])) {
                    Element attrEl = document.createElementNS("http://java.sun.com/jsf/composite", String.valueOf(prefix) + COLON + ATTRIBUTE);
                    attrEl.setAttribute(NAME, attrNames[i]);
                    element.appendChild(attrEl);
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < attrNames.length) {
                if (!existInerfaceAttrs.contains(attrNames[i])) {
                    Element attrEl = document.createElementNS("http://java.sun.com/jsf/composite", ATTRIBUTE);
                    attrEl.setAttribute(NAME, attrNames[i]);
                    element.appendChild(attrEl);
                }
                ++i;
            }
        }
        DocumentNodeFormatter formatter = new DocumentNodeFormatter();
        formatter.format((Node)document);
    }

    public IFile revalidateCompositeComponentFile(IFile file) {
        IDOMDocument document = JSF2ComponentModelManager.getReadableDOMDocument(file);
        if (document == null) {
            return null;
        }
        return file;
    }

    public Element checkCompositeInterface(IDOMDocument document) {
        if (document == null) {
            return null;
        }
        Element element = document.getDocumentElement();
        if (element == null) {
            return null;
        }
        if (!this.hasNamespace(element, "http://java.sun.com/jsf/composite")) {
            return null;
        }
        return this.findInterfaceComponent(element);
    }

    private boolean hasNamespace(Node node, String URI2) {
        NamedNodeMap attributes = node.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node attr = attributes.item(i);
            if (attr.getNodeName().startsWith("xmlns:") && URI2.equals(attr.getNodeValue())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String getPrefix(Node node, String URI2) {
        NamedNodeMap attributes = node.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node attr = attributes.item(i);
            if (attr.getNodeName().startsWith("xmlns:") && URI2.equals(attr.getNodeValue())) {
                return attr.getLocalName();
            }
            ++i;
        }
        return null;
    }

    private Element findNodeToCreateCompositeInterface(Element rootNode) {
        if (this.hasNamespace(rootNode, "http://java.sun.com/jsf/composite")) {
            return rootNode;
        }
        NodeList children = rootNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Element result;
            Node child = children.item(i);
            if (child instanceof Element && (result = this.findNodeToCreateCompositeInterface((Element)child)) != null && result instanceof Element) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private Element createCompositeInterface(Document document) {
        Element node;
        Element rootElement = document.getDocumentElement();
        if (rootElement == null) {
            rootElement = this.createDocumentElementForCompositeInterface(document);
        }
        if ((node = this.findNodeToCreateCompositeInterface(rootElement)) == null) {
            this.addURI(document, rootElement);
            node = rootElement;
        }
        String prefix = this.getPrefix(node, "http://java.sun.com/jsf/composite");
        Element interfaceElement = document.createElement(String.valueOf(prefix) + COLON + INTERFACE);
        node.appendChild(interfaceElement);
        DocumentNodeFormatter formatter = new DocumentNodeFormatter();
        formatter.format((Node)document);
        return interfaceElement;
    }

    private Element createDocumentElementForCompositeInterface(Document document) {
        Element rootElement = document.createElement(HTML);
        Attr attr = document.createAttribute(XMLNS);
        attr.setValue(XHTML_URI);
        rootElement.setAttributeNode(attr);
        attr = document.createAttribute("xmlns:h");
        attr.setValue(HTML_URI);
        rootElement.setAttributeNode(attr);
        attr = document.createAttribute("xmlns:composite");
        attr.setValue("http://java.sun.com/jsf/composite");
        rootElement.setAttributeNode(attr);
        document.appendChild(rootElement);
        return rootElement;
    }

    private void addURI(Document document, Element rootElement) {
        Attr attr = document.createAttribute("xmlns:composite");
        attr.setValue("http://java.sun.com/jsf/composite");
        rootElement.setAttributeNode(attr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IDOMDocument getReadableDOMDocument(IFile file) {
        IDOMDocument document = null;
        IModelManager manager = StructuredModelManager.getModelManager();
        if (manager == null) {
            return document;
        }
        IStructuredModel model = null;
        try {
            try {
                model = manager.getModelForRead(file);
                if (!(model instanceof IDOMModel)) return document;
                IDOMModel domModel = (IDOMModel)model;
                document = domModel.getDocument();
                return document;
            }
            catch (CoreException e) {
                JSFModelPlugin.getPluginLog().logError((Throwable)e);
                if (model == null) return document;
                model.releaseFromRead();
                return document;
            }
            catch (IOException e) {
                JSFModelPlugin.getPluginLog().logError((Throwable)e);
                if (model == null) return document;
                model.releaseFromRead();
                return document;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    public static IDOMDocument getReadableDOMDocument(JarEntryFile file) {
        IDOMDocument document;
        block17: {
            document = null;
            IStructuredModel model = null;
            InputStream inputStream = null;
            try {
                try {
                    inputStream = file.getContents();
                    if (inputStream != null) {
                        StringBuilder buffer = new StringBuilder();
                        Scanner in = new Scanner(inputStream);
                        while (in.hasNextLine()) {
                            buffer.append(in.nextLine());
                        }
                        model = new HTMLModelLoader().newModel();
                        model.setStructuredDocument((IStructuredDocument)new JobSafeStructuredDocument((RegionParser)new XMLSourceParser()));
                        model.getStructuredDocument().set(buffer.toString());
                        if (model instanceof IDOMModel) {
                            document = ((IDOMModel)model).getDocument();
                        }
                    }
                }
                catch (CoreException e) {
                    JSFModelPlugin.getPluginLog().logError((Throwable)e);
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    model = null;
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                model = null;
                throw throwable;
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            model = null;
        }
        return document;
    }

    public static IDOMDocument getReadableDOMDocument(IDocument textDocument) {
        IDOMDocument document = null;
        if (!(textDocument instanceof IStructuredDocument)) {
            return document;
        }
        IModelManager manager = StructuredModelManager.getModelManager();
        if (manager == null) {
            return document;
        }
        IStructuredModel model = null;
        try {
            model = manager.getModelForRead((IStructuredDocument)textDocument);
            if (model instanceof IDOMModel) {
                IDOMModel domModel = (IDOMModel)model;
                document = domModel.getDocument();
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return document;
    }

    public Set<String> getInterfaceAttrs(Element interfaceElement) {
        HashSet<String> interfaceAttrs = new HashSet<String>(0);
        if (interfaceElement != null) {
            NodeList attrsElements;
            String prefix = interfaceElement.getPrefix();
            String nodeName = ATTRIBUTE;
            if (prefix != null && !"".equals(prefix)) {
                nodeName = String.valueOf(prefix) + COLON + nodeName;
            }
            if ((attrsElements = interfaceElement.getElementsByTagName(nodeName)) != null) {
                int i = 0;
                while (i < attrsElements.getLength()) {
                    IDOMElement element;
                    String attrvalue;
                    Node el = attrsElements.item(i);
                    if (el instanceof IDOMElement && (attrvalue = (element = (IDOMElement)el).getAttribute(NAME)) != null && !"".equals(attrvalue)) {
                        interfaceAttrs.add(attrvalue);
                    }
                    ++i;
                }
            }
        }
        return interfaceAttrs;
    }

    private IFile updateFileContent(EditableDOMFile domFile) {
        return domFile.editFile();
    }

    private abstract class EditableDOMFile {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public IFile editFile() {
            IFile file = this.getFile();
            if (file == null) {
                return file;
            }
            IModelManager manager = StructuredModelManager.getModelManager();
            if (manager == null) {
                return file;
            }
            IStructuredModel model = null;
            try {
                try {
                    model = manager.getModelForEdit(file);
                    if (!(model instanceof IDOMModel)) return file;
                    IDOMModel domModel = (IDOMModel)model;
                    this.edit(domModel);
                    return file;
                }
                catch (CoreException e) {
                    JSFModelPlugin.getPluginLog().logError((Throwable)e);
                    if (model == null) return file;
                    model.releaseFromEdit();
                    return file;
                }
                catch (IOException e) {
                    JSFModelPlugin.getPluginLog().logError((Throwable)e);
                    if (model == null) return file;
                    model.releaseFromEdit();
                    return file;
                }
            }
            finally {
                if (model != null) {
                    model.releaseFromEdit();
                }
            }
        }

        protected abstract void edit(IDOMModel var1) throws CoreException, IOException;

        public abstract IFile getFile();
    }
}

