/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.jsf2.util;

import java.io.File;
import java.util.zip.ZipEntry;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ExternalPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JarEntryDirectory;
import org.eclipse.jdt.internal.core.JarEntryFile;
import org.eclipse.jdt.internal.core.JarEntryResource;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.IncrementalHelper;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.jboss.tools.jsf.JSFModelPlugin;
import org.jboss.tools.jsf.jsf2.model.JSF2ComponentModelManager;
import org.jboss.tools.jsf.web.validation.jsf2.util.JSF2TemplateManager;
import org.jboss.tools.jst.web.WebUtils;

public class JSF2ResourceUtil {
    public static final String COMPONENT_RESOURCE_PATH_KEY = "component_resource_path_key";
    public static final String JSF2_COMPONENT_NAME = "jsf2_resource_name";
    public static final int JAR_FILE_RESOURCE_TYPE = 1;
    public static final int JAR_DIRECTORY_RESOURCE_TYPE = 2;

    public static Object findCompositeComponentContainer(IProject project, IDOMElement jsf2Element) {
        String classPathResource;
        JarEntryResource jer;
        ElementImpl elementImpl = (ElementImpl)jsf2Element;
        String nameSpaceURI = elementImpl.getNamespaceURI();
        if (nameSpaceURI == null || nameSpaceURI.indexOf("http://java.sun.com/jsf/composite") == -1) {
            return null;
        }
        String nodeName = jsf2Element.getLocalName();
        String relativeLocation = "/resources" + nameSpaceURI.replaceFirst("http://java.sun.com/jsf/composite", "");
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null) {
            IContainer[] folders;
            IVirtualFolder webRootFolder = component.getRootFolder().getFolder((IPath)new Path("/"));
            IContainer[] iContainerArray = folders = webRootFolder.getUnderlyingFolders();
            int n = folders.length;
            int n2 = 0;
            while (n2 < n) {
                IContainer folder = iContainerArray[n2];
                IPath path = folder.getFullPath().append(relativeLocation).append("/" + nodeName + ".xhtml");
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                if (file.isAccessible()) {
                    return file;
                }
                ++n2;
            }
        }
        if ((jer = JSF2ResourceUtil.searchInClassPath(project, classPathResource = "META-INF" + relativeLocation + "/" + nodeName + ".xhtml", 1)) != null) {
            return jer;
        }
        IResource r = JSF2ResourceUtil.searchInClassPath2(project, classPathResource, 1);
        if (r != null) {
            return r;
        }
        return null;
    }

    private static JarEntryResource searchInClassPath(IProject project, String classPathResource, int jarResourceType) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getAllPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                JarPackageFragmentRoot jarPackageFragmentRoot;
                ZipEntry zipEntry;
                IPackageFragmentRoot fragmentRoot = iPackageFragmentRootArray[n2];
                if (fragmentRoot instanceof JarPackageFragmentRoot && (zipEntry = (jarPackageFragmentRoot = (JarPackageFragmentRoot)fragmentRoot).getJar().getEntry(classPathResource)) != null) {
                    if (jarResourceType == 1) {
                        JarEntryFile fileInJar = new JarEntryFile(classPathResource);
                        fileInJar.setParent((Object)jarPackageFragmentRoot);
                        return fileInJar;
                    }
                    if (jarResourceType == 2) {
                        JarEntryDirectory directoryInJar = new JarEntryDirectory(classPathResource);
                        directoryInJar.setParent((Object)jarPackageFragmentRoot);
                        return directoryInJar;
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            JSFModelPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (CoreException e) {
            JSFModelPlugin.getPluginLog().logError((Throwable)e);
        }
        return null;
    }

    private static IResource searchInClassPath2(IProject project, String classPathResource, int jarResourceType) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getAllPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot fragmentRoot = iPackageFragmentRootArray[n2];
                IResource r = fragmentRoot.getResource();
                if (fragmentRoot instanceof ExternalPackageFragmentRoot) {
                    r = ((ExternalPackageFragmentRoot)fragmentRoot).resource();
                }
                if (r instanceof IFolder && r.exists()) {
                    IFolder f = (IFolder)r;
                    IFile f1 = f.getFile(classPathResource);
                    if (f1.exists()) {
                        return f1;
                    }
                    IFolder f2 = f.getFolder(classPathResource);
                    if (f2.exists()) {
                        return f2;
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            JSFModelPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (CoreException e) {
            JSFModelPlugin.getPluginLog().logError((Throwable)e);
        }
        return null;
    }

    public static Object findResourcesFolderContainerByNameSpace(IProject project, String nameSpaceURI) {
        String classPathResource;
        JarEntryResource jer;
        if (nameSpaceURI == null || nameSpaceURI.indexOf("http://java.sun.com/jsf/composite") == -1) {
            return null;
        }
        String relativeLocation = "/resources" + nameSpaceURI.replaceFirst("http://java.sun.com/jsf/composite", "");
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null) {
            IContainer[] folders;
            IVirtualFolder webRootFolder = component.getRootFolder().getFolder((IPath)new Path("/"));
            IContainer[] iContainerArray = folders = webRootFolder.getUnderlyingFolders();
            int n = folders.length;
            int n2 = 0;
            while (n2 < n) {
                IContainer folder = iContainerArray[n2];
                IPath path = folder.getFullPath().append(relativeLocation);
                IFolder resFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
                if (resFolder.isAccessible()) {
                    return resFolder;
                }
                ++n2;
            }
        }
        if ((jer = JSF2ResourceUtil.searchInClassPath(project, classPathResource = "META-INF" + relativeLocation, 2)) != null) {
            return jer;
        }
        IResource r = JSF2ResourceUtil.searchInClassPath2(project, classPathResource, 2);
        if (r != null) {
            return r;
        }
        return null;
    }

    public static boolean isResourcesFolderExists(IProject project, String nameSpaceURI) {
        return JSF2ResourceUtil.findResourcesFolderContainerByNameSpace(project, nameSpaceURI) != null;
    }

    public static IFolder createResourcesFolderByNameSpace(IProject project, String nameSpaceURI) throws CoreException {
        IVirtualComponent component;
        IFolder compositeCompResFolder = null;
        String relativeLocation = nameSpaceURI.replaceFirst("http://java.sun.com/jsf/composite", "");
        if (!project.exists()) {
            return null;
        }
        if (!project.isAccessible()) {
            try {
                project.open((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                JSFModelPlugin.getPluginLog().logError((Throwable)e);
                return compositeCompResFolder;
            }
        }
        if ((component = ComponentCore.createComponent((IProject)project)) != null) {
            IVirtualFolder webRootFolder = component.getRootFolder().getFolder((IPath)new Path("/"));
            IContainer folder = webRootFolder.getUnderlyingFolder();
            IFolder webFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(folder.getFullPath());
            IFolder resourcesFolder = webFolder.getFolder("resources");
            NullProgressMonitor monitor = new NullProgressMonitor();
            if (!resourcesFolder.exists()) {
                resourcesFolder.create(true, true, (IProgressMonitor)monitor);
            }
            String[] segments = new Path(relativeLocation).segments();
            compositeCompResFolder = resourcesFolder;
            int i = 0;
            while (i < segments.length) {
                if (!(compositeCompResFolder = compositeCompResFolder.getFolder(segments[i])).exists()) {
                    compositeCompResFolder.create(true, true, (IProgressMonitor)monitor);
                }
                ++i;
            }
        }
        return compositeCompResFolder;
    }

    public static IFile createCompositeComponentFile(IProject project, IPath resourceRelativePath) throws CoreException {
        IVirtualComponent component;
        IFile compositeCompResFile = null;
        if (!project.exists()) {
            return null;
        }
        if (!project.isAccessible()) {
            try {
                project.open((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                JSFModelPlugin.getPluginLog().logError((Throwable)e);
                return compositeCompResFile;
            }
        }
        if ((component = ComponentCore.createComponent((IProject)project)) != null) {
            IContainer[] folders = WebUtils.getWebRootFolders((IProject)project);
            if (folders == null || folders.length == 0) {
                return null;
            }
            IFolder resourcesFolder = folders[0].getFolder((IPath)new Path("resources"));
            NullProgressMonitor monitor = new NullProgressMonitor();
            if (!resourcesFolder.exists()) {
                resourcesFolder.create(true, true, (IProgressMonitor)monitor);
            }
            String[] segments = resourceRelativePath.segments();
            IFolder componentPathFolder = resourcesFolder;
            int i = 0;
            while (i < segments.length - 1) {
                if (!(componentPathFolder = componentPathFolder.getFolder(segments[i])).exists()) {
                    componentPathFolder.create(true, true, (IProgressMonitor)monitor);
                }
                ++i;
            }
            compositeCompResFile = componentPathFolder.getFile(segments[segments.length - 1]);
            if (!compositeCompResFile.exists()) {
                compositeCompResFile.create(JSF2TemplateManager.getManager().createStreamFromTemplate("composite.xhtml"), true, (IProgressMonitor)monitor);
            } else {
                compositeCompResFile = JSF2ComponentModelManager.getManager().revalidateCompositeComponentFile(compositeCompResFile);
            }
        }
        return compositeCompResFile;
    }

    public static IFile createCompositeComponentFile(IProject project, IPath resourceRelativePath, String[] attrNames) throws CoreException {
        IFile jsf2ResFile = JSF2ResourceUtil.createCompositeComponentFile(project, resourceRelativePath);
        if (jsf2ResFile == null) {
            return null;
        }
        if (attrNames == null || attrNames.length == 0) {
            return jsf2ResFile;
        }
        return JSF2ComponentModelManager.getManager().updateJSF2CompositeComponentFile(jsf2ResFile, attrNames);
    }

    public static String calculateProjectRelativeJSF2ResourceProposal(IProject project) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        String projectResourceRelativePath = "";
        if (component != null) {
            IVirtualFolder webRootFolder = component.getRootFolder().getFolder((IPath)new Path("/"));
            IContainer folder = webRootFolder.getUnderlyingFolder();
            IFolder webFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(folder.getFullPath());
            IFolder resourcesFolder = webFolder.getFolder("resources");
            resourcesFolder.getProjectRelativePath().toString();
            projectResourceRelativePath = String.valueOf(project.getName()) + File.separator + resourcesFolder.getProjectRelativePath().toString();
        }
        return projectResourceRelativePath;
    }

    public static IResource getValidatingResource(IValidationContext helper) {
        IResource resource = null;
        if (helper instanceof IncrementalHelper) {
            IncrementalHelper incrementalHelper = (IncrementalHelper)helper;
            IProject project = incrementalHelper.getProject();
            if (project == null) {
                return resource;
            }
            String[] uris = helper.getURIs();
            if (uris == null || uris.length < 1) {
                return resource;
            }
            String filePath = uris[0];
            if (filePath == null) {
                return resource;
            }
            filePath = filePath.substring(filePath.indexOf(47) + 1);
            resource = project.findMember(filePath.substring(filePath.indexOf(47) + 1));
        }
        return resource;
    }
}

