/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model.helpers;

import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.markers.XMarkerManager;
import org.jboss.tools.jsf.model.JSFConstants;
import org.jboss.tools.jsf.model.ReferenceGroupImpl;
import org.jboss.tools.jst.web.model.ReferenceObject;
import org.jboss.tools.jst.web.model.helpers.WebProcessStructureHelper;

public class JSFProcessStructureHelper
extends WebProcessStructureHelper
implements JSFConstants {
    public static final JSFProcessStructureHelper instance = new JSFProcessStructureHelper();

    public XModelObject getParentProcess(XModelObject element) {
        XModelObject p = element;
        while (p != null && p.getFileType() == 0 && !"JSFProcess".equals(p.getModelEntity().getName())) {
            p = p.getParent();
        }
        return p;
    }

    public XModelObject[] getGroups(XModelObject process) {
        return process.getChildren("JSFProcessGroup");
    }

    public XModelObject[] getItems(XModelObject group) {
        return group.getChildren("JSFProcessItem");
    }

    public boolean isMultiRuleGroup(XModelObject group) {
        return this.getItems(group).length > 1;
    }

    public XModelObject[] getOutputs(XModelObject item) {
        return item.getChildren("JSFProcessItemOutput");
    }

    public String getPath(XModelObject element) {
        return element.getAttributeValue("path");
    }

    public XModelObject getItemOutputTarget(XModelObject itemOutput) {
        return itemOutput.getParent().getParent().getParent().getChildByPath(itemOutput.getAttributeValue("target"));
    }

    public boolean isGroupPattern(XModelObject group) {
        String path = group.getAttributeValue("path");
        return path != null && (path.length() == 0 || path.indexOf(42) >= 0);
    }

    public String getPageTitle(XModelObject group) {
        return group.getPresentationString();
    }

    public String getItemOutputPresentation(XModelObject itemOutput) {
        return itemOutput.getPresentationString();
    }

    public static String createItemOutputPresentation(XModelObject reference) {
        if (reference == null) {
            return null;
        }
        String action = reference.getAttributeValue("from-action");
        String prefix = action == null || action.length() == 0 ? "" : String.valueOf(action) + ":";
        String outcome = reference.getAttributeValue("from-outcome");
        if (outcome.length() == 0) {
            outcome = "[any]";
        }
        return String.valueOf(prefix) + outcome;
    }

    public boolean isUnconfirmedPage(XModelObject group) {
        if (!(group instanceof ReferenceGroupImpl)) {
            return false;
        }
        if (this.isGroupPattern(group)) {
            return false;
        }
        return !"true".equals(group.getAttributeValue("confirmed"));
    }

    public XModelObject getReference(XModelObject diagramObject) {
        if (diagramObject instanceof ReferenceGroupImpl) {
            ReferenceGroupImpl g = (ReferenceGroupImpl)diagramObject;
            XModelObject[] rs = g.getReferences();
            if (rs.length > 0) {
                return rs[0];
            }
            String path = g.getAttributeValue("path");
            if (path == null) {
                return null;
            }
            XModelObject page = g.getModel().getByPath(path);
            return page;
        }
        if (diagramObject instanceof ReferenceObject) {
            return ((ReferenceObject)diagramObject).getReference();
        }
        return null;
    }

    public boolean hasErrors(XModelObject diagramObject) {
        if (diagramObject instanceof ReferenceGroupImpl) {
            ReferenceGroupImpl g = (ReferenceGroupImpl)diagramObject;
            XModelObject[] rs = g.getReferences();
            if (rs.length > 0) {
                int i = 0;
                while (i < rs.length) {
                    if (XMarkerManager.getInstance().hasErrors(rs[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            if (this.isGroupPattern(diagramObject)) {
                return false;
            }
            String path = g.getAttributeValue("path");
            if (path != null) {
                XModelObject page = g.getModel().getByPath(path);
                return XMarkerManager.getInstance().hasErrors(page);
            }
        } else if (diagramObject instanceof ReferenceObject) {
            XModelObject reference = ((ReferenceObject)diagramObject).getReference();
            return XMarkerManager.getInstance().hasErrors(reference);
        }
        return XMarkerManager.getInstance().hasErrors(diagramObject);
    }
}

