/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model.helpers.converter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FilePathHelper;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.FindObjectHelper;
import org.jboss.tools.jsf.messages.JSFUIMessages;
import org.jboss.tools.jsf.model.pv.JSFProjectsRoot;
import org.jboss.tools.jsf.model.pv.JSFProjectsTree;
import org.jboss.tools.jst.web.model.pv.WebProjectNode;

public class OpenKeyHelper {
    public String run(XModel model, String bundle, String locale) {
        if (model == null) {
            return null;
        }
        if (bundle == null || bundle.length() == 0) {
            return JSFUIMessages.BUNDLE_IS_NOT_SPECIFIED;
        }
        XModelObject[] bs = this.findBundles(model, bundle, locale);
        if (bs.length == 0) {
            return NLS.bind((String)JSFUIMessages.CANNOT_FIND_BUNDLE, (Object)bundle);
        }
        FindObjectHelper.findModelObject((XModelObject)bs[0], (int)FindObjectHelper.EVERY_WHERE);
        return null;
    }

    public String run(XModel model, String bundle, String key, String locale) {
        if (model == null) {
            return null;
        }
        if (key == null || key.length() == 0) {
            return JSFUIMessages.KEY_ISNOT_SPECIFIED;
        }
        if (bundle == null || bundle.length() == 0) {
            return JSFUIMessages.BUNDLE_IS_NOT_SPECIFIED;
        }
        XModelObject[] bs = this.findBundles(model, bundle, locale);
        if (bs.length == 0) {
            return NLS.bind((String)JSFUIMessages.CANNOT_FIND_BUNDLE, (Object)bundle);
        }
        XModelObject c = null;
        int i = 0;
        while (i < bs.length && c == null) {
            c = this.findKey(model, bs[i], key);
            ++i;
        }
        if (c == null) {
            return NLS.bind((String)JSFUIMessages.CANNOT_FIND_PROPERTY, (Object)key);
        }
        FindObjectHelper.findModelObject(c, (int)FindObjectHelper.IN_EDITOR_ONLY);
        return null;
    }

    public XModelObject[] findBundles(XModel model, String bundle, String locale) {
        XModelObject o;
        String path;
        ArrayList<XModelObject> l = new ArrayList<XModelObject>();
        if (locale == null || locale.length() == 0) {
            locale = OpenKeyHelper.getDeafultLocale(model);
        }
        String pathPrefix = "/" + bundle.replace('.', '/');
        IProject project = EclipseResourceUtil.getProject((XModelObject)model.getRoot());
        Set srcs = EclipseResourceUtil.getAllVisibleSourceFolders((IProject)project);
        HashSet<XModelObject> srcObjects = new HashSet<XModelObject>();
        for (IFolder f : srcs) {
            XModelObject src;
            if (f.getProject() == project || (src = EclipseResourceUtil.createObjectForResource((IResource)f)) == null) continue;
            srcObjects.add(src);
        }
        while (locale != null && locale.length() > 0) {
            path = String.valueOf(pathPrefix) + "_" + locale + ".properties";
            o = model.getByPath(path);
            if (o != null) {
                l.add(o);
            }
            for (XModelObject src : srcObjects) {
                o = src.getChildByPath(path.substring(1));
                if (o == null) continue;
                l.add(o);
            }
            int i = locale.lastIndexOf(95);
            if (i < 0) break;
            locale = locale.substring(0, i);
        }
        path = String.valueOf(pathPrefix) + ".properties";
        o = model.getByPath(path);
        if (o != null) {
            l.add(o);
        }
        for (XModelObject src : srcObjects) {
            o = src.getChildByPath(path.substring(1));
            if (o == null) continue;
            l.add(o);
        }
        if (!l.isEmpty()) {
            XModelObject[] ps;
            int i;
            if (o == null) {
                o = (XModelObject)l.get(0);
            }
            String name = (i = bundle.lastIndexOf(46)) < 0 ? bundle : bundle.substring(i + 1);
            name = FilePathHelper.toPathPath((String)name);
            XModelObject[] xModelObjectArray = ps = o.getParent().getChildren();
            int n = ps.length;
            int n2 = 0;
            while (n2 < n) {
                String pp;
                XModelObject c = xModelObjectArray[n2];
                if (!l.contains(c) && (pp = c.getPathPart()).endsWith(".properties") && (pp.startsWith(String.valueOf(name) + ".") || pp.startsWith(String.valueOf(name) + "_"))) {
                    l.add(c);
                }
                ++n2;
            }
        }
        return l.toArray(new XModelObject[0]);
    }

    public XModelObject findKey(XModel model, XModelObject bundle, String key) {
        return bundle.getChildByPath(key);
    }

    public static String getDeafultLocale(XModel model) {
        String facesConfigLocale = OpenKeyHelper.getDeafultLocaleFromFacesConfig(model);
        if (facesConfigLocale.length() == 0) {
            Locale locale = Locale.getDefault();
            facesConfigLocale = locale == null || locale.toString().length() == 0 ? null : locale.toString();
        }
        return facesConfigLocale;
    }

    public static String getDeafultLocaleFromFacesConfig(XModel model) {
        String facesConfigLocale = "";
        JSFProjectsRoot root = JSFProjectsTree.getProjectsRoot(model);
        WebProjectNode conf = root == null ? null : (WebProjectNode)root.getChildByPath("Configuration");
        XModelObject[] fs = conf == null ? new XModelObject[]{} : conf.getTreeChildren();
        int i = 0;
        while (i < fs.length) {
            String res;
            XModelObject o = fs[i].getChildByPath("application/Locale Config");
            String string = res = o == null ? "" : o.getAttributeValue("default-locale");
            if (res != null && res.length() > 0) {
                facesConfigLocale = res;
            }
            ++i;
        }
        return facesConfigLocale;
    }
}

