/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model.pv;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.jsf.model.pv.JSFProjectBean;
import org.jboss.tools.jsf.model.pv.JSFProjectsRoot;
import org.jboss.tools.jsf.model.pv.JSFProjectsTree;
import org.jboss.tools.jsf.model.pv.JSFPromptingProvider;
import org.jboss.tools.jst.web.model.pv.WebProjectNode;

public class JSFBeanSearcher {
    WebProjectNode beans;
    WebProjectNode conf;
    XModelObject bean;
    JSFProjectBean beanClass;
    String property;

    public JSFBeanSearcher(XModel model) {
        JSFProjectsRoot root = JSFProjectsTree.getProjectsRoot(model);
        if (root == null) {
            return;
        }
        this.beans = (WebProjectNode)root.getChildByPath("Beans");
        this.conf = (WebProjectNode)root.getChildByPath("Configuration");
    }

    public void parse(String path) {
        String[] a = this.toArray(path);
        if (a.length == 0) {
            return;
        }
        this.bean = JSFPromptingProvider.findBean(this.conf, a[0]);
        this.beanClass = (JSFProjectBean)JSFPromptingProvider.findBeanClass(this.beans, this.bean);
        if (this.bean == null || a.length < 2) {
            return;
        }
        this.property = a[1];
        int i = 1;
        while (i < a.length - 1) {
            if (!this.next()) {
                return;
            }
            this.property = a[i + 1];
            ++i;
        }
    }

    String[] toArray(String path) {
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(path, ".");
        while (st.hasMoreElements()) {
            l.add(st.nextToken());
        }
        return l.toArray(new String[0]);
    }

    private boolean next() {
        if (this.bean == null || this.beanClass == null || this.property == null) {
            return false;
        }
        XModelObject p = this.beanClass.getChildByPath(this.property);
        if (p == null) {
            return false;
        }
        String cls = p.getAttributeValue("class name");
        Object b = JSFPromptingProvider.findBeanClassByClassName(this.beans, cls);
        if (!(b instanceof JSFProjectBean) && !((b = JSFPromptingProvider.buildBean(p.getModel(), cls)) instanceof JSFProjectBean)) {
            return false;
        }
        this.beanClass = (JSFProjectBean)((Object)b);
        XModelObject[] beanList = this.beanClass.getBeanList();
        if (beanList.length > 0) {
            this.bean = beanList[0];
        }
        return true;
    }

    public XModelObject getBean() {
        return this.bean;
    }

    public XModelObject getBeanClass() {
        return this.beanClass;
    }

    public String getProperty() {
        return this.property;
    }
}

