/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard;

import org.jboss.tools.common.model.ui.editors.dnd.DropWizardMessages;
import org.jboss.tools.common.model.ui.editors.dnd.IElementGenerator;
import org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard.NewIonicWidgetWizard;
import org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard.NewTabsWizardPage;
import org.jboss.tools.jst.angularjs.internal.ui.AngularJsUIImages;

public class NewTabsWizard
extends NewIonicWidgetWizard<NewTabsWizardPage> {
    public NewTabsWizard() {
        this.setWindowTitle(DropWizardMessages.Wizard_Window_Title);
        this.setDefaultPageImageDescriptor(AngularJsUIImages.getInstance().getOrCreateImageDescriptor(AngularJsUIImages.TABS_IMAGE));
    }

    protected NewTabsWizardPage createPage() {
        return new NewTabsWizardPage();
    }

    @Override
    protected void addContent(IElementGenerator.ElementNode parent, boolean browser) {
        String position;
        IElementGenerator.ElementNode tabs = parent.addChild("ion-tabs");
        this.addAttributeIfNotEmpty(tabs, "delegate-handle", "delegate-handle");
        this.addID("tabs-", tabs);
        StringBuilder cls = new StringBuilder();
        String color = ((NewTabsWizardPage)this.page).getEditorValue("tabs-color");
        if (color.length() > 0) {
            NewTabsWizard.addClass((StringBuilder)cls, (String)color);
        }
        if ((position = ((NewTabsWizardPage)this.page).getEditorValue("data-iconpos")).length() > 0) {
            NewTabsWizard.addClass((StringBuilder)cls, (String)("tabs-icon-" + position));
        }
        if (this.isTrue("tabs-item-hide")) {
            NewTabsWizard.addClass((StringBuilder)cls, (String)"tabs-item-hide");
        }
        if (cls.length() > 0) {
            tabs.addAttribute("class", cls.toString());
        }
        int n = ((NewTabsWizardPage)this.page).tabs.getNumber();
        int i = 0;
        while (i < n) {
            String icon;
            String tabName = ((NewTabsWizardPage)this.page).tabs.getTitle(i);
            String text = browser ? "Content of " + tabName : null;
            IElementGenerator.ElementNode tab = tabs.addChild("ion-tab", text);
            if (!browser) {
                tab.addComment("Tab " + (i + 1) + " content");
            }
            tab.addAttribute("title", tabName);
            String url = ((NewTabsWizardPage)this.page).tabs.getURL(i);
            if (url.length() > 0) {
                tab.addAttribute("href", url);
            }
            if ((icon = ((NewTabsWizardPage)this.page).tabs.getIcon(i)).length() > 0) {
                tab.addAttribute("icon", icon);
            }
            ++i;
        }
    }
}

