/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard;

import org.jboss.tools.common.model.ui.editors.dnd.DropWizardMessages;
import org.jboss.tools.common.model.ui.editors.dnd.IElementGenerator;
import org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard.IonicConstants;
import org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard.NewIonicWidgetWizard;
import org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard.NewTextInputWizardPage;
import org.jboss.tools.jst.angularjs.internal.ui.AngularJsUIImages;

public class NewTextInputWizard
extends NewIonicWidgetWizard<NewTextInputWizardPage>
implements IonicConstants {
    public NewTextInputWizard() {
        this.setWindowTitle(DropWizardMessages.Wizard_Window_Title);
        this.setDefaultPageImageDescriptor(AngularJsUIImages.getInstance().getOrCreateImageDescriptor(AngularJsUIImages.TEXT_INPUT_IMAGE));
    }

    protected NewTextInputWizardPage createPage() {
        return new NewTextInputWizardPage();
    }

    protected boolean isRange() {
        return this.isTrue("range");
    }

    @Override
    protected void addContent(IElementGenerator.ElementNode parent, boolean browser) {
        String labelText;
        if (browser) {
            IElementGenerator.ElementNode form = this.getFormNode(parent);
            IElementGenerator.ElementNode div = form.addChild("div");
            div.addAttribute("style", "padding: 20px 20px 20px 20px;");
            parent = div;
        }
        String style = ((NewTextInputWizardPage)this.page).getEditorValue("input-label-style");
        String type = ((NewTextInputWizardPage)this.page).getEditorValue("text-type");
        boolean isTextArea = "textarea".equals(type);
        IElementGenerator.ElementNode label = parent.addChild("label");
        String labelClass = this.getLabelClass(style);
        if (labelClass.length() > 0) {
            label.addAttribute("class", labelClass);
        }
        if ((labelText = ((NewTextInputWizardPage)this.page).getEditorValue("label")).length() > 0) {
            IElementGenerator.ElementNode span = label.addChild("span", labelText);
            span.addAttribute("class", "input-label");
        }
        IElementGenerator.ElementNode input = isTextArea ? label.addChild("textarea", ((NewTextInputWizardPage)this.page).getEditorValue("value")) : label.addChild("input");
        this.addAttributeIfNotEmpty(input, "ng-model", "ng-model");
        this.addAttributeIfNotEmpty(input, "name", "name");
        if (this.isTrue("disabled")) {
            input.addAttribute("disabled", "disabled");
        }
        if (!"textarea".equals(type)) {
            this.addAttributeIfNotEmpty(input, "value", "value");
        }
        this.addAttributeIfNotEmpty(input, "placeholder", "placeholder");
        if ("number".equals(type)) {
            this.addAttributeIfNotEmpty(input, "min", "min");
            this.addAttributeIfNotEmpty(input, "max", "max");
            this.addAttributeIfNotEmpty(input, "step", "step");
        }
        this.addAttributeIfNotEmpty(input, "ng-pattern", "pattern");
        this.addAttributeIfNotEmpty(input, "maxlength", "maxlength");
        if (this.isTrue("autofocus")) {
            input.addAttribute("autofocus", "true");
        }
        if (this.isTrue("required")) {
            input.addAttribute("required", "true");
        }
        if (!"textarea".equals(type)) {
            input.addAttribute("type", type);
        } else {
            input.addAttribute("cols", "40");
            input.addAttribute("rows", "8");
        }
    }

    String getLabelClass(String style) {
        if (style.length() == 0) {
            return "";
        }
        StringBuilder cls = new StringBuilder();
        NewTextInputWizard.addClass((StringBuilder)cls, (String)"item");
        NewTextInputWizard.addClass((StringBuilder)cls, (String)"item-input");
        if ("stacked".equals(style)) {
            NewTextInputWizard.addClass((StringBuilder)cls, (String)"item-stacked-label");
        } else if ("floating".equals(style)) {
            NewTextInputWizard.addClass((StringBuilder)cls, (String)"item-floating-label");
        }
        return cls.toString();
    }
}

