/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.action;

import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.meta.action.impl.XEntityDataImpl;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.action.AbstractModelActionDelegate;
import org.jboss.tools.common.model.ui.dnd.DnDUtil;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.XModelTreeListenerSWTASync;
import org.jboss.tools.jst.web.browser.AbstractBrowserContext;
import org.jboss.tools.jst.web.browser.wtp.RunOnServerContext;
import org.jboss.tools.jst.web.server.ServerManager;
import org.jboss.tools.jst.web.server.ServerManagerListener;
import org.jboss.tools.jst.web.ui.Messages;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.action.RunSelectorSupport;

public class RunPageActionDelegate
extends AbstractModelActionDelegate
implements IWorkbenchWindowPulldownDelegate {
    static AbstractBrowserContext context = RunOnServerContext.getInstance();
    IAction action;
    XModel selectedModel = null;
    XModelTreeListenerSWTASync syncListener = new XModelTreeListenerSWTASync((XModelTreeListener)new XModelTreeListenerImpl());
    ServerManagerListener sml = new SML();
    static String defaultToolTip = null;
    private boolean stopped = false;

    public RunPageActionDelegate() {
        ServerManager.getInstance().addListener(this.sml);
    }

    public void init(IWorkbenchWindow window) {
        super.init(window);
        new Thread((Runnable)new R(), "Update Run Page Action").start();
    }

    protected void safeSelectionChanged(IAction action, ISelection selection) {
        this.action = action;
        XModelObject adapter = this.getAdapter(selection);
        if (adapter == null) {
            IProject p = this.getSelectedProject(selection);
            if (p != null) {
                adapter = EclipseResourceUtil.createObjectForResource((IResource)p);
            } else {
                if (!(RunPageActionDelegate.context.lastRunObject == null || (p = (IProject)RunPageActionDelegate.context.lastRunObject.getModel().getProperties().get("project")) != null && p.isOpen() && p.exists())) {
                    context.setLastRunObject(null);
                    this.update();
                }
                return;
            }
        }
        XModelObject o = adapter;
        if (this.object == null || o != null && o.getModel() != this.object.getModel()) {
            if (o != null) {
                this.object = o.getModel().getRoot();
            }
            if (this.object == null) {
                context.setLastRunObject(null);
            } else {
                context.activateModel(this.object.getModel());
            }
        } else if (o != null && o != RunPageActionDelegate.context.lastRunObject) {
            context.activateModel(this.object.getModel());
        } else {
            context.setLastRunObject(RunPageActionDelegate.context.lastRunObject);
        }
        this.update();
    }

    private IProject getSelectedProject(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        Object o = ((IStructuredSelection)selection).getFirstElement();
        IProject p = null;
        if (o instanceof IResource) {
            p = ((IResource)o).getProject();
        } else if (o instanceof IJavaElement) {
            p = ((IJavaElement)o).getJavaProject().getProject();
        }
        return p;
    }

    protected void update() {
        this.object = RunPageActionDelegate.context.lastRunObject;
        if (this.object != null && !this.object.isActive() && !context.isJustUrl(context.getLastRunURL())) {
            this.object = this.object.getModel().getRoot();
            context.setLastRunObject(this.object);
        }
        if (this.action != null) {
            String lastRunURL;
            if (defaultToolTip == null) {
                defaultToolTip = this.action.getToolTipText();
            }
            this.action.setEnabled(this.computeEnabled());
            String tip = defaultToolTip;
            if (this.object != null && (lastRunURL = context.getLastRunURL()) != null && !lastRunURL.startsWith("%server%")) {
                tip = MessageFormat.format(Messages.RunPageActionDelegate_RunURL, lastRunURL);
            }
            this.action.setToolTipText(tip);
        }
        this.updateModel();
    }

    private void updateModel() {
        XModel m;
        XModel xModel = m = this.object == null ? null : this.object.getModel();
        if (m == this.selectedModel) {
            return;
        }
        if (this.selectedModel != null) {
            this.selectedModel.removeModelTreeListener((XModelTreeListener)this.syncListener);
        }
        this.selectedModel = m;
        if (this.selectedModel != null) {
            this.selectedModel.addModelTreeListener((XModelTreeListener)this.syncListener);
        }
    }

    protected boolean computeEnabled() {
        this.object = RunPageActionDelegate.context.lastRunObject;
        return true;
    }

    String getModelActionPath() {
        return context.getModelActionPath();
    }

    protected void doRun() {
        if (context.isJustUrl(context.getLastRunURL())) {
            if (!RunPageActionDelegate.saveAllEditors()) {
                return;
            }
            context.runJustUrl();
        } else if (this.object != null && DnDUtil.getEnabledAction((XModelObject)this.object, null, (String)this.getModelActionPath()) != null) {
            if (!RunPageActionDelegate.saveAllEditors()) {
                return;
            }
            Properties p = new Properties();
            p.put("shell", this.window.getShell());
            XActionInvoker.invoke((String)this.getModelActionPath(), (XModelObject)this.object, (Properties)p);
        } else {
            this.getMenu((Control)this.window.getShell()).setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.stopped = true;
        this.action = null;
        Object object = RunPageActionDelegate.context.monitor;
        synchronized (object) {
            try {
                RunPageActionDelegate.context.monitor.notifyAll();
            }
            catch (Exception e) {
                WebUiPlugin.getPluginLog().logError((Throwable)e);
            }
        }
        if (this.sml != null) {
            ServerManager.getInstance().removeListener(this.sml);
            this.sml = null;
        }
    }

    public Menu getMenu(Control parent) {
        String[] items;
        int i;
        Menu menu = new Menu(parent);
        MenuItem item = null;
        String lastRunURL = context.getLastRunURL();
        if (lastRunURL != null) {
            if (!lastRunURL.startsWith("%server%")) {
                item = new MenuItem(menu, 8);
                item.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        RunPageActionDelegate.this.run(RunPageActionDelegate.this.action);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }
                });
                item.setText(context.getLastRunURL());
            } else {
                item = new MenuItem(menu, 8);
                String message = lastRunURL.substring("%server%".length());
                i = message.indexOf("/");
                if (i >= 0) {
                    message = message.substring(0, i);
                }
                item.setText(message);
            }
        }
        if ((items = context.getHistory()).length > 0) {
            item = new MenuItem(menu, 2);
            i = 0;
            while (i < items.length) {
                final String url = items[i];
                item = new MenuItem(menu, 8);
                item.setText(url);
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (context.isJustUrl(url)) {
                            context.activateJustUrl(url);
                        } else {
                            XModelObject o = context.activateItem(url);
                            if (o == null) {
                                return;
                            }
                        }
                        RunPageActionDelegate.this.update();
                        RunPageActionDelegate.this.run(RunPageActionDelegate.this.action);
                    }
                });
                ++i;
            }
        }
        if (item != null) {
            item = new MenuItem(menu, 2);
        }
        item = new MenuItem(menu, 8);
        item.setText(Messages.RunPageActionDelegate_RunMenuItem);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RunPageActionDelegate.this.runSelector();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return menu;
    }

    private void runSelector() {
        if (!RunPageActionDelegate.saveAllEditors()) {
            return;
        }
        XEntityDataImpl data = XEntityDataImpl.create((String[][])new String[][]{{"RunPageHelper"}, {"url", "yes"}});
        XModelObject dummy = PreferenceModelUtilities.getPreferenceModel().createModelObject("RunPageHelper", null);
        int i = RunSelectorSupport.run(dummy, (XEntityData)data, null);
        if (i != 0) {
            return;
        }
        String url = data.getValue("url");
        context.activateJustUrl(url);
        this.update();
        this.run(this.action);
    }

    public static boolean saveAllEditors() {
        return ModelUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().saveAllEditors(true);
    }

    class R
    implements Runnable {
        R() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!RunPageActionDelegate.this.stopped) {
                Object object = RunPageActionDelegate.context.monitor;
                synchronized (object) {
                    try {
                        RunPageActionDelegate.context.monitor.wait();
                    }
                    catch (Exception e) {
                        WebUiPlugin.getPluginLog().logError((Throwable)e);
                    }
                }
                if (RunPageActionDelegate.this.stopped) continue;
                RunPageActionDelegate.this.update();
            }
        }
    }

    class R2
    implements Runnable {
        R2() {
        }

        @Override
        public void run() {
            context.setLastRunObject(RunPageActionDelegate.context.lastRunObject);
        }
    }

    class SML
    implements ServerManagerListener {
        SML() {
        }

        public void serverManagerChanged() {
            Display.getDefault().asyncExec((Runnable)new R2());
        }
    }

    class XModelTreeListenerImpl
    implements XModelTreeListener {
        XModelTreeListenerImpl() {
        }

        public void nodeChanged(XModelTreeEvent event) {
            if ("FileSystems".equals(event.getModelObject().getPath())) {
                context.setLastRunObject(RunPageActionDelegate.context.lastRunObject);
            }
        }

        public void structureChanged(XModelTreeEvent event) {
        }
    }
}

