/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jst.jsp.ui.StructuredTextViewerConfigurationJSP;
import org.eclipse.jst.jsp.ui.internal.contentassist.JSPStructuredContentAssistProcessor;
import org.eclipse.jst.jsp.ui.internal.style.jspel.LineStyleProviderForJSPEL;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.sse.ui.internal.ExtendedConfigurationBuilder;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.derived.HTMLTextPresenter;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;
import org.eclipse.wst.sse.ui.internal.taginfo.AnnotationHoverProcessor;
import org.eclipse.wst.sse.ui.internal.taginfo.TextHoverManager;
import org.eclipse.wst.sse.ui.internal.util.EditorUtility;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkDetector;
import org.jboss.tools.common.text.xml.BaseQuickAssistProcessor;
import org.jboss.tools.common.text.xml.contentassist.ProposalSorter;
import org.jboss.tools.common.text.xml.info.ChainTextHover;
import org.jboss.tools.common.text.xml.info.TextHoverInformationProvider;
import org.jboss.tools.common.text.xml.xpl.MarkerProblemAnnotationHoverProcessor;
import org.jboss.tools.jst.web.ui.internal.editor.contentassist.ELPrefixUtils;

public class JSPTextViewerConfiguration
extends StructuredTextViewerConfigurationJSP {
    private static final char[] PROPOSAL_AUTO_ACTIVATION_CHARS = new char[]{'<', '=', '\"', '\'', '.', '{', '['};
    private LineStyleProvider fLineStyleProviderForJSPEL2;
    private IQuickAssistAssistant fQuickAssistant = null;

    private LineStyleProvider getLineStyleProviderForJSPEL2() {
        if (this.fLineStyleProviderForJSPEL2 == null) {
            this.fLineStyleProviderForJSPEL2 = new LineStyleProviderForJSPEL();
        }
        return this.fLineStyleProviderForJSPEL2;
    }

    public LineStyleProvider[] getLineStyleProviders(ISourceViewer sourceViewer, String partitionType) {
        LineStyleProvider[] providers = null;
        providers = partitionType == "org.eclipse.jst.jsp.SCRIPT.JSP_EL2" ? new LineStyleProvider[]{this.getLineStyleProviderForJSPEL2()} : super.getLineStyleProviders(sourceViewer, partitionType);
        return providers;
    }

    protected IContentAssistProcessor[] getContentAssistProcessors(ISourceViewer sourceViewer, String partitionType) {
        return new IContentAssistProcessor[]{new JSPStructuredContentAssistProcessor((ContentAssistant)this.getContentAssistant(), partitionType, (ITextViewer)sourceViewer){

            protected List filterAndSortProposals(List proposals, IProgressMonitor monitor, CompletionProposalInvocationContext context) {
                return ProposalSorter.filterAndSortProposals((List)proposals, (IProgressMonitor)monitor, (CompletionProposalInvocationContext)context, (ProposalSorter.IProposalFilter)ELPrefixUtils.EL_PROPOSAL_FILTER);
            }

            public char[] getCompletionProposalAutoActivationCharacters() {
                char[] superAutoActivationCharacters = super.getCompletionProposalAutoActivationCharacters();
                if (superAutoActivationCharacters == null) {
                    return PROPOSAL_AUTO_ACTIVATION_CHARS;
                }
                String chars = new String(superAutoActivationCharacters);
                char[] cArray = PROPOSAL_AUTO_ACTIVATION_CHARS;
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char ch = cArray[n2];
                    if (chars.indexOf(ch) == -1) {
                        chars = String.valueOf(chars) + ch;
                    }
                    ++n2;
                }
                return chars.toCharArray();
            }
        }};
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        IHyperlinkDetector[] superDetectors;
        if (!this.fPreferenceStore.getBoolean("hyperlinksEnabled")) {
            return null;
        }
        ArrayList<Object> allDetectors = new ArrayList<Object>();
        HyperlinkDetector extHyperlinkDetector = HyperlinkDetector.getInstance();
        if (extHyperlinkDetector != null) {
            allDetectors.add(extHyperlinkDetector);
        }
        if ((superDetectors = super.getHyperlinkDetectors(sourceViewer)) != null) {
            IHyperlinkDetector[] iHyperlinkDetectorArray = superDetectors;
            int n = superDetectors.length;
            int n2 = 0;
            while (n2 < n) {
                IHyperlinkDetector detector = iHyperlinkDetectorArray[n2];
                if (!allDetectors.contains(detector)) {
                    allDetectors.add(detector);
                }
                ++n2;
            }
        }
        return allDetectors.toArray(new IHyperlinkDetector[0]);
    }

    private ITextHover[] createDocumentationHovers(String partitionType) {
        List extendedTextHover = ExtendedConfigurationBuilder.getInstance().getConfigurations("documentationTextHover", partitionType);
        ITextHover[] hovers = extendedTextHover.toArray(new ITextHover[extendedTextHover.size()]);
        ChainTextHover chainTextHover = new ChainTextHover(hovers);
        return new ITextHover[]{chainTextHover};
    }

    protected IInformationProvider getInformationProvider(ISourceViewer sourceViewer, String partitionType) {
        ITextHover[] hovers = this.createDocumentationHovers(partitionType);
        return new TextHoverInformationProvider((ITextHover)new ChainTextHover(hovers));
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        MarkerProblemAnnotationHoverProcessor textHover = null;
        TextHoverManager.TextHoverDescriptor[] hoverDescs = SSEUIPlugin.getDefault().getTextHoverManager().getTextHovers();
        int i = 0;
        while (i < hoverDescs.length && textHover == null) {
            if (hoverDescs[i].isEnabled() && JSPTextViewerConfiguration.computeStateMask((String)hoverDescs[i].getModifierString()) == stateMask) {
                ITextHover[] hovers;
                String hoverType = hoverDescs[i].getId();
                if ("problemHover".equalsIgnoreCase(hoverType)) {
                    textHover = new MarkerProblemAnnotationHoverProcessor();
                } else if ("annotationHover".equalsIgnoreCase(hoverType)) {
                    textHover = new AnnotationHoverProcessor();
                } else if ("combinationHover".equalsIgnoreCase(hoverType)) {
                    textHover = new ChainTextHover(this.createDocumentationHovers(contentType));
                } else if ("documentationHover".equalsIgnoreCase(hoverType) && (hovers = this.createDocumentationHovers(contentType)).length > 0) {
                    textHover = hovers[0];
                }
            }
            ++i;
        }
        return textHover;
    }

    private Color getColor(String key) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)key);
        return EditorUtility.getColor((RGB)rgb);
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        if (this.fQuickAssistant == null) {
            QuickAssistAssistant assistant = new QuickAssistAssistant();
            assistant.setQuickAssistProcessor((IQuickAssistProcessor)new BaseQuickAssistProcessor());
            assistant.setInformationControlCreator(this.getQuickAssistAssistantInformationControlCreator());
            if (this.fPreferenceStore != null) {
                Color color = this.getColor("content_assist_proposals_background");
                assistant.setProposalSelectorBackground(color);
                color = this.getColor("content_assist_proposals_foreground");
                assistant.setProposalSelectorForeground(color);
            }
            this.fQuickAssistant = assistant;
        }
        return this.fQuickAssistant;
    }

    private IInformationControlCreator getQuickAssistAssistantInformationControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
            }
        };
    }
}

