/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.contentassist;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.jboss.tools.common.el.ui.internal.info.ELInfoHover;
import org.jboss.tools.common.el.ui.internal.info.Messages;
import org.jboss.tools.common.text.IExecutableTextProposal;
import org.jboss.tools.common.text.ITextProposalProvider;
import org.jboss.tools.common.text.TextProposal;
import org.jboss.tools.common.util.EclipseUIUtil;
import org.jboss.tools.jst.web.ui.WebUiPlugin;

public class AutoContentAssistantProposal
extends CustomCompletionProposal
implements ICompletionProposalExtension3,
ICompletionProposalExtension4,
ICompletionProposalExtension5,
ICompletionProposalExtension6,
ITextProposalProvider {
    private boolean autoContentAssistant = false;
    private IRunnableWithProgress runnable = null;
    TextProposal originalProposal = null;
    List<String> alternativeMatches = new ArrayList<String>();
    private IInformationControlCreator fCreator;
    StyledString fStyledDisplayString;
    private int fOriginalReplacementLength;

    public AutoContentAssistantProposal(TextProposal originalProposal, String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, 0);
        this.originalProposal = originalProposal;
        this.fOriginalReplacementLength = replacementLength;
    }

    public AutoContentAssistantProposal(TextProposal originalProposal, String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, String alternateMatch, IContextInformation contextInformation, String additionalProposalInfo, int relevance) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, alternateMatch, contextInformation, additionalProposalInfo, relevance, true);
        this.originalProposal = originalProposal;
        this.fOriginalReplacementLength = replacementLength;
    }

    public AutoContentAssistantProposal(TextProposal originalProposal, String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int relevance) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, relevance);
        this.originalProposal = originalProposal;
        this.fOriginalReplacementLength = replacementLength;
    }

    public AutoContentAssistantProposal(TextProposal originalProposal, boolean autoContentAssistant, String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int relevance) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, relevance);
        this.originalProposal = originalProposal;
        this.autoContentAssistant = autoContentAssistant;
        this.fOriginalReplacementLength = replacementLength;
    }

    public AutoContentAssistantProposal(TextProposal originalProposal, boolean autoContentAssistant, String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int relevance, IRunnableWithProgress runnable) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, relevance);
        this.originalProposal = originalProposal;
        this.autoContentAssistant = autoContentAssistant;
        this.fOriginalReplacementLength = replacementLength;
        this.runnable = runnable;
    }

    public TextProposal getTextProposal() {
        return this.originalProposal;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        IExecutableTextProposal execProposal;
        if (this.originalProposal != null && (execProposal = this.originalProposal.getExecutable()) != null) {
            execProposal.apply(EclipseUIUtil.getActiveEditor(), this.getReplacementOffset(), this.getReplacementOffset() + this.getReplacementLength());
            return;
        }
        int diff = 0;
        if (this.runnable != null) {
            int length = viewer.getDocument().getLength();
            try {
                this.runnable.run(null);
            }
            catch (InvocationTargetException e) {
                WebUiPlugin.getPluginLog().logError((Throwable)e);
            }
            catch (InterruptedException e) {
                WebUiPlugin.getPluginLog().logError((Throwable)e);
            }
            diff = viewer.getDocument().getLength() - length;
            this.setReplacementOffset(this.getReplacementOffset() + diff);
        }
        super.apply(viewer, trigger, stateMask, offset + diff);
        if (this.autoContentAssistant && (this.originalProposal == null || this.originalProposal.isAutoActivationContentAssistantAfterApplication())) {
            Point selection = this.getSelection(viewer.getDocument());
            viewer.setSelectedRange(selection.x, selection.y);
            if (viewer instanceof ITextOperationTarget) {
                ((ITextOperationTarget)viewer).doOperation(13);
            }
        }
    }

    public Point getSelection(IDocument document) {
        Point selection = null;
        if (this.originalProposal != null && this.originalProposal.getPosition() > -1) {
            int correction = this.originalProposal.getPosition();
            String originalString = this.originalProposal.getReplacementString();
            int index = this.getReplacementString().indexOf(originalString);
            if (index > 0) {
                correction += index;
            }
            selection = new Point(this.getReplacementOffset() + correction, 0);
        } else {
            selection = super.getSelection(document);
        }
        return selection;
    }

    public int getCursorPosition() {
        int cursorPosition = -1;
        int firstAttributeEndPosition = this.getReplacementString().indexOf("=");
        int openEndTagPosition = this.getReplacementString().indexOf("</");
        int closeStartAndEndTagPosition = this.getReplacementString().indexOf("/>");
        if (firstAttributeEndPosition > -1) {
            cursorPosition = firstAttributeEndPosition + 2;
        } else if (openEndTagPosition > -1) {
            cursorPosition = openEndTagPosition;
        } else if (closeStartAndEndTagPosition > -1) {
            cursorPosition = closeStartAndEndTagPosition;
        }
        return cursorPosition > -1 ? cursorPosition : super.getCursorPosition();
    }

    public String getDisplayString() {
        if (super.getDisplayString() != null) {
            return super.getDisplayString();
        }
        if (super.getReplacementString() != null) {
            this.setDisplayString(super.getReplacementString());
            return super.getDisplayString();
        }
        return "";
    }

    public void setDisplayString(String string) {
        super.setDisplayString(string);
        boolean isJavaWordPart = string.length() > 0 && Character.isJavaIdentifierPart(string.charAt(0));
        boolean hasRetType = isJavaWordPart && string.indexOf(58) > 0;
        boolean hasDeclType = isJavaWordPart && string.lastIndexOf(45) > 0;
        int p2i = string.lastIndexOf(45);
        String p1 = hasRetType && hasDeclType ? string.substring(0, p2i) : string;
        String p2 = string.substring(p1.length());
        StyledString styledString = new StyledString();
        styledString.append(p1);
        if (p2 != null && p2.length() > 0) {
            styledString.append(p2, StyledString.QUALIFIER_STYLER);
        }
        this.fStyledDisplayString = styledString;
    }

    public StyledString getStyledDisplayString() {
        if (this.fStyledDisplayString == null) {
            this.setDisplayString(super.getDisplayString());
        }
        return this.fStyledDisplayString;
    }

    public void setStyledDisplayString(StyledString text) {
        this.fStyledDisplayString = text;
        super.setDisplayString(this.fStyledDisplayString == null ? "" : this.fStyledDisplayString.getString());
    }

    private boolean isTagName(IDocument document, int offset) {
        if (!(document instanceof IStructuredDocument)) {
            return false;
        }
        int lastOffset = offset;
        IStructuredDocumentRegion sdRegion = ((IStructuredDocument)document).getRegionAtCharacterOffset(offset);
        while (sdRegion == null && lastOffset >= 0) {
            sdRegion = ((IStructuredDocument)document).getRegionAtCharacterOffset(--lastOffset);
        }
        ITextRegion region = sdRegion == null ? null : sdRegion.getRegionAtCharacterOffset(offset);
        return "XML_TAG_NAME".equals(region == null ? null : region.getType());
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        String replacementString;
        int fReplacementOffset = this.getReplacementOffset();
        if (offset < fReplacementOffset) {
            return false;
        }
        boolean validated = this.startsWith(document, offset, this.getReplacementString());
        if (!validated && this.isTagName(document, fReplacementOffset) && this.getReplacementString() != null && this.getReplacementString().indexOf(":") != -1) {
            replacementString = this.getReplacementString().substring(this.getReplacementString().indexOf(":") + 1);
            validated = this.startsWith(document, offset, replacementString);
        }
        if (!validated && this.getReplacementString() != null && this.getReplacementString().startsWith("#{")) {
            replacementString = this.getReplacementString().substring(this.getReplacementString().indexOf("#{") + 2);
            validated = this.startsWith(document, offset, replacementString);
        }
        int newLength = offset - this.getReplacementOffset();
        int delta = newLength - this.fOriginalReplacementLength;
        int newReplacementLength = delta + this.fOriginalReplacementLength;
        this.setReplacementLength(newReplacementLength);
        try {
            char firstChar = document.getChar(this.getReplacementOffset());
            if (firstChar == '\"' || firstChar == '\'') {
                this.setReplacementLength(this.getReplacementLength() + 1);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return validated;
    }

    public boolean isAutoInsertable() {
        return false;
    }

    public IInformationControlCreator getInformationControlCreator() {
        final boolean[] browserInformationControlAvailable = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = WebUiPlugin.getActiveWorkbenchShell();
                browserInformationControlAvailable[0] = shell != null && BrowserInformationControl.isAvailable((Composite)shell);
            }
        });
        if (!browserInformationControlAvailable[0]) {
            return null;
        }
        if (this.fCreator == null) {
            ELInfoHover.PresenterControlCreator presenterControlCreator = new ELInfoHover.PresenterControlCreator(WebUiPlugin.getSite());
            this.fCreator = new ELInfoHover.HoverControlCreator((IInformationControlCreator)presenterControlCreator, Messages.additionalInfo_affordance);
        }
        return this.fCreator;
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this.getReplacementString();
    }

    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        return this.getReplacementOffset();
    }

    public String getAdditionalProposalInfo() {
        Object info = this.getAdditionalProposalInfo((IProgressMonitor)new NullProgressMonitor());
        return info == null ? null : info.toString();
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        return ELInfoHover.getHoverInfo((String)super.getAdditionalProposalInfo(), (IProgressMonitor)monitor);
    }

    public void setAlternativeMatches(List<String> list) {
        this.alternativeMatches.addAll(list);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean startsWith(IDocument document, int offset, String word) {
        int wordLength;
        if (super.startsWith(document, offset, word)) {
            return true;
        }
        int n = wordLength = word == null ? 0 : word.length();
        if (offset > this.getReplacementOffset() + wordLength) {
            return false;
        }
        try {
            String alternative;
            int length = offset - this.getReplacementOffset();
            String start = document.get(this.getReplacementOffset(), length);
            Iterator<String> iterator = this.alternativeMatches.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((alternative = iterator.next()) == null || length > alternative.length() || !alternative.substring(0, length).equalsIgnoreCase(start));
            return true;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }
}

