/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.contentassist;

import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.jboss.tools.common.el.core.model.ELInstance;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.model.ELModel;
import org.jboss.tools.common.el.core.model.ELUtil;
import org.jboss.tools.common.el.core.parser.ELParser;
import org.jboss.tools.common.el.core.parser.ELParserUtil;
import org.jboss.tools.common.text.xml.contentassist.ProposalSorter;
import org.jboss.tools.jst.web.ui.internal.editor.contentassist.AutoELContentAssistantProposal;

public class ELPrefixUtils {
    public static final ProposalSorter.IProposalFilter EL_PROPOSAL_FILTER = new ProposalSorter.IProposalFilter(){

        public boolean isValidProposal(CompletionProposalInvocationContext context, ICompletionProposal proposal) {
            ELTextRegion prefix = ELPrefixUtils.getELPrefix(context);
            if (prefix == null || !prefix.isELStarted() || prefix.isInsideELStartToken()) {
                return true;
            }
            return proposal instanceof AutoELContentAssistantProposal;
        }
    };

    public static ELTextRegion getELPrefix(CompletionProposalInvocationContext context) {
        IStructuredDocumentRegion sdRegion = ContentAssistUtils.getStructuredDocumentRegion((ITextViewer)context.getViewer(), (int)context.getInvocationOffset());
        if (sdRegion == null) {
            return null;
        }
        ITextRegion region = sdRegion.getRegionAtCharacterOffset(context.getInvocationOffset());
        if (region == null) {
            return null;
        }
        String text = sdRegion.getFullText(region);
        int startOffset = sdRegion.getStartOffset() + region.getStart();
        boolean isAttributeValue = false;
        boolean hasOpenQuote = false;
        boolean hasCloseQuote = false;
        char quoteChar = '\u0000';
        if ("XML_TAG_ATTRIBUTE_VALUE".equals(region.getType())) {
            isAttributeValue = true;
            if (text.startsWith("\"") || text.startsWith("'")) {
                quoteChar = text.charAt(0);
                hasOpenQuote = true;
            }
            if (hasOpenQuote && text.endsWith(String.valueOf(quoteChar))) {
                hasCloseQuote = true;
            }
        }
        int inValueOffset = context.getInvocationOffset() - startOffset;
        if (text != null && text.length() < inValueOffset) {
            return null;
        }
        if (inValueOffset < 0) {
            return null;
        }
        ELParser p = ELParserUtil.getJbossFactory().createParser();
        ELModel model = p.parse(text);
        ELInstance is = ELUtil.findInstance((ELModel)model, (int)inValueOffset);
        ELInvocationExpression ie = ELUtil.findExpression((ELModel)model, (int)inValueOffset);
        boolean isELStarted = model != null && is != null && (model.toString().startsWith("#{") || model.toString().startsWith("${"));
        boolean isELClosed = model != null && is != null && model.toString().endsWith("}");
        ELTextRegion tr = new ELTextRegion(startOffset, ie == null ? inValueOffset : ie.getStartPosition(), ie == null ? 0 : ie.getLength(), ie == null ? "" : ie.getText(), isELStarted, isELClosed, isAttributeValue, hasOpenQuote, hasCloseQuote, quoteChar);
        return tr;
    }

    public static class ELTextRegion {
        private int startOffset;
        private int offset;
        private int length;
        private String text;
        private boolean isELStarted;
        private boolean isInsideELStartToken;
        private boolean isELClosed;
        private boolean isAttributeValue;
        private boolean hasOpenQuote;
        private boolean hasCloseQuote;
        private char quoteChar;

        public ELTextRegion(int startOffset, int offset, int length, String text, boolean isELStarted, boolean isELClosed) {
            this(startOffset, offset, length, text, isELStarted, isELClosed, false, false, false, '\u0000');
        }

        public ELTextRegion(int startOffset, int offset, int length, String text, boolean isELStarted, boolean isELClosed, boolean isAttributeValue, boolean hasOpenQuote, boolean hasCloseQuote, char quoteChar) {
            this.startOffset = startOffset;
            this.offset = offset;
            this.length = length;
            this.text = text;
            this.isELStarted = isELStarted;
            this.isELClosed = isELClosed;
            this.isAttributeValue = isAttributeValue;
            this.hasOpenQuote = hasOpenQuote;
            this.hasCloseQuote = hasCloseQuote;
            this.quoteChar = quoteChar;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public String getText() {
            StringBuffer sb = new StringBuffer(this.length);
            sb = sb.append(this.text.substring(0, this.length));
            sb.setLength(this.length);
            return sb.toString();
        }

        public boolean isELStarted() {
            return this.isELStarted;
        }

        public boolean isInsideELStartToken() {
            return this.isInsideELStartToken;
        }

        public void setInsideELStartToken(boolean b) {
            this.isInsideELStartToken = b;
        }

        public boolean isELClosed() {
            return this.isELClosed;
        }

        public boolean isAttributeValue() {
            return this.isAttributeValue;
        }

        public char getQuoteChar() {
            return this.quoteChar;
        }

        public boolean hasOpenQuote() {
            return this.hasOpenQuote;
        }

        public boolean hasCloseQuote() {
            return this.hasCloseQuote;
        }
    }
}

