/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.contentassist.computers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.dtd.core.internal.contentmodel.DTDImpl;
import org.eclipse.wst.html.core.internal.contentmodel.HTMLPropertyDeclaration;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.document.TextImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.eclipse.wst.xml.ui.internal.contentassist.XMLContentModelGenerator;
import org.eclipse.wst.xml.ui.internal.editor.XMLEditorPluginImageHelper;
import org.jboss.tools.common.el.core.ELReference;
import org.jboss.tools.common.el.core.model.ELInstance;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.model.ELModel;
import org.jboss.tools.common.el.core.model.ELUtil;
import org.jboss.tools.common.el.core.parser.ELParser;
import org.jboss.tools.common.el.core.parser.ELParserUtil;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.el.core.resolver.ELContextImpl;
import org.jboss.tools.common.el.core.resolver.ELResolver;
import org.jboss.tools.common.el.core.resolver.ELResolverFactoryManager;
import org.jboss.tools.common.el.core.resolver.Var;
import org.jboss.tools.common.text.TextProposal;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.common.ui.CommonUIPlugin;
import org.jboss.tools.jst.web.kb.IKbProject;
import org.jboss.tools.jst.web.kb.IPageContext;
import org.jboss.tools.jst.web.kb.IResourceBundle;
import org.jboss.tools.jst.web.kb.KbProjectFactory;
import org.jboss.tools.jst.web.kb.KbQuery;
import org.jboss.tools.jst.web.kb.PageContextFactory;
import org.jboss.tools.jst.web.kb.PageProcessor;
import org.jboss.tools.jst.web.kb.internal.taglib.NameSpace;
import org.jboss.tools.jst.web.kb.internal.taglib.TLDLibrary;
import org.jboss.tools.jst.web.kb.taglib.INameSpace;
import org.jboss.tools.jst.web.kb.taglib.INameSpaceExtended;
import org.jboss.tools.jst.web.kb.taglib.INameSpaceStorage;
import org.jboss.tools.jst.web.kb.taglib.ITagLibrary;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.editor.contentassist.AutoContentAssistantProposal;
import org.jboss.tools.jst.web.ui.internal.editor.contentassist.ELPrefixUtils;
import org.jboss.tools.jst.web.ui.internal.editor.contentassist.computers.AbstractXmlCompletionProposalComputer;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd.PaletteTaglibInserter;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XmlTagCompletionProposalComputer
extends AbstractXmlCompletionProposalComputer {
    public static final String HTML_TAGNAME = "html";
    public static final String XMLNS_ATTRIBUTE_NAME_PREFIX = "xmlns:";
    public static final String EMPTY_ATTRIBUTE_VALUE = "=\"\"";
    private static final String XMLNS_ATTRIBUTE_NAME = "xmlns";
    private static final String XMLNS_ATTRIBUTE_VALUE = "http://www.w3.org/1999/xhtml";
    protected static final ICompletionProposal[] EMPTY_PROPOSAL_LIST = new ICompletionProposal[0];

    protected XMLContentModelGenerator getContentGenerator() {
        return new ELXMLContentModelGenerator();
    }

    protected boolean validModelQueryNode(CMNode node) {
        boolean isValid = false;
        if (node instanceof DTDImpl.DTDElementReferenceContentAdapter) {
            DTDImpl.DTDElementReferenceContentAdapter content = (DTDImpl.DTDElementReferenceContentAdapter)node;
            if (content.getCMDocument() instanceof DTDImpl.DTDBaseAdapter) {
                DTDImpl.DTDBaseAdapter dtd = (DTDImpl.DTDBaseAdapter)content.getCMDocument();
                String spec = dtd.getSpec();
                isValid = spec.indexOf(HTML_TAGNAME) != -1;
            }
        } else if (node instanceof HTMLPropertyDeclaration) {
            HTMLPropertyDeclaration propDec = (HTMLPropertyDeclaration)node;
            isValid = !propDec.isJSP();
        } else if (node instanceof CMAttributeDeclaration) {
            isValid = true;
        }
        return isValid;
    }

    @Override
    protected void addTagInsertionProposals(ContentAssistRequest contentAssistRequest, int childPosition, CompletionProposalInvocationContext context) {
        ELPrefixUtils.ELTextRegion prefix = this.getELPrefix(contentAssistRequest);
        if (prefix != null && prefix.isELStarted()) {
            return;
        }
        this.addTagNameProposals(contentAssistRequest, childPosition, true, context);
    }

    protected void addAttributeNameProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        if (!(contentAssistRequest.getNode() instanceof Element)) {
            return;
        }
        String matchString = contentAssistRequest.getMatchString();
        String query = matchString;
        if (query == null) {
            query = "";
        }
        String stringQuery = matchString;
        KbQuery kbQuery = this.createKbQuery(KbQuery.Type.ATTRIBUTE_NAME, query, stringQuery);
        TextProposal[] proposals = PageProcessor.getInstance().getProposals(kbQuery, this.getContext());
        int i = 0;
        while (proposals != null && i < proposals.length) {
            TextProposal textProposal = proposals[i];
            if (!this.isExistingAttribute(textProposal.getLabel())) {
                String replacementString = String.valueOf(textProposal.getReplacementString()) + EMPTY_ATTRIBUTE_VALUE;
                int replacementOffset = contentAssistRequest.getReplacementBeginPosition();
                int replacementLength = contentAssistRequest.getReplacementLength();
                int cursorPosition = XmlTagCompletionProposalComputer.getCursorPositionForProposedText(replacementString);
                Image image = CommonUIPlugin.getImageDescriptorRegistry().get(textProposal.getImageDescriptor());
                if (textProposal.getImageDescriptor() == null) {
                    image = XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/attribute_obj.gif");
                }
                String displayString = textProposal.getLabel() == null ? replacementString : textProposal.getLabel();
                IContextInformation contextInformation = null;
                String additionalProposalInfo = textProposal.getContextInfo();
                int relevance = textProposal.getRelevance();
                AutoContentAssistantProposal proposal = new AutoContentAssistantProposal(textProposal, true, replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, relevance);
                contentAssistRequest.addProposal((ICompletionProposal)proposal);
            }
            ++i;
        }
        this.addXmlnsPrefixProposals(contentAssistRequest, context);
    }

    protected void addXmlnsPrefixProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        String matchString;
        if (!(this.fContext instanceof IPageContext)) {
            return;
        }
        if (!(contentAssistRequest.getNode() instanceof Element)) {
            return;
        }
        String attrName = matchString = contentAssistRequest.getMatchString();
        String prefixBeginning = "";
        if (attrName.startsWith(XMLNS_ATTRIBUTE_NAME_PREFIX)) {
            prefixBeginning = attrName.substring(XMLNS_ATTRIBUTE_NAME_PREFIX.length());
        } else if (XMLNS_ATTRIBUTE_NAME_PREFIX.startsWith(attrName)) {
            prefixBeginning = "";
        }
        if (!this.isExistingAttribute(XMLNS_ATTRIBUTE_NAME, XMLNS_ATTRIBUTE_VALUE) && !attrName.startsWith(XMLNS_ATTRIBUTE_NAME_PREFIX)) {
            return;
        }
        IFile file = PageContextFactory.getResource((IDocument)context.getDocument());
        if (file != null && file.getProject() != null) {
            Collection<INameSpace> namespaces = this.getPossibleNamespacesForPrefix(file.getProject(), prefixBeginning, false, ((IPageContext)this.fContext).getNameSpaces(context.getInvocationOffset()));
            for (INameSpace ns : namespaces) {
                String replacementString = XMLNS_ATTRIBUTE_NAME_PREFIX + ns.getPrefix() + "=\"" + ns.getURI() + "\"";
                int replacementOffset = contentAssistRequest.getReplacementBeginPosition();
                int replacementLength = contentAssistRequest.getReplacementLength();
                int cursorPosition = XmlTagCompletionProposalComputer.getCursorPositionForProposedText(replacementString);
                Image image = XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/attribute_obj.gif");
                String displayString = replacementString;
                IContextInformation contextInformation = null;
                int relevance = 850;
                AutoContentAssistantProposal proposal = new AutoContentAssistantProposal(null, true, replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, null, relevance);
                contentAssistRequest.addProposal((ICompletionProposal)proposal);
            }
        }
    }

    protected void addXmlnsUriProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        if (!(this.fContext instanceof IPageContext)) {
            return;
        }
        if (!(contentAssistRequest.getNode() instanceof Element)) {
            return;
        }
        String prefix = this.getParent(true, true);
        if (prefix == null || !prefix.startsWith(XMLNS_ATTRIBUTE_NAME_PREFIX)) {
            return;
        }
        prefix = prefix.substring(XMLNS_ATTRIBUTE_NAME_PREFIX.length());
        String matchString = contentAssistRequest.getMatchString();
        IFile file = PageContextFactory.getResource((IDocument)context.getDocument());
        if (file != null && file.getProject() != null) {
            Collection<INameSpace> namespaces = this.getPossibleNamespacesForPrefix(file.getProject(), prefix, true, ((IPageContext)this.fContext).getNameSpaces(context.getInvocationOffset()));
            for (INameSpace ns : namespaces) {
                String replacementString = "\"" + ns.getURI() + "\"";
                int replacementOffset = contentAssistRequest.getReplacementBeginPosition();
                int replacementLength = this.getCheckedAttributeValueReplacementLength(replacementOffset, contentAssistRequest.getReplacementLength());
                int cursorPosition = XmlTagCompletionProposalComputer.getCursorPositionForProposedText(replacementString);
                Image image = XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/attribute_obj.gif");
                String displayString = replacementString;
                IContextInformation contextInformation = null;
                int relevance = 950;
                AutoContentAssistantProposal proposal = new AutoContentAssistantProposal(null, true, replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, null, relevance);
                contentAssistRequest.addProposal((ICompletionProposal)proposal);
            }
        }
    }

    private int getCheckedAttributeValueReplacementLength(int offset, int length) {
        String existingValue;
        block9: {
            char quote;
            block8: {
                try {
                    existingValue = this.fCurrentContext.getViewer().getDocument().get(offset, length);
                    if (existingValue.indexOf(10) != -1) {
                        existingValue = existingValue.substring(0, existingValue.indexOf(10));
                    }
                    if (existingValue.indexOf(13) != -1) {
                        existingValue = existingValue.substring(0, existingValue.indexOf(13));
                    }
                    while (existingValue.length() > 0 && Character.isWhitespace(existingValue.charAt(existingValue.length() - 1))) {
                        existingValue = existingValue.substring(0, existingValue.length() - 1);
                    }
                    quote = '\u0000';
                    if (existingValue.charAt(0) == '\"' || existingValue.charAt(0) == '\'') {
                        quote = existingValue.charAt(0);
                    }
                    if (quote != '\u0000') break block8;
                    return 0;
                }
                catch (BadLocationException e) {
                    WebUiPlugin.getPluginLog().logError((Throwable)e);
                    return length;
                }
            }
            if (quote == existingValue.charAt(existingValue.length() - 1)) break block9;
            return 1;
        }
        return existingValue.length();
    }

    private Map<String, TreeSet<String>> getProjectDefinedAndCustomNamespaces(IKbProject kbProject, String prefixBeginning, boolean strictPrefix) {
        HashMap<String, TreeSet<String>> result = new HashMap<String, TreeSet<String>>();
        INameSpaceStorage nsStorage = kbProject.getNameSpaceStorage();
        Set prefixes = nsStorage.getPrefixes(prefixBeginning);
        for (String prefix : prefixes) {
            TreeSet sortedUris;
            Set prefixUris;
            if (strictPrefix && !prefix.equalsIgnoreCase(prefixBeginning) || (prefixUris = nsStorage.getURIs(prefix)).isEmpty()) continue;
            if (!result.containsKey(prefix)) {
                sortedUris = new TreeSet(String.CASE_INSENSITIVE_ORDER);
                sortedUris.addAll(prefixUris);
                result.put(prefix, sortedUris);
                continue;
            }
            sortedUris = (TreeSet)result.get(prefix);
            for (String uri : prefixUris) {
                if (sortedUris.contains(uri)) continue;
                sortedUris.add(uri);
            }
        }
        return result;
    }

    private Collection<INameSpace> getPossibleNamespacesForPrefix(IProject project, String prefixBeginning, boolean strictPrefix, Map<String, List<INameSpace>> existingNamespaces) {
        ArrayList<INameSpace> namespaces = new ArrayList<INameSpace>();
        IKbProject kbProject = KbProjectFactory.getKbProject((IProject)project, (boolean)true);
        if (kbProject == null) {
            return namespaces;
        }
        prefixBeginning = prefixBeginning == null ? "" : prefixBeginning;
        Map<String, TreeSet<String>> prefix2uris = this.getProjectDefinedAndCustomNamespaces(kbProject, prefixBeginning, strictPrefix);
        List libraries = kbProject.getAllTagLibraries();
        for (ITagLibrary l : libraries) {
            TreeSet<Object> sortedUris;
            INameSpace ns;
            if (l instanceof TLDLibrary) {
                ((TLDLibrary)l).createDefaultNameSpace();
            }
            if ((ns = l.getDefaultNameSpace()) == null || ns.getPrefix() == null || (!strictPrefix || !ns.getPrefix().equals(prefixBeginning)) && (strictPrefix || !ns.getPrefix().startsWith(prefixBeginning) || this.isExistingNamespace(ns, existingNamespaces))) continue;
            String prefix = ns.getPrefix();
            String uri = ns.getURI();
            if (!prefix2uris.containsKey(prefix)) {
                sortedUris = new TreeSet(String.CASE_INSENSITIVE_ORDER);
                sortedUris.add(uri);
                prefix2uris.put(prefix, sortedUris);
                continue;
            }
            sortedUris = prefix2uris.get(prefix);
            if (sortedUris.contains(uri)) continue;
            sortedUris.add(uri);
        }
        TreeSet<String> prefixes = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        prefixes.addAll(prefix2uris.keySet());
        for (String prefix : prefixes) {
            Set uris = prefix2uris.get(prefix);
            for (String uri : uris) {
                ITagLibrary[] libs = kbProject.getTagLibraries(uri);
                if (libs == null || libs.length == 0) {
                    namespaces.add((INameSpace)new NameSpace(uri, prefix));
                    continue;
                }
                namespaces.add((INameSpace)new NameSpace(uri, prefix, libs));
            }
        }
        return namespaces;
    }

    private boolean isExistingNamespace(INameSpace ns, Map<String, List<INameSpace>> existingNamespaces) {
        if (existingNamespaces == null) {
            return false;
        }
        List<INameSpace> namespaces = existingNamespaces.get(ns.getURI());
        if (namespaces == null) {
            return false;
        }
        for (INameSpace existingNS : namespaces) {
            if (!ns.getPrefix().equalsIgnoreCase(existingNS.getPrefix())) continue;
            return true;
        }
        return false;
    }

    protected String getMatchString(IStructuredDocumentRegion parent, ITextRegion aRegion, int offset) {
        if (aRegion == null || this.isCloseRegion(aRegion)) {
            return "";
        }
        String matchString = null;
        String regionType = aRegion.getType();
        matchString = regionType == "XML_TAG_ATTRIBUTE_EQUALS" || regionType == "XML_TAG_OPEN" || offset > parent.getStartOffset(aRegion) + aRegion.getTextLength() ? "" : (regionType == "XML_CONTENT" ? "" : (parent.getText(aRegion).length() > 0 && parent.getStartOffset(aRegion) < offset ? parent.getText(aRegion).substring(0, offset - parent.getStartOffset(aRegion)) : ""));
        if (regionType == "XML_TAG_ATTRIBUTE_VALUE" && matchString.startsWith("\"")) {
            matchString = matchString.substring(1);
        }
        return matchString;
    }

    protected boolean isCloseRegion(ITextRegion region) {
        String type = region.getType();
        return type == "XML_PI_CLOSE" || type == "XML_TAG_CLOSE" || type == "XML_EMPTY_TAG_CLOSE" || type == "XML_CDATA_CLOSE" || type == "XML_COMMENT_CLOSE" || type == "XML_ATTLIST_DECL_CLOSE" || type == "XML_ELEMENT_DECL_CLOSE" || type == "XML_DOCTYPE_DECLARATION_CLOSE" || type == "JSP_CLOSE" || type == "JSP_COMMENT_CLOSE" || type.equals("JSP_DIRECTIVE_CLOSE") || type == "XML_DECLARATION_CLOSE";
    }

    protected boolean isExistingAttribute(String attrName) {
        return this.isExistingAttribute(attrName, null);
    }

    protected boolean isExistingAttribute(String attrName, String value) {
        IStructuredModel sModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.getDocument());
        try {
            IDOMDocument xmlDocument;
            if (sModel == null) {
                return false;
            }
            IDOMDocument iDOMDocument = xmlDocument = sModel instanceof IDOMModel ? ((IDOMModel)sModel).getDocument() : null;
            if (xmlDocument == null) {
                return false;
            }
            IStructuredDocumentRegion sdFixedRegion = this.getStructuredDocumentRegion(this.getOffset());
            if (sdFixedRegion == null) {
                return false;
            }
            Node n = this.findNodeForOffset((Node)xmlDocument, sdFixedRegion.getStartOffset());
            if (n == null) {
                return false;
            }
            if (!(n instanceof Element)) {
                if (n instanceof Attr) {
                    n = ((Attr)n).getOwnerElement();
                } else {
                    return false;
                }
            }
            if (n == null) {
                return false;
            }
            Attr a = ((Element)n).getAttributeNode(attrName);
            if (a == null) {
                return false;
            }
            if (value == null) {
                return true;
            }
            String v = Utils.trimQuotes((String)a.getNodeValue());
            boolean bl = v != null && v.equalsIgnoreCase(Utils.trimQuotes((String)value));
            return bl;
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
    }

    @Override
    protected void addAttributeValueProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        this.fCurrentContext = context;
        ELPrefixUtils.ELTextRegion prefix = this.getELPrefix(contentAssistRequest);
        if (prefix != null && prefix.isELStarted()) {
            return;
        }
        String matchString = contentAssistRequest.getMatchString();
        String query = Utils.trimQuotes((String)matchString);
        if (query == null) {
            query = "";
        }
        String stringQuery = matchString;
        KbQuery kbQuery = this.createKbQuery(KbQuery.Type.ATTRIBUTE_VALUE, query, stringQuery);
        String text = contentAssistRequest.getDocumentRegion().getFullText(contentAssistRequest.getRegion());
        String sufix = null;
        sufix = text.length() > matchString.length() ? Utils.trimQuotes((String)text.substring(matchString.length())) : "";
        kbQuery.setRegionValueSufix(sufix);
        TextProposal[] proposals = PageProcessor.getInstance().getProposals(kbQuery, this.getContext());
        int i = 0;
        while (proposals != null && i < proposals.length) {
            TextProposal textProposal = proposals[i];
            int replacementOffset = contentAssistRequest.getReplacementBeginPosition();
            int replacementLength = this.getCheckedAttributeValueReplacementLength(replacementOffset, contentAssistRequest.getReplacementLength());
            if (textProposal.getStart() >= 0 && textProposal.getEnd() >= 0) {
                replacementOffset += textProposal.getStart() + 1;
                replacementLength = textProposal.getEnd() - textProposal.getStart();
            }
            String replacementString = "\"" + textProposal.getReplacementString() + "\"";
            String alternativeMatch = textProposal.getAlternateMatch();
            if (alternativeMatch != null) {
                alternativeMatch = "\"" + textProposal.getAlternateMatch() + "\"";
            }
            if (textProposal.getStart() >= 0 && textProposal.getEnd() >= 0) {
                replacementString = textProposal.getReplacementString();
                alternativeMatch = textProposal.getAlternateMatch();
            }
            int cursorPosition = XmlTagCompletionProposalComputer.getCursorPositionForProposedText(replacementString);
            Image image = CommonUIPlugin.getImageDescriptorRegistry().get(textProposal.getImageDescriptor());
            String displayString = textProposal.getLabel() == null ? replacementString : textProposal.getLabel();
            IContextInformation contextInformation = null;
            String additionalProposalInfo = textProposal.getContextInfo();
            int relevance = textProposal.getRelevance();
            if (relevance == 0) {
                relevance = 830;
            }
            AutoContentAssistantProposal proposal = new AutoContentAssistantProposal(textProposal, replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, alternativeMatch, contextInformation, additionalProposalInfo, relevance);
            contentAssistRequest.addProposal((ICompletionProposal)proposal);
            ++i;
        }
        this.addXmlnsUriProposals(contentAssistRequest, context);
    }

    @Override
    protected void addTagNameProposals(ContentAssistRequest contentAssistRequest, int childPosition, CompletionProposalInvocationContext context) {
        this.addTagNameProposals(contentAssistRequest, childPosition, false, context);
    }

    protected void addTagNameProposals(ContentAssistRequest contentAssistRequest, int childPosition, boolean insertTagOpenningCharacter, CompletionProposalInvocationContext context) {
        block12: {
            String query;
            block11: {
                String mainPrefix = this.getTagPrefix();
                String mainURI = this.getTagUri();
                String matchString = contentAssistRequest.getMatchString();
                IStructuredDocumentRegion sdRegion = this.getStructuredDocumentRegion(this.getOffset());
                ITextRegion completionRegion = this.getCompletionRegion(this.getOffset(), contentAssistRequest.getNode());
                query = matchString = this.getMatchString(sdRegion, completionRegion, this.getOffset());
                this.addTagNameProposalsForPrefix(contentAssistRequest, childPosition, query, mainPrefix, mainURI, 1210, insertTagOpenningCharacter);
                if (query == null || query.length() == 0) {
                    return;
                }
                if (query.indexOf(58) == -1) break block11;
                String prefix = query.indexOf(58) != -1 ? query.substring(0, query.indexOf(58)) : query;
                IFile file = PageContextFactory.getResource((IDocument)context.getDocument());
                if (file == null || file.getProject() == null) break block12;
                Collection<Object> namespaces = new ArrayList();
                Map existing = ((IPageContext)this.fContext).getNameSpaces(context.getInvocationOffset());
                for (String uri : existing.keySet()) {
                    List list = (List)existing.get(uri);
                    for (INameSpace n : list) {
                        if (!prefix.equals(n.getPrefix())) continue;
                        namespaces.add(n);
                    }
                }
                if (namespaces.isEmpty()) {
                    namespaces = this.getPossibleNamespacesForPrefix(file.getProject(), prefix, query.indexOf(58) != -1, existing);
                }
                HashMap<String, List<INameSpace>> nsMap = new HashMap<String, List<INameSpace>>();
                for (INameSpace iNameSpace : namespaces) {
                    List<Object> uNamespaces = (List)nsMap.get(iNameSpace.getURI());
                    if (uNamespaces == null) {
                        uNamespaces = new ArrayList<INameSpace>(1);
                        nsMap.put(iNameSpace.getURI(), uNamespaces);
                    }
                    uNamespaces.add(iNameSpace);
                }
                IPageContext iPageContext = this.createFakePageContext(nsMap, context.getDocument(), file);
                for (INameSpace iNameSpace : namespaces) {
                    String possibleURI;
                    String possiblePrefix = iNameSpace.getPrefix();
                    if (possiblePrefix == null || possiblePrefix.length() == 0 || (possibleURI = iNameSpace.getURI()) == null || possibleURI.length() == 0) continue;
                    this.addTagNameProposalsForPrefix(contentAssistRequest, (ELContext)iPageContext, childPosition, query, possiblePrefix, possibleURI, 1209, insertTagOpenningCharacter);
                }
                break block12;
            }
            ELContext elContext = this.getContext();
            if (elContext instanceof IPageContext) {
                IPageContext pageContext = (IPageContext)elContext;
                Map nsMap = pageContext.getNameSpaces(contentAssistRequest.getReplacementBeginPosition());
                if (nsMap == null) {
                    return;
                }
                for (List namespaces : nsMap.values()) {
                    if (namespaces == null) continue;
                    for (INameSpace iNameSpace : namespaces) {
                        String possibleURI;
                        String possiblePrefix = iNameSpace.getPrefix();
                        if (possiblePrefix == null || possiblePrefix.length() == 0 || (possibleURI = iNameSpace.getURI()) == null || possibleURI.length() == 0) continue;
                        this.addTagNameProposalsForPrefix(contentAssistRequest, childPosition, query, possiblePrefix, possibleURI, 1209, insertTagOpenningCharacter);
                    }
                }
            }
        }
    }

    private IPageContext createFakePageContext(Map<String, List<INameSpace>> namespaces, IDocument document, IFile file) {
        return new FakePageContext(namespaces, document, file);
    }

    private void addTagNameProposalsForPrefix(ContentAssistRequest contentAssistRequest, int childPosition, String query, String prefix, String uri, int defaultRelevance, boolean insertTagOpenningCharacter) {
        this.addTagNameProposalsForPrefix(contentAssistRequest, this.getContext(), childPosition, query, prefix, uri, defaultRelevance, insertTagOpenningCharacter);
    }

    private void addTagNameProposalsForPrefix(ContentAssistRequest contentAssistRequest, ELContext context, int childPosition, String query, String prefix, String uri, int defaultRelevance, boolean insertTagOpenningCharacter) {
        ITextRegion region;
        if (query == null) {
            query = "";
        }
        String template = this.getTemplate(contentAssistRequest, query);
        StringBuilder stringQuery = new StringBuilder();
        if (query.indexOf(58) == -1 && prefix != null && prefix.length() > 0) {
            stringQuery.append(prefix).append(':');
        }
        stringQuery.append(query);
        KbQuery kbQuery = this.createKbQuery(KbQuery.Type.TAG_NAME, stringQuery.toString(), String.valueOf('<') + stringQuery.toString(), prefix, uri);
        IStructuredDocumentRegion docRegion = contentAssistRequest.getDocumentRegion();
        if (docRegion != null && (region = contentAssistRequest.getRegion()) != null && "XML_CONTENT".equals(region.getType())) {
            int offset = this.fCurrentContext.getInvocationOffset();
            if (docRegion.getText(region).length() > 0 && docRegion.getStartOffset(region) < offset) {
                int offsetValue = offset - docRegion.getStartOffset(region);
                String prefixValue = docRegion.getText(region).substring(0, offsetValue);
                String sufixValue = docRegion.getText(region).substring(offsetValue);
                kbQuery.setRegionValuePrefix(prefixValue);
                kbQuery.setRegionValueSufix(sufixValue);
            }
        }
        TextProposal[] proposals = PageProcessor.getInstance().getProposals(kbQuery, context, true);
        ELContext originalContext = this.createContext();
        Map namespaces = null;
        IPageContext pageContext = null;
        if (originalContext instanceof IPageContext) {
            pageContext = (IPageContext)originalContext;
            namespaces = pageContext.getNameSpaces(this.getOffset());
        }
        int i = 0;
        while (proposals != null && i < proposals.length) {
            TextProposal textProposal = proposals[i];
            boolean useAutoActivation = true;
            String replacementString = textProposal.getReplacementString();
            String closingTag = textProposal.getLabel();
            if (closingTag != null && closingTag.startsWith("<")) {
                closingTag = closingTag.substring(1);
            }
            int replacementOffset = this.getOffset() - query.length() - (insertTagOpenningCharacter ? 0 : 1);
            int replacementLength = query.length() + (insertTagOpenningCharacter ? 0 : 1);
            if (!insertTagOpenningCharacter && replacementString.startsWith("<")) {
                String replacementTagName = this.extractTagName(replacementString.substring(1));
                int start = this.getStartOfTagName();
                int end = this.getEndOfTagName();
                if (this.getDocumentText(this.getDocument(), start, end).equalsIgnoreCase(this.extractTagName(replacementString))) {
                    replacementString = String.valueOf('<') + replacementTagName;
                    replacementLength += end - this.getOffset();
                } else if (!replacementString.endsWith("/>")) {
                    replacementString = String.valueOf(replacementString) + "</" + closingTag + ">";
                    useAutoActivation = false;
                }
            }
            int cursorPosition = XmlTagCompletionProposalComputer.getCursorPositionForProposedText(replacementString);
            Image image = CommonUIPlugin.getImageDescriptorRegistry().get(textProposal.getImageDescriptor());
            if (textProposal.getImageDescriptor() == null) {
                image = XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/tag-generic.gif");
            }
            String displayString = closingTag;
            IContextInformation contextInformation = null;
            String additionalProposalInfo = textProposal.getContextInfo();
            int relevance = textProposal.getRelevance();
            if (relevance == 0) {
                int n = relevance = defaultRelevance == 0 ? 1210 : defaultRelevance;
            }
            if (template.length() > 0 && textProposal.isAlternativeMatchStart(template)) {
                relevance = 1250;
                replacementOffset -= template.length();
                replacementLength += template.length();
            }
            NameSpaceInserter nameSpaceInserter = namespaces != null && !this.isExistingNameSpace(namespaces, prefix, uri) ? new NameSpaceInserter(this.fCurrentContext.getViewer(), prefix, uri) : null;
            AutoContentAssistantProposal proposal = new AutoContentAssistantProposal(textProposal, useAutoActivation, replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, relevance, nameSpaceInserter);
            proposal.setAlternativeMatches(textProposal.getAlternativeMatches());
            contentAssistRequest.addProposal((ICompletionProposal)proposal);
            ++i;
        }
    }

    private String getTemplate(ContentAssistRequest contentAssistRequest, String query) {
        String template = "";
        TextImpl textNode = null;
        if (query.length() == 0 && contentAssistRequest.getNode() instanceof Text) {
            textNode = (TextImpl)contentAssistRequest.getNode();
        } else if (query.length() == 0 && contentAssistRequest.getNode() instanceof IDOMElement && (((IDOMElement)contentAssistRequest.getNode()).getStartOffset() == this.getOffset() || ((IDOMElement)contentAssistRequest.getNode()).getEndStartOffset() == this.getOffset()) && this.getOffset() > 0 && ((IDOMElement)contentAssistRequest.getNode()).getModel().getIndexedRegion(this.getOffset() - 1) instanceof Text) {
            textNode = (TextImpl)((IDOMElement)contentAssistRequest.getNode()).getModel().getIndexedRegion(this.getOffset() - 1);
        } else if (query.length() == 0 && contentAssistRequest.getNode() instanceof Comment && this.getOffset() > 0 && ((IDOMNode)contentAssistRequest.getNode()).getModel().getIndexedRegion(this.getOffset() - 1) instanceof Text) {
            textNode = (TextImpl)((IDOMElement)contentAssistRequest.getNode()).getModel().getIndexedRegion(this.getOffset() - 1);
        }
        if (textNode != null) {
            String text = textNode.getTextContent();
            int start = textNode.getStartOffset();
            if (start < this.getOffset()) {
                int i = this.getOffset() - 1;
                while (i >= start) {
                    if (!Character.isLetter(text.charAt(i - start))) break;
                    template = text.charAt(i - start) + template;
                    --i;
                }
            }
        }
        return template;
    }

    boolean isExistingNameSpace(Map<String, List<INameSpace>> namespaces, String prefix, String uri) {
        if (namespaces == null || prefix == null || uri == null) {
            return false;
        }
        List<INameSpace> uriNamespaces = namespaces.get(uri);
        if (uriNamespaces == null) {
            return false;
        }
        for (INameSpace namespace : uriNamespaces) {
            if (!prefix.equals(namespace.getPrefix()) || !uri.equals(namespace.getURI())) continue;
            return true;
        }
        return false;
    }

    private String getDocumentText(IDocument document, int start, int end) {
        try {
            return document.get(start, end - start);
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    private int getStartOfTagName() {
        try {
            int start = this.getOffset();
            while (start > 0 && (Character.isJavaIdentifierPart(this.getDocument().getChar(start - 1)) || ':' == this.getDocument().getChar(start - 1))) {
                --start;
            }
            return start;
        }
        catch (BadLocationException e) {
            return -1;
        }
    }

    private int getEndOfTagName() {
        try {
            int end = this.getOffset();
            while (end < this.getDocument().getLength() && (Character.isJavaIdentifierPart(this.getDocument().getChar(end)) || ':' == this.getDocument().getChar(end))) {
                ++end;
            }
            return end;
        }
        catch (BadLocationException e) {
            return -1;
        }
    }

    private String extractTagName(String tag) {
        int start;
        int offset = start = tag.startsWith("<") ? 1 : 0;
        while (offset < tag.length() && !Character.isWhitespace(tag.charAt(offset)) && '>' != tag.charAt(offset) && '<' != tag.charAt(offset)) {
            ++offset;
        }
        return tag.substring(start, offset);
    }

    @Override
    protected void addAttributeValueELProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
    }

    @Override
    protected void addTextELProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
    }

    @Override
    protected ELContext createContext() {
        return this.createContext("XML_PAGE_CONTEXT_TYPE");
    }

    @Override
    protected KbQuery createKbQuery(KbQuery.Type type, String query, String stringQuery) {
        return this.createKbQuery(type, query, stringQuery, this.getTagPrefix(), this.getTagUri());
    }

    @Override
    protected KbQuery createKbQuery(KbQuery.Type type, String query, String stringQuery, String prefix, String uri) {
        KbQuery kbQuery = new KbQuery();
        KbQuery.Tag[] parentTags = this.getParentTagsWithAttributes(type == KbQuery.Type.ATTRIBUTE_NAME || type == KbQuery.Type.ATTRIBUTE_VALUE || type == KbQuery.Type.TAG_BODY);
        String parent = this.getParent(type == KbQuery.Type.ATTRIBUTE_VALUE, type == KbQuery.Type.ATTRIBUTE_NAME || type == KbQuery.Type.TAG_BODY);
        String queryValue = query;
        String queryStringValue = stringQuery;
        kbQuery.setPrefix(prefix);
        kbQuery.setUri(uri);
        kbQuery.setParentTagsWithAttributes(parentTags);
        kbQuery.setParent(parent);
        kbQuery.setMask(true);
        kbQuery.setType(type);
        kbQuery.setOffset(this.fCurrentContext.getInvocationOffset());
        kbQuery.setValue(queryValue);
        kbQuery.setStringQuery(queryStringValue);
        kbQuery.setAttributes(this.getAttributes());
        return kbQuery;
    }

    protected static int getCursorPositionForProposedText(String proposedText) {
        int cursorAdjustment = proposedText.indexOf("\"\"") + 1;
        if (cursorAdjustment == 0) {
            cursorAdjustment = proposedText.indexOf(62) + 1;
        }
        if (cursorAdjustment == 0) {
            cursorAdjustment = proposedText.lastIndexOf("{}") + 1;
        }
        if (cursorAdjustment == 0) {
            cursorAdjustment = proposedText.length();
        }
        return cursorAdjustment;
    }

    protected ELResolver[] getELResolvers(IResource resource) {
        if (resource == null) {
            return null;
        }
        ELResolverFactoryManager elrfm = ELResolverFactoryManager.getInstance();
        return elrfm.getResolvers(resource);
    }

    @Override
    public String getTagUri() {
        String nodePrefix = this.getTagPrefix();
        return this.getUri(nodePrefix);
    }

    @Override
    protected String getUri(String prefix) {
        return null;
    }

    protected ELPrefixUtils.ELTextRegion getELPrefix(ContentAssistRequest request) {
        boolean isELStarted;
        if (!("XML_TAG_ATTRIBUTE_VALUE".equals(request.getRegion().getType()) || "XML_CONTENT".equals(request.getRegion().getType()) || "BLOCK_TEXT".equals(request.getRegion().getType()))) {
            return null;
        }
        String text = request.getDocumentRegion().getFullText(request.getRegion());
        int startOffset = request.getDocumentRegion().getStartOffset() + request.getRegion().getStart();
        boolean isAttributeValue = false;
        boolean hasOpenQuote = false;
        boolean hasCloseQuote = false;
        char quoteChar = '\u0000';
        if ("XML_TAG_ATTRIBUTE_VALUE".equals(request.getRegion().getType())) {
            isAttributeValue = true;
            if (text.startsWith("\"") || text.startsWith("'")) {
                quoteChar = text.charAt(0);
                hasOpenQuote = true;
            }
            if (hasOpenQuote && text.trim().endsWith(String.valueOf(quoteChar))) {
                hasCloseQuote = true;
            }
        }
        int inValueOffset = this.getOffset() - startOffset;
        if (text != null && text.length() < inValueOffset) {
            return null;
        }
        if (inValueOffset < 0) {
            return null;
        }
        ELParser p = ELParserUtil.getJbossFactory().createParser();
        ELModel model = p.parse(text);
        ELInstance is = ELUtil.findInstance((ELModel)model, (int)inValueOffset);
        ELInvocationExpression ie = ELUtil.findExpression((ELModel)model, (int)inValueOffset);
        boolean bl = model != null && is != null && this.startsWithELBeginning(is.getFirstToken() == null ? null : is.getFirstToken().getText()) ? true : (isELStarted = false);
        boolean isELClosed = model != null && is != null && this.endsWithELBeginning(is.getFirstToken() == null ? null : is.getLastToken().getText());
        ELPrefixUtils.ELTextRegion tr = new ELPrefixUtils.ELTextRegion(startOffset, ie == null ? inValueOffset : ie.getStartPosition(), ie == null ? 0 : inValueOffset - ie.getStartPosition(), ie == null ? "" : ie.getText(), isELStarted, isELClosed, isAttributeValue, hasOpenQuote, hasCloseQuote, quoteChar);
        return tr;
    }

    protected ELPrefixUtils.ELTextRegion getELPredicatePrefix(ContentAssistRequest request) {
        int inValueOffset;
        if (request == null || request.getRegion() == null) {
            return null;
        }
        IStructuredDocumentRegion documentRegion = request.getDocumentRegion();
        ITextRegion completionRegion = request.getRegion();
        String regionType = completionRegion.getType();
        if ("XML_END_TAG_OPEN".equals(regionType) || "XML_TAG_OPEN".equals(regionType)) {
            documentRegion = documentRegion.getPrevious();
            completionRegion = this.getCompletionRegion(request.getDocumentRegion().getStartOffset() + request.getRegion().getStart() - 1, request.getParent());
        }
        if (documentRegion == null || completionRegion == null) {
            return null;
        }
        if (!("XML_TAG_ATTRIBUTE_VALUE".equals(completionRegion.getType()) || "XML_CONTENT".equals(completionRegion.getType()) || "BLOCK_TEXT".equals(completionRegion.getType()))) {
            return null;
        }
        String text = documentRegion.getFullText(completionRegion);
        int startOffset = documentRegion.getStartOffset() + completionRegion.getStart();
        boolean isAttributeValue = false;
        boolean hasOpenQuote = false;
        boolean hasCloseQuote = false;
        char quoteChar = '\u0000';
        if ("XML_TAG_ATTRIBUTE_VALUE".equals(request.getRegion().getType())) {
            isAttributeValue = true;
            if (text.startsWith("\"") || text.startsWith("'")) {
                quoteChar = text.charAt(0);
                hasOpenQuote = true;
            }
            if (hasOpenQuote && text.trim().endsWith(String.valueOf(quoteChar))) {
                hasCloseQuote = true;
            }
        }
        if ((inValueOffset = this.getOffset() - startOffset) < 0 || text != null && text.length() < inValueOffset) {
            return null;
        }
        String matchString = this.getELPredicateMatchString(text, inValueOffset);
        if (matchString == null) {
            return null;
        }
        ELPrefixUtils.ELTextRegion tr = new ELPrefixUtils.ELTextRegion(startOffset, this.getOffset() - matchString.length() - startOffset, matchString.length(), matchString, false, false, isAttributeValue, hasOpenQuote, hasCloseQuote, quoteChar);
        return tr;
    }

    protected String getELPredicateMatchString(String text, int offset) {
        int beginningOffset = offset - 1;
        while (beginningOffset >= 0 && (Character.isJavaIdentifierPart(text.charAt(beginningOffset)) || '.' == text.charAt(beginningOffset) || '_' == text.charAt(beginningOffset))) {
            --beginningOffset;
        }
        return text.substring(++beginningOffset, offset);
    }

    public static class ELXMLContentModelGenerator
    extends XMLContentModelGenerator {
    }

    class FakePageContext
    implements IPageContext {
        private IDocument document;
        private IFile file;
        private Map<String, List<INameSpace>> namespaces;
        private ITagLibrary[] tagLibraries;

        FakePageContext(Map<String, List<INameSpace>> namespaces, IDocument document, IFile file) {
            this.namespaces = namespaces;
            this.document = document;
            this.file = file;
            HashSet<ITagLibrary> libraries = new HashSet<ITagLibrary>();
            for (List<INameSpace> nsValues : namespaces.values()) {
                for (INameSpace ns : nsValues) {
                    ITagLibrary[] libs;
                    if (!(ns instanceof INameSpaceExtended) || (libs = ((INameSpaceExtended)ns).getTagLibraries()) == null) continue;
                    ITagLibrary[] iTagLibraryArray = libs;
                    int n = libs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITagLibrary lib = iTagLibraryArray[n2];
                        libraries.add(lib);
                        ++n2;
                    }
                }
            }
            this.tagLibraries = libraries.toArray(new ITagLibrary[0]);
        }

        public void setVars(List<Var> vars) {
        }

        public void setResource(IFile file) {
        }

        public void setElResolvers(ELResolver[] resolvers) {
        }

        public void setDirty(boolean dirty) {
        }

        public boolean isDirty() {
            return false;
        }

        public Var[] getVars(int offset) {
            return new Var[0];
        }

        public IFile getResource() {
            return this.file;
        }

        public ELResolver[] getElResolvers() {
            return new ELResolver[0];
        }

        public Collection<ELReference> getELReferences(IRegion region) {
            return new ArrayList<ELReference>();
        }

        public ELReference[] getELReferences() {
            return new ELReference[0];
        }

        public ELReference getELReference(int offset) {
            return null;
        }

        public Set<String> getURIs() {
            return this.namespaces.keySet();
        }

        public IResourceBundle[] getResourceBundles() {
            return new IResourceBundle[0];
        }

        public Map<String, List<INameSpace>> getNameSpaces(int offset) {
            return this.namespaces;
        }

        public ITagLibrary[] getLibraries() {
            return this.tagLibraries;
        }

        public IDocument getDocument() {
            return this.document;
        }

        public Map<String, List<INameSpace>> getRootNameSpaces() {
            return this.namespaces;
        }

        public List<Var> getVarsAsList(int offset) {
            return ELContextImpl.EMPTY;
        }
    }

    class NameSpaceInserter
    implements IRunnableWithProgress {
        ITextViewer viewer;
        String prefix;
        String uri;

        public NameSpaceInserter(ITextViewer viewer, String prefix, String uri) {
            this.viewer = viewer;
            this.prefix = prefix;
            this.uri = uri;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            if (this.uri == null || this.prefix == null) {
                return;
            }
            Properties properties = new Properties();
            properties.put("add taglib", "true");
            properties.put("start text", "");
            properties.put("library uri", this.uri);
            properties.put("default prefix", this.prefix);
            properties.put("force prefix", "true");
            properties.put("viewer", this.viewer);
            PaletteTaglibInserter inserter = new PaletteTaglibInserter();
            inserter.inserTaglib(this.viewer.getDocument(), properties);
        }
    }
}

