/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.i18n;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ISourceEditingTextTools;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.eclipse.wst.xml.ui.internal.provisional.IDOMSourceEditingTextTools;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.loaders.impl.EncodedProperties;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.ModelFeatureFactory;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jst.web.kb.IXmlContext;
import org.jboss.tools.jst.web.kb.PageContextFactory;
import org.jboss.tools.jst.web.project.list.IWebPromptingProvider;
import org.jboss.tools.jst.web.project.list.WebPromptingProvider;
import org.jboss.tools.jst.web.tld.TaglibData;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.editor.bundle.BundleMap;
import org.jboss.tools.jst.web.ui.internal.editor.editor.IVisualContext;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPMultiPageEditor;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPTextEditor;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.SourceEditorPageContext;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd.PaletteTaglibInserter;
import org.jboss.tools.jst.web.ui.internal.editor.messages.JstUIMessages;
import org.jboss.tools.jst.web.ui.internal.editor.util.FaceletsUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ExternalizeStringsUtils {
    public static final String NONAME = "noname";
    public static final char[] REPLACED_CHARACTERS = new char[]{'~', '!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '-', '+', '=', '{', '}', '[', ']', ':', ';', ',', '.', '?', '\\', '/', '\"', '\'', ' '};
    public static final char[] LINE_DELEMITERS = new char[]{'\r', '\n', '\t'};
    private static CharsetEncoder asciiEncoder;

    public static boolean isSelectionCorrect(ISelection selection) {
        boolean isSelectionCorrect = false;
        if (selection instanceof TextSelection && selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Element element;
            isSelectionCorrect = true;
            Object selectedElement = ((IStructuredSelection)selection).getFirstElement();
            if (selectedElement instanceof Element && (element = (Element)selectedElement).hasChildNodes()) {
                isSelectionCorrect = false;
            }
        }
        return isSelectionCorrect;
    }

    public static boolean isExternalizeStringsCommandEnabled(ISelection selection) {
        boolean enabled = false;
        String stringToUpdate = "";
        if (ExternalizeStringsUtils.isSelectionCorrect(selection)) {
            AttrImpl attrNode;
            ITextRegion textRegion;
            String text = "";
            TextSelection textSelection = null;
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            textSelection = (TextSelection)selection;
            text = textSelection.getText();
            Object selectedElement = structuredSelection.getFirstElement();
            if (text == null || text.trim().length() == 0) {
                AttrImpl attrNode2;
                ITextRegion textRegion2;
                if (selectedElement instanceof Text) {
                    Text textNode = (Text)selectedElement;
                    if (textNode.getNodeValue().trim().length() > 0) {
                        stringToUpdate = textNode.getNodeValue();
                    }
                } else if (selectedElement instanceof AttrImpl && (textRegion2 = (attrNode2 = (AttrImpl)selectedElement).getValueRegion()) != null && ((ElementImpl)attrNode2.getOwnerElement()).getStartOffset() + textRegion2.getStart() <= textSelection.getOffset() && ((ElementImpl)attrNode2.getOwnerElement()).getStartOffset() + textRegion2.getEnd() > textSelection.getOffset() && attrNode2.getNodeValue().trim().length() > 0) {
                    stringToUpdate = attrNode2.getNodeValue();
                }
            } else if (selectedElement instanceof IDOMText) {
                IDOMText textNode = (IDOMText)selectedElement;
                if (textNode.getStartOffset() <= textSelection.getOffset() && textNode.getEndOffset() >= textSelection.getOffset() + textSelection.getLength() && textNode.getNodeValue().trim().length() > 0) {
                    stringToUpdate = text;
                }
            } else if (selectedElement instanceof AttrImpl && (textRegion = (attrNode = (AttrImpl)selectedElement).getValueRegion()) != null && ((ElementImpl)attrNode.getOwnerElement()).getStartOffset() + textRegion.getStart() <= textSelection.getOffset() && ((ElementImpl)attrNode.getOwnerElement()).getStartOffset() + textRegion.getEnd() >= textSelection.getOffset() + textSelection.getLength() && attrNode.getNodeValue().trim().length() > 0) {
                stringToUpdate = text;
            }
        }
        if (stringToUpdate.length() > 0) {
            enabled = true;
        }
        return enabled;
    }

    public static XModelObject findFacesConfig(XModel model) {
        IWebPromptingProvider provider = (IWebPromptingProvider)ModelFeatureFactory.getInstance().createFeatureInstance("org.jboss.tools.jsf.model.pv.JSFPromptingProvider");
        if (provider == null) {
            return null;
        }
        List result = provider.getList(model, "jsf.faces.config", "", new Properties());
        if (result != null && !result.isEmpty()) {
            return (XModelObject)result.get(0);
        }
        return null;
    }

    public static BundleMap createBundleMap(ITextEditor editor) {
        int hash;
        IProject project;
        IModelNature modelNature;
        String uri = null;
        String prefix = null;
        Map map = null;
        BundleMap bm = new BundleMap();
        bm.init(editor.getEditorInput());
        boolean hasJsfProjectNatureType = false;
        try {
            IProject project2;
            IEditorInput ei = editor.getEditorInput();
            if (ei instanceof IFileEditorInput && (project2 = ((IFileEditorInput)ei).getFile().getProject()).exists() && project2.isOpen() && project2.hasNature("org.jboss.tools.jsf.jsfnature")) {
                hasJsfProjectNatureType = true;
            }
        }
        catch (CoreException e) {
            WebUiPlugin.getPluginLog().logError((Throwable)e);
        }
        if (hasJsfProjectNatureType && editor.getEditorInput() instanceof IFileEditorInput && (modelNature = EclipseResourceUtil.getModelNature((IProject)(project = ((IFileEditorInput)editor.getEditorInput()).getFile().getProject()))) != null) {
            XModel model = modelNature.getModel();
            List l = WebPromptingProvider.getInstance().getList(model, "jsf.registered.bundles", null, null);
            if (l != null && l.size() > 1 && l.get(1) instanceof Map && (map = (Map)l.get(1)) != null && map.keySet().size() > 0) {
                Iterator it = map.keySet().iterator();
                while (it.hasNext()) {
                    uri = it.next().toString();
                    prefix = map.get(uri).toString();
                    hash = (String.valueOf(prefix) + ":" + uri).hashCode();
                    bm.addBundle(hash, prefix, uri, false);
                }
            }
        }
        ISourceEditingTextTools sourceEditingTextTools = (ISourceEditingTextTools)editor.getAdapter(ISourceEditingTextTools.class);
        IDOMSourceEditingTextTools domSourceEditingTextTools = (IDOMSourceEditingTextTools)sourceEditingTextTools;
        Document documentWithBundles = domSourceEditingTextTools.getDOMDocument();
        if (editor instanceof JSPTextEditor) {
            IVisualContext context = ((JSPTextEditor)editor).getPageContext();
            List<TaglibData> taglibs = null;
            if (context instanceof SourceEditorPageContext) {
                SourceEditorPageContext sourcePageContext = (SourceEditorPageContext)context;
                taglibs = sourcePageContext.getTagLibs();
            }
            if (taglibs == null) {
                WebUiPlugin.getDefault().logError(JstUIMessages.CANNOT_LOAD_TAGLIBS_FROM_PAGE_CONTEXT);
            } else {
                Element root = FaceletsUtil.findComponentElement(documentWithBundles.getDocumentElement());
                if (root != null && FaceletsUtil.isFacelet(root, taglibs) && root.hasAttribute("template")) {
                    FileEditorInput fei;
                    IResource webContentResource;
                    String filePath = root.getAttributeNode("template").getNodeValue();
                    if (((JSPTextEditor)editor).getEditorInput() instanceof FileEditorInput && (webContentResource = EclipseResourceUtil.getFirstWebContentResource((IProject)(fei = (FileEditorInput)((JSPTextEditor)editor).getEditorInput()).getFile().getProject())) instanceof IContainer) {
                        IDOMDocument document;
                        block24: {
                            IFile templateFile = (IFile)((IContainer)webContentResource).findMember(filePath);
                            document = null;
                            IDOMModel wtpModel = null;
                            try {
                                wtpModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForRead(templateFile);
                                if (wtpModel != null) {
                                    document = wtpModel.getDocument();
                                }
                            }
                            catch (IOException e) {
                                WebUiPlugin.getPluginLog().logError((Throwable)e);
                                if (wtpModel != null) {
                                    wtpModel.releaseFromRead();
                                }
                                break block24;
                            }
                            catch (CoreException e) {
                                try {
                                    WebUiPlugin.getPluginLog().logError((Throwable)e);
                                    break block24;
                                }
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                                finally {
                                    if (wtpModel != null) {
                                        wtpModel.releaseFromRead();
                                    }
                                }
                            }
                            if (wtpModel == null) break block24;
                            wtpModel.releaseFromRead();
                        }
                        if (document != null) {
                            documentWithBundles = document;
                        }
                    }
                }
            }
        }
        NodeList list = documentWithBundles.getElementsByTagName("f:loadBundle");
        int i = 0;
        while (i < list.getLength()) {
            Element node = (Element)list.item(i);
            uri = node.getAttribute("basename");
            prefix = node.getAttribute("var");
            hash = node.hashCode();
            bm.addBundle(hash, prefix, uri, false);
            ++i;
        }
        return bm;
    }

    public static Table createPropertiesTable(Composite parent, int style) {
        Table table = new Table(parent, style);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn propNameColumn = new TableColumn(table, 0);
        propNameColumn.setText(JstUIMessages.EXTERNALIZE_STRINGS_DIALOG_PROPERTY_NAME);
        ColumnWeightData columnLayoutData = new ColumnWeightData(200, true);
        layout.addColumnData((ColumnLayoutData)columnLayoutData);
        TableColumn propValueColumn = new TableColumn(table, 0);
        propValueColumn.setText(JstUIMessages.EXTERNALIZE_STRINGS_DIALOG_PROPERTY_VALUE);
        columnLayoutData = new ColumnWeightData(200, true);
        layout.addColumnData((ColumnLayoutData)columnLayoutData);
        return table;
    }

    public static Properties populatePropertiesTable(Table table, IFile propertiesFile) {
        Properties properties = null;
        if (propertiesFile != null && propertiesFile.exists()) {
            BufferedReader in = null;
            try {
                try {
                    String encoding = FileUtil.getEncoding((IFile)propertiesFile);
                    in = new BufferedReader(new InputStreamReader(propertiesFile.getContents(), encoding));
                    properties = ExternalizeStringsUtils.readFileToProperties(table, in);
                    in.close();
                }
                catch (CoreException e) {
                    WebUiPlugin.getDefault().logError("Could not load file content for '" + propertiesFile + "'", e);
                    in = null;
                }
                catch (IOException e) {
                    WebUiPlugin.getDefault().logError("Could not read file: '" + propertiesFile + "'", e);
                    in = null;
                }
            }
            finally {
                Object var3_3 = null;
            }
        }
        return properties;
    }

    public static Properties populatePropertiesTable(Table table, File propertiesFile) {
        Properties properties = null;
        if (propertiesFile != null && propertiesFile.exists()) {
            FileReader fr = null;
            try {
                try {
                    fr = new FileReader(propertiesFile);
                    properties = ExternalizeStringsUtils.readFileToProperties(table, fr);
                    fr.close();
                }
                catch (FileNotFoundException e) {
                    WebUiPlugin.getDefault().logError(e);
                    fr = null;
                }
                catch (IOException e) {
                    WebUiPlugin.getDefault().logError("Could not read file: '" + propertiesFile + "'", e);
                    fr = null;
                }
            }
            finally {
                Object var3_3 = null;
            }
        }
        return properties;
    }

    private static Properties readFileToProperties(Table table, Reader r) {
        EncodedProperties properties = new EncodedProperties();
        try {
            properties.load(r);
            r.close();
        }
        catch (IOException e) {
            WebUiPlugin.getDefault().logError("Could not parse properties file.", e);
        }
        table.removeAll();
        int k = 0;
        String value = null;
        Set keys = properties.stringPropertyNames();
        ArrayList keysList = new ArrayList(keys);
        Collections.sort(keysList);
        for (String key : keysList) {
            TableItem tableItem = null;
            tableItem = new TableItem(table, 2048, k);
            ++k;
            value = properties.getProperty(key);
            if (value != null) {
                value = value.replaceAll("\t", "\\\\t");
                value = value.replaceAll("\r", "\\\\r");
                value = value.replaceAll("\n", "\\\\n");
            }
            tableItem.setText(new String[]{key, value});
        }
        return properties;
    }

    public static String generatePropertyKey(String text) {
        char ch;
        String result = text.trim();
        if (asciiEncoder == null) {
            asciiEncoder = Charset.forName("ISO-8859-1").newEncoder();
        }
        if (!asciiEncoder.canEncode(result)) {
            result = NONAME;
        }
        char[] cArray = LINE_DELEMITERS;
        int n = LINE_DELEMITERS.length;
        int n2 = 0;
        while (n2 < n) {
            ch = cArray[n2];
            result = result.trim().replace(ch, ' ');
            ++n2;
        }
        cArray = REPLACED_CHARACTERS;
        n = REPLACED_CHARACTERS.length;
        n2 = 0;
        while (n2 < n) {
            ch = cArray[n2];
            result = result.replace(ch, '_');
            ++n2;
        }
        if ((result = result.replaceAll("_+", "_")).startsWith("_")) {
            result = result.substring(1);
        }
        if (result.endsWith("_")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static void registerInFacesConfig(ITextEditor editor, String bundlePath, String var) {
        IProject project = ExternalizeStringsUtils.getProject(editor);
        if (project != null) {
            XModel model = EclipseResourceUtil.getModelNature((IProject)project).getModel();
            XModelObject facesConfig = ExternalizeStringsUtils.findFacesConfig(model);
            XModelObject application = facesConfig.getChildByPath("application");
            XModelObject resourceBundle = facesConfig.getModel().createModelObject("JSFResourceBundle", null);
            resourceBundle.setAttributeValue("base-name", bundlePath);
            resourceBundle.setAttributeValue("var", var);
            try {
                DefaultCreateHandler.addCreatedObject((XModelObject)application, (XModelObject)resourceBundle, (int)0);
            }
            catch (XModelException e) {
                WebUiPlugin.getDefault().logError("Could not add <resource-bundle> to the faces-config.xml", e);
            }
            XActionInvoker.invoke((String)"SaveActions.Save", (XModelObject)facesConfig, (Properties)new Properties());
        }
    }

    public static void registerViaLoadBundle(ITextEditor editor, String bundlePath, String var) {
        String jsfCoreTaglibPrefix = ExternalizeStringsUtils.registerMessageTaglib(editor);
        IStructuredModel model = null;
        IModelManager manager = StructuredModelManager.getModelManager();
        if (manager != null) {
            try {
                model = manager.getModelForEdit(ExternalizeStringsUtils.getFile(editor));
            }
            catch (IOException e) {
                WebUiPlugin.getDefault().logError(e);
            }
            catch (CoreException e) {
                WebUiPlugin.getDefault().logError(e);
            }
            if (model instanceof IDOMModel) {
                IDOMModel domModel = (IDOMModel)model;
                IDOMDocument document = domModel.getDocument();
                NodeList viewList = document.getElementsByTagName(String.valueOf(jsfCoreTaglibPrefix) + ":view");
                NodeList subviewList = document.getElementsByTagName(String.valueOf(jsfCoreTaglibPrefix) + ":subview");
                NodeList htmlList = document.getElementsByTagName("html");
                IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                Node node = null;
                node = viewList.getLength() > 0 ? viewList.item(0) : (subviewList.getLength() > 0 ? subviewList.item(0) : htmlList.item(0));
                if (node != null) {
                    Document srcDoc = node.getOwnerDocument();
                    Element loadBundle = srcDoc.createElement(String.valueOf(jsfCoreTaglibPrefix) + ":" + "loadBundle");
                    loadBundle.setAttribute("var", var);
                    loadBundle.setAttribute("basename", bundlePath);
                    Node n = node.getFirstChild();
                    ExternalizeStringsUtils.insertLoadBundleTag(node, n, loadBundle);
                }
            }
        } else {
            WebUiPlugin.getDefault().logWarning(JstUIMessages.EXTERNALIZE_STRINGS_DIALOG_CANNOT_ADD_LOAD_BUNDLE_TAG);
        }
    }

    public static String registerMessageTaglib(ITextEditor editor) {
        StructuredTextEditor ed;
        Set taglibs = null;
        String jsfCoreTaglibPrefix = "f";
        if (editor instanceof JSPMultiPageEditor && (ed = ((JSPMultiPageEditor)editor).getSourceEditor()) instanceof JSPTextEditor) {
            PageContextFactory.getInstance();
            ELContext context = PageContextFactory.createPageContext((IDocument)ed.getTextViewer().getDocument());
            if (context instanceof IXmlContext) {
                IXmlContext xmlPageContext = (IXmlContext)context;
                taglibs = xmlPageContext.getURIs();
                boolean isJsfCoreTaglibRegistered = false;
                for (String tl : taglibs) {
                    if (!"http://java.sun.com/jsf/core".equalsIgnoreCase(tl)) continue;
                    isJsfCoreTaglibRegistered = true;
                    break;
                }
                if (!isJsfCoreTaglibRegistered) {
                    PaletteTaglibInserter PaletteTaglibInserter2 = new PaletteTaglibInserter();
                    Properties p = new Properties();
                    p.put("selectionProvider", editor.getSelectionProvider());
                    p.setProperty("library uri", "http://java.sun.com/jsf/core");
                    p.setProperty("library version", "");
                    p.setProperty("default prefix", jsfCoreTaglibPrefix);
                    p.setProperty("add taglib", "true");
                    p.setProperty("automatically reformat tag body", "yes");
                    p.setProperty("start text", "<%@ taglib uri=\"http://java.sun.com/jsf/core\" prefix=\"f\" %>\\n");
                    PaletteTaglibInserter2.inserTaglib(ed.getTextViewer().getDocument(), p);
                }
            }
        }
        return jsfCoreTaglibPrefix;
    }

    public static IFile getFile(ITextEditor editor) {
        if (editor.getEditorInput() instanceof IFileEditorInput) {
            return ((IFileEditorInput)editor.getEditorInput()).getFile();
        }
        return null;
    }

    public static IProject getProject(ITextEditor editor) {
        IFile file = ExternalizeStringsUtils.getFile(editor);
        if (file != null) {
            return file.getProject();
        }
        return null;
    }

    public static boolean insertLoadBundleTag(Node elementToInsertBefore, Node refChild, Element loadBundle) {
        boolean success = false;
        if (elementToInsertBefore != null && refChild != null && loadBundle != null) {
            try {
                elementToInsertBefore.insertBefore(loadBundle, refChild);
                success = true;
            }
            catch (DOMException e) {
                WebUiPlugin.getDefault().logError(JstUIMessages.EXTERNALIZE_STRINGS_DIALOG_CANNOT_ADD_LOAD_BUNDLE_TAG, e);
            }
        } else {
            WebUiPlugin.getDefault().logWarning(JstUIMessages.EXTERNALIZE_STRINGS_DIALOG_CANNOT_ADD_LOAD_BUNDLE_TAG);
        }
        return success;
    }
}

