/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.i18n;

import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.document.TextImpl;
import org.jboss.tools.common.model.loaders.impl.EncodedProperties;
import org.jboss.tools.common.model.ui.ModelUIImages;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.editor.bundle.BundleMap;
import org.jboss.tools.jst.web.ui.internal.editor.i18n.ExternalizeStringsUtils;
import org.jboss.tools.jst.web.ui.internal.editor.messages.JstUIMessages;
import org.w3c.dom.Attr;

public class ExternalizeStringsWizardPage
extends WizardPage {
    public static final String PAGE_NAME = "ExternalizeStringsWizardBasicPage";
    private final int DIALOG_WIDTH = 450;
    private final int DIALOG_HEIGHT = 650;
    private Text propsKey;
    private Text propsValue;
    private Button newFile;
    private Label propsFileLabel;
    private Text propsFile;
    private Label rbListLabel;
    private Combo rbCombo;
    private BundleMap bm;
    private Group propsFilesGroup;
    private Status propsKeyStatus;
    private Status propsValueStatus;
    private Status duplicateKeyStatus;
    private Status duplicateValueStatus;
    private Table tagsTable;
    private IDocument document;
    private ISelectionProvider selectionProvider;

    public ExternalizeStringsWizardPage(String pageName, BundleMap bm, IDocument document, ISelectionProvider selectionProvider) {
        super(pageName, JstUIMessages.EXTERNALIZE_STRINGS_DIALOG_TITLE, ModelUIImages.getImageDescriptor((String)ModelUIImages.WIZARD_DEFAULT));
        this.setDescription(JstUIMessages.EXTERNALIZE_STRINGS_DIALOG_DESCRIPTION);
        this.setPageComplete(false);
        this.bm = bm;
        this.document = document;
        this.selectionProvider = selectionProvider;
        this.propsKeyStatus = new Status(0, "org.jboss.tools.jst.web.ui", "");
        this.propsValueStatus = new Status(0, "org.jboss.tools.jst.web.ui", "");
        this.duplicateKeyStatus = new Status(0, "org.jboss.tools.jst.web.ui", "");
        this.duplicateValueStatus = new Status(0, "org.jboss.tools.jst.web.ui", "");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 450;
        gd.heightHint = 650;
        composite.setLayoutData((Object)gd);
        Group propsStringGroup = new Group(composite, 16);
        propsStringGroup.setLayout((Layout)new GridLayout(3, false));
        propsStringGroup.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        propsStringGroup.setText(JstUIMessages.EXTERNALIZE_STRINGS_DIALOG_PROPS_STRINGS_GROUP);
        Label propsKeyLabel = new Label((Composite)propsStringGroup, 0);
        propsKeyLabel.setLayoutData((Object)new GridData(131072, 0, false, false, 1, 1));
        propsKeyLabel.setText(JstUIMessages.EXTERNALIZE_STRINGS_DIALOG_PROPERTIES_KEY);
        this.propsKey = new Text((Composite)propsStringGroup, 2048);
        this.propsKey.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.propsKey.setText(JstUIMessages.EXTERNALIZE_STRINGS_DIALOG_DEFAULT_KEY);
        Label propsValueLabel = new Label((Composite)propsStringGroup, 0);
        propsValueLabel.setLayoutData((Object)new GridData(131072, 0, false, false, 1, 1));
        propsValueLabel.setText(JstUIMessages.EXTERNALIZE_STRINGS_DIALOG_PROPERTIES_VALUE);
        this.propsValue = new Text((Composite)propsStringGroup, 2048);
        this.propsValue.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.propsValue.setText("");
        this.newFile = new Button(composite, 32);
        this.newFile.setLayoutData((Object)new GridData(16384, 0, false, false, 1, 1));
        this.newFile.setText(JstUIMessages.EXTERNALIZE_STRINGS_DIALOG_NEW_FILE);
        this.propsFilesGroup = new Group(composite, 16);
        this.propsFilesGroup.setLayout((Layout)new GridLayout(3, false));
        gd = new GridData(4, 4, true, false, 1, 1);
        gd.heightHint = 300;
        this.propsFilesGroup.setLayoutData((Object)gd);
        this.propsFilesGroup.setText(JstUIMessages.EXTERNALIZE_STRINGS_DIALOG_PROPS_FILES_GROUP);
        this.rbListLabel = new Label((Composite)this.propsFilesGroup, 0);
        this.rbListLabel.setLayoutData((Object)new GridData(131072, 0, false, false, 1, 1));
        this.rbListLabel.setText(JstUIMessages.EXTERNALIZE_STRINGS_DIALOG_RESOURCE_BUNDLE_LIST);
        this.rbCombo = new Combo((Composite)this.propsFilesGroup, 0);
        this.rbCombo.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.propsFileLabel = new Label((Composite)this.propsFilesGroup, 0);
        this.propsFileLabel.setLayoutData((Object)new GridData(131072, 0, false, false, 1, 1));
        this.propsFileLabel.setText(JstUIMessages.EXTERNALIZE_STRINGS_DIALOG_PROPERTIES_FILE);
        this.propsFile = new Text((Composite)this.propsFilesGroup, 2048);
        this.propsFile.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.propsFile.setText("");
        this.propsFile.setEditable(false);
        this.tagsTable = ExternalizeStringsUtils.createPropertiesTable((Composite)this.propsFilesGroup, 2048);
        this.initializeFieldsAndAddLIsteners();
        this.setControl((Control)composite);
    }

    public String getBundlePrefix() {
        String bundlePrefix = "";
        if (!this.isNewFile()) {
            BundleMap.BundleEntry[] bundleEntryArray = this.bm.getBundles();
            int n = bundleEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                BundleMap.BundleEntry be = bundleEntryArray[n2];
                if (be.uri.equalsIgnoreCase(this.rbCombo.getText())) {
                    bundlePrefix = be.prefix;
                }
                ++n2;
            }
        }
        return bundlePrefix;
    }

    public IFile getBundleFile() {
        return this.bm.getBundleFile(this.rbCombo.getText());
    }

    public boolean isDuplicatedKeyAndValue() {
        boolean exists = false;
        if (this.isValueDuplicated(this.propsValue.getText()) && this.isKeyDuplicated(this.propsKey.getText())) {
            exists = true;
        }
        return exists;
    }

    public String getKeyValuePair() {
        String value = this.propsValue.getText();
        if (value != null) {
            value = value.replaceAll("\\\\t", "\t");
            value = value.replaceAll("\\\\r", "\r");
            value = value.replaceAll("\\\\n", "\n");
        }
        return String.valueOf(this.propsKey.getText()) + "=" + EncodedProperties.saveConvert((String)value, (boolean)true);
    }

    public String getKey() {
        return this.propsKey.getText();
    }

    public boolean isNewFile() {
        return this.newFile.getSelection();
    }

    public void replaceText(String replacement) {
        IDocument doc = this.getDocument();
        ISelection sel = this.getSelectionProvider().getSelection();
        if (ExternalizeStringsUtils.isSelectionCorrect(sel)) {
            try {
                TextSelection textSel = (TextSelection)sel;
                IStructuredSelection structuredSelection = (IStructuredSelection)sel;
                Object firstElement = structuredSelection.getFirstElement();
                int offset = 0;
                int length = 0;
                if (textSel.getLength() != 0) {
                    offset = textSel.getOffset();
                    length = textSel.getLength();
                } else if (firstElement instanceof TextImpl) {
                    TextImpl ti = (TextImpl)firstElement;
                    offset = ti.getStartOffset();
                    length = ti.getLength();
                } else if (firstElement instanceof AttrImpl) {
                    AttrImpl ai = (AttrImpl)firstElement;
                    offset = ai.getValueRegionStartOffset() + 1;
                    length = ai.getValueRegionText().length() - 2;
                }
                doc.replace(offset, length, replacement);
            }
            catch (BadLocationException ex) {
                WebUiPlugin.getPluginLog().logError((Throwable)ex);
            }
        }
    }

    public boolean isPageComplete() {
        boolean isPageComplete = false;
        if (!(this.getErrorMessage() != null || "".equalsIgnoreCase(this.propsKey.getText().trim()) || "".equalsIgnoreCase(this.propsValue.getText().trim()) || this.rbCombo.getSelectionIndex() == -1 && !this.isNewFile())) {
            isPageComplete = true;
        }
        return isPageComplete;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete() && this.getNextPage() != null && this.isNewFile();
    }

    private void initializeFieldsAndAddLIsteners() {
        ISelection sel = this.getSelectionProvider().getSelection();
        if (ExternalizeStringsUtils.isSelectionCorrect(sel)) {
            String text = "";
            String stringToUpdate = "";
            TextSelection textSelection = null;
            IStructuredSelection structuredSelection = (IStructuredSelection)sel;
            textSelection = (TextSelection)sel;
            text = textSelection.getText();
            Object selectedElement = structuredSelection.getFirstElement();
            if (text.trim().length() == 0) {
                Attr attrNode;
                if (selectedElement instanceof org.w3c.dom.Text) {
                    org.w3c.dom.Text textNode = (org.w3c.dom.Text)selectedElement;
                    if (textNode.getNodeValue().trim().length() > 0) {
                        stringToUpdate = textNode.getNodeValue();
                        this.getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)stringToUpdate));
                    }
                } else if (selectedElement instanceof Attr && (attrNode = (Attr)selectedElement).getNodeValue().trim().length() > 0) {
                    stringToUpdate = attrNode.getNodeValue();
                    this.getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)stringToUpdate));
                }
                if (stringToUpdate.trim().length() > 0) {
                    text = stringToUpdate;
                }
            }
            this.propsKey.setText(ExternalizeStringsUtils.generatePropertyKey(text));
            String value = text;
            if (value != null) {
                value = value.replaceAll("\t", "\\\\t");
                value = value.replaceAll("\r", "\\\\r");
                value = value.replaceAll("\n", "\\\\n");
            }
            this.propsValue.setText(value);
            if (this.bm == null) {
                WebUiPlugin.getDefault().logWarning(JstUIMessages.EXTERNALIZE_STRINGS_DIALOG_RB_IS_MISSING);
            } else {
                BundleMap.BundleEntry[] bundles = this.bm.getBundles();
                HashSet<String> uriSet = new HashSet<String>();
                BundleMap.BundleEntry[] bundleEntryArray = bundles;
                int n = bundles.length;
                int n2 = 0;
                while (n2 < n) {
                    BundleMap.BundleEntry bundleEntry = bundleEntryArray[n2];
                    if (!uriSet.contains(bundleEntry.uri)) {
                        uriSet.add(bundleEntry.uri);
                        this.rbCombo.add(bundleEntry.uri);
                    }
                    ++n2;
                }
                if (this.rbCombo.getItemCount() > 0) {
                    this.rbCombo.select(0);
                    this.setResourceBundlePath(this.rbCombo.getText());
                } else {
                    this.newFile.setSelection(true);
                    this.enableBundleGroup(false);
                }
            }
            this.updatePropertiesValueStatus();
            this.updateDuplicateValueStatus();
            if (this.propsValueStatus.isOK()) {
                if (!this.duplicateValueStatus.isOK()) {
                    this.propsKey.setText(this.getValueForKey(this.propsValue.getText()));
                    this.applyStatus((DialogPage)this, new IStatus[]{this.duplicateValueStatus});
                } else {
                    this.updateDuplicateKeyStatus();
                    while (!this.duplicateKeyStatus.isOK()) {
                        int index = this.propsKey.getText().lastIndexOf(95);
                        String newKey = "";
                        if (index != -1) {
                            String numberString = this.propsKey.getText().substring(index + 1);
                            try {
                                int number = Integer.parseInt(numberString);
                                newKey = String.valueOf(this.propsKey.getText().substring(0, index + 1)) + ++number;
                            }
                            catch (NumberFormatException e) {
                                newKey = String.valueOf(this.propsKey.getText()) + "_1";
                            }
                        } else {
                            newKey = String.valueOf(this.propsKey.getText()) + "_1";
                        }
                        this.propsKey.setText(newKey);
                        this.updateDuplicateKeyStatus();
                    }
                    this.setMessage(JstUIMessages.EXTERNALIZE_STRINGS_DIALOG_ENTER_KEY_NAME, 1);
                }
            } else {
                this.applyStatus((DialogPage)this, new IStatus[]{this.propsValueStatus});
            }
            this.setPageComplete(this.isPageComplete());
            this.propsKey.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ExternalizeStringsWizardPage.this.updateStatus();
                }
            });
            this.propsKey.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    int i = 0;
                    while (i < ExternalizeStringsUtils.REPLACED_CHARACTERS.length) {
                        if (e.character == ExternalizeStringsUtils.REPLACED_CHARACTERS[i] && e.character != '.') {
                            e.doit = false;
                            break;
                        }
                        ++i;
                    }
                }
            });
            this.propsValue.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ExternalizeStringsWizardPage.this.updateStatus();
                }
            });
            this.newFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean selected = ((Button)e.getSource()).getSelection();
                    if (selected) {
                        ExternalizeStringsWizardPage.this.enableBundleGroup(false);
                    } else {
                        ExternalizeStringsWizardPage.this.enableBundleGroup(true);
                    }
                    ExternalizeStringsWizardPage.this.updateStatus();
                }
            });
            this.rbCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExternalizeStringsWizardPage.this.setResourceBundlePath(ExternalizeStringsWizardPage.this.rbCombo.getText());
                    ExternalizeStringsWizardPage.this.updateDuplicateKeyStatus();
                    ExternalizeStringsWizardPage.this.updateStatus();
                }
            });
        } else {
            WebUiPlugin.getDefault().logWarning(JstUIMessages.EXTERNALIZE_STRINGS_DIALOG_INITIALIZATION_ERROR);
        }
    }

    private boolean isKeyDuplicated(String key) {
        boolean isDuplicated = false;
        if (this.tagsTable.getItemCount() > 0 && key != null && !this.isNewFile()) {
            TableItem[] items;
            TableItem[] tableItemArray = items = this.tagsTable.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem tableItem = tableItemArray[n2];
                if (key.equalsIgnoreCase(tableItem.getText(0))) {
                    isDuplicated = true;
                    break;
                }
                ++n2;
            }
        }
        return isDuplicated;
    }

    private boolean isValueDuplicated(String value) {
        boolean isDuplicated = false;
        if (this.tagsTable.getItemCount() > 0 && value != null && !this.isNewFile()) {
            TableItem[] items;
            TableItem[] tableItemArray = items = this.tagsTable.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem tableItem = tableItemArray[n2];
                if (value.equalsIgnoreCase(tableItem.getText(1))) {
                    isDuplicated = true;
                    break;
                }
                ++n2;
            }
        }
        return isDuplicated;
    }

    private String getValueForKey(String value) {
        String key = "";
        if (this.tagsTable.getItemCount() > 0 && value != null && !this.isNewFile()) {
            TableItem[] items;
            TableItem[] tableItemArray = items = this.tagsTable.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem tableItem = tableItemArray[n2];
                if (value.equalsIgnoreCase(tableItem.getText(1))) {
                    key = tableItem.getText(0);
                    break;
                }
                ++n2;
            }
        }
        return key;
    }

    private void enableBundleGroup(boolean enabled) {
        this.propsFilesGroup.setEnabled(enabled);
        this.propsFileLabel.setEnabled(enabled);
        this.propsFile.setEnabled(enabled);
        this.rbListLabel.setEnabled(enabled);
        this.rbCombo.setEnabled(enabled);
        this.tagsTable.setEnabled(enabled);
    }

    private void updateDuplicateKeyStatus() {
        this.duplicateKeyStatus = this.isKeyDuplicated(this.propsKey.getText()) ? new Status(4, "org.jboss.tools.jst.web.ui", JstUIMessages.EXTERNALIZE_STRINGS_DIALOG_KEY_ALREADY_EXISTS) : new Status(0, "org.jboss.tools.jst.web.ui", "");
    }

    private void updateDuplicateValueStatus() {
        this.duplicateValueStatus = this.isValueDuplicated(this.propsValue.getText()) ? new Status(2, "org.jboss.tools.jst.web.ui", JstUIMessages.EXTERNALIZE_STRINGS_DIALOG_VALUE_EXISTS) : new Status(0, "org.jboss.tools.jst.web.ui", "");
    }

    private void updatePropertiesValueStatus() {
        String text = this.propsValue.getText();
        this.propsValueStatus = text == null || "".equalsIgnoreCase(text.trim()) || text.indexOf(">") != -1 || text.indexOf("<") != -1 ? new Status(4, "org.jboss.tools.jst.web.ui", JstUIMessages.EXTERNALIZE_STRINGS_DIALOG_WRONG_SELECTED_TEXT) : new Status(0, "org.jboss.tools.jst.web.ui", "");
    }

    private void updatePropertiesKeyStatus() {
        this.propsKeyStatus = this.propsKey.getText() == null || "".equalsIgnoreCase(this.propsKey.getText().trim()) ? new Status(4, "org.jboss.tools.jst.web.ui", JstUIMessages.EXTERNALIZE_STRINGS_DIALOG_KEY_MUST_BE_SET) : new Status(0, "org.jboss.tools.jst.web.ui", "");
    }

    private void updateStatus() {
        this.updatePropertiesKeyStatus();
        this.updatePropertiesValueStatus();
        this.updateDuplicateKeyStatus();
        this.updateDuplicateValueStatus();
        if (!this.duplicateValueStatus.isOK() && this.getValueForKey(this.propsValue.getText()).equalsIgnoreCase(this.propsKey.getText())) {
            this.applyStatus((DialogPage)this, new IStatus[]{this.propsKeyStatus, this.propsValueStatus, this.duplicateValueStatus});
        } else {
            this.applyStatus((DialogPage)this, new IStatus[]{this.propsKeyStatus, this.propsValueStatus, this.duplicateKeyStatus});
        }
        this.setPageComplete(this.isPageComplete());
    }

    private void applyStatus(DialogPage page, IStatus[] statuses) {
        IStatus severeStatus = statuses[0];
        IStatus[] iStatusArray = statuses;
        int n = statuses.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status = iStatusArray[n2];
            severeStatus = severeStatus.getSeverity() >= status.getSeverity() ? severeStatus : status;
            ++n2;
        }
        String message = severeStatus.getMessage();
        switch (severeStatus.getSeverity()) {
            case 0: {
                page.setMessage(null, 0);
                page.setErrorMessage(null);
                break;
            }
            case 2: {
                page.setMessage(message, 2);
                page.setErrorMessage(null);
                break;
            }
            case 1: {
                page.setMessage(message, 1);
                page.setErrorMessage(null);
                break;
            }
            default: {
                if (message.length() == 0) {
                    message = null;
                }
                page.setMessage(null);
                page.setErrorMessage(message);
            }
        }
    }

    private void setResourceBundlePath(String bundleName) {
        IFile bundleFile = this.bm.getBundleFile(bundleName);
        String bundlePath = "";
        if (bundleFile != null) {
            bundlePath = bundleFile.getFullPath().toString();
            ExternalizeStringsUtils.populatePropertiesTable(this.tagsTable, bundleFile);
        } else {
            WebUiPlugin.getDefault().logError("Could not get Bundle File for resource '" + bundleName + "'");
        }
        this.propsFile.setText(bundlePath);
    }

    private ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    private IDocument getDocument() {
        return this.document;
    }
}

