/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd;

import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.jboss.tools.common.model.ui.editors.dnd.DropData;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPTextEditor;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd.JSPTagProposalFactory;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd.PaletteItemDropCommand;
import org.jboss.tools.jst.web.ui.palette.internal.PaletteItemTransfer;
import org.jboss.tools.jst.web.ui.palette.internal.html.IPaletteItem;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Text;

public class PaletteItemDropTargetListener
extends DropTargetAdapter
implements TransferDropTargetListener {
    private JSPTextEditor editor;
    int lastpos = -1;
    int lastdetail = -1;
    private int operation;
    private PaletteItemDropCommand command = null;

    public PaletteItemDropTargetListener(JSPTextEditor editor) {
        this.editor = editor;
    }

    public void dragEnter(DropTargetEvent event) {
        this.lastpos = -1;
        this.lastdetail = this.operation = event.detail;
        if (!PaletteItemTransfer.getInstance().isSupportedType(event.currentDataType)) {
            event.detail = 0;
            return;
        }
        IPaletteItem item = PaletteItemTransfer.getInstance().getPaletteItem();
        this.command = new PaletteItemDropCommand(item, false);
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
        this.lastdetail = this.operation = event.detail;
    }

    public void dragOver(DropTargetEvent event) {
        StructuredTextViewer ext;
        int off;
        int position;
        event.feedback = 9;
        int effectPosition = position = this.editor.getDropPosition(event.x, event.y, this.command);
        if (this.editor.getTextViewer() instanceof ITextViewerExtension5 && (off = (ext = this.editor.getTextViewer()).modelOffset2WidgetOffset(position)) >= 0) {
            effectPosition = off;
        }
        this.editor.getDropEffect().setNewOffset(effectPosition);
        if (this.lastpos == position && position >= 0) {
            event.detail = this.lastdetail = this.operation;
            return;
        }
        this.lastpos = position;
        IndexedRegion region = this.editor.getModel().getIndexedRegion(position);
        if (region instanceof ElementImpl) {
            ElementImpl jspElement = (ElementImpl)region;
            NamedNodeMap attributes = jspElement.getAttributes();
            if (position == jspElement.getStartOffset() || position == jspElement.getEndStartOffset()) {
                event.detail = this.lastdetail = this.operation;
                return;
            }
            this.lastdetail = 0;
            event.detail = 0;
        } else if (region instanceof Text) {
            event.detail = this.lastdetail = this.operation;
        } else {
            if (region instanceof DocumentType) {
                this.lastdetail = 0;
                event.detail = 0;
                return;
            }
            if (region == null) {
                event.detail = this.lastdetail = this.operation;
            }
        }
    }

    public void drop(DropTargetEvent event) {
        int offset = this.editor.getDropPosition(event.x, event.y, this.command);
        this.editor.selectAndReveal(offset, 0);
        DropData dropData = new DropData("palette/item", "", this.editor.getEditorInput(), (ISourceViewer)this.editor.getTextViewer(), this.editor.getSelectionProvider());
        this.command.setDoNotShowDialog(event.detail == 1);
        this.command.setTagProposalFactory(JSPTagProposalFactory.getInstance());
        this.command.execute(dropData);
    }

    public void dropAccept(DropTargetEvent event) {
        event.detail = this.lastdetail;
    }

    public Transfer getTransfer() {
        return PaletteItemTransfer.getInstance();
    }

    public boolean isEnabled(DropTargetEvent event) {
        return PaletteItemTransfer.getInstance().isSupportedType(event.currentDataType);
    }
}

