/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.views.palette.PaletteInsertHelper;
import org.jboss.tools.jst.web.tld.TaglibData;
import org.jboss.tools.jst.web.tld.VpeTaglibManager;
import org.jboss.tools.jst.web.tld.VpeTaglibManagerProvider;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd.JSPPaletteInsertHelper;
import org.jboss.tools.jst.web.ui.internal.editor.util.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PaletteTaglibInserter {
    private static final String JSP_SOURCE_ROOT_ELEMENT = "jsp:root";
    public static final String JSP_URI = "http://java.sun.com/JSP/Page";
    public static final String faceletUri = "http://java.sun.com/jsf/facelets";
    private static final String TAGLIB_START = "<%@ taglib";

    public Properties inserTaglib(IDocument d, Properties p) {
        if (!this.inserTaglibInXml(d, p)) {
            this.inserTaglibInOldJsp(d, p);
        }
        return p;
    }

    private boolean checkProperties(Properties p) {
        return "true".equalsIgnoreCase(p.getProperty("add taglib")) && p.getProperty("library uri") != null && p.getProperty("library uri").length() > 0 && !p.getProperty("library uri").equals(JSP_URI) && p.getProperty("default prefix") != null && p.getProperty("default prefix").length() > 0 && p.getProperty("start text") != null;
    }

    public boolean inserTaglibInOldJsp(IDocument d, Properties p) {
        if (!this.checkProperties(p)) {
            return false;
        }
        IStructuredModel model = null;
        try {
            DocumentImpl docImpl;
            IDOMDocument xmlDocument;
            model = StructuredModelManager.getModelManager().getModelForRead((IStructuredDocument)d);
            IDOMDocument iDOMDocument = xmlDocument = model instanceof IDOMModel ? ((IDOMModel)model).getDocument() : null;
            if (xmlDocument == null) {
                return false;
            }
            Properties tl = PaletteTaglibInserter.getPrefixes(d, p);
            if (tl == null) {
                tl = JSPPaletteInsertHelper.getPrefixes(d.get());
            }
            Element root = xmlDocument.getDocumentElement();
            String uri_p = p.getProperty("library uri");
            String defaultPrefix_p = p.getProperty("default prefix");
            boolean forcePrefix = "true".equalsIgnoreCase(p.getProperty("force prefix"));
            String lineDelimiter = PaletteInsertHelper.getLineDelimiter((IDocument)d);
            StringBuffer tg = new StringBuffer(TAGLIB_START).append(" uri=\"").append(uri_p).append("\"").append(" prefix=\"").append(defaultPrefix_p).append("\"%>").append(lineDelimiter);
            if (tl != null && !tl.isEmpty()) {
                if (!forcePrefix && tl.containsKey(uri_p)) {
                    if (!tl.get(uri_p).equals(defaultPrefix_p)) {
                        p.setProperty("default prefix", (String)tl.get(uri_p));
                    }
                } else if (!tl.containsValue(defaultPrefix_p) && !PaletteTaglibInserter.checkplace(xmlDocument, d, "jsp:directive.taglib", tg, p)) {
                    d.replace(0, 0, tg.toString());
                    PaletteTaglibInserter.mouveFocusOnPage(p, tg.toString().length(), 0);
                    return true;
                }
            } else if (xmlDocument instanceof DocumentImpl && (docImpl = (DocumentImpl)xmlDocument).isJSPType() && !PaletteTaglibInserter.checkplace(xmlDocument, d, "jsp:directive.page", tg, p)) {
                d.replace(0, 0, tg.toString());
                PaletteTaglibInserter.mouveFocusOnPage(p, tg.toString().length(), 0);
                return true;
            }
        }
        catch (BadLocationException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return false;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IndexedRegion getNodeAt(IDocument d, int documentOffset) {
        if (d == null) {
            return null;
        }
        IndexedRegion node = null;
        IModelManager mm = StructuredModelManager.getModelManager();
        IStructuredModel model = null;
        if (mm != null) {
            model = mm.getModelForRead((IStructuredDocument)d);
        }
        try {
            block9: {
                int lastOffset;
                block8: {
                    if (model == null) return node;
                    lastOffset = documentOffset;
                    node = model.getIndexedRegion(documentOffset);
                    if (!true) break block8;
                    if (node != null) return node;
                    if (lastOffset < 0) break block9;
                }
                do {
                    node = model.getIndexedRegion(--lastOffset);
                    if (node != null) return node;
                } while (lastOffset >= 0);
            }
            return node;
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    private static Node getSelectedNode(IDocument d, Properties p) {
        ISelectionProvider selProvider = (ISelectionProvider)p.get("selectionProvider");
        if (selProvider == null) {
            return null;
        }
        ITextSelection selection = null;
        if (!(selProvider.getSelection() instanceof ITextSelection)) {
            return null;
        }
        selection = (ITextSelection)selProvider.getSelection();
        IndexedRegion region = PaletteTaglibInserter.getNodeAt(d, selection.getOffset());
        if (region == null) {
            return null;
        }
        if (!(region instanceof Node)) {
            return null;
        }
        Node text = (Node)region;
        if ("#text".equals(text.getNodeName())) {
            return text.getParentNode();
        }
        return text;
    }

    private static boolean checkSelectedElement(HashMap<String, String> map, IDocument d, Properties p) {
        String taglibUri = p.getProperty("library uri");
        if (taglibUri == null) {
            return false;
        }
        Node selectedNode = PaletteTaglibInserter.getSelectedNode(d, p);
        if (selectedNode == null) {
            return false;
        }
        return PaletteTaglibInserter.checkElement(map, selectedNode, taglibUri);
    }

    private static boolean checkElement(HashMap<String, String> map, Node node, String taglibUri) {
        NamedNodeMap attrs = node.getAttributes();
        int j = 0;
        while (attrs != null && j < attrs.getLength()) {
            Node a = attrs.item(j);
            String name = a.getNodeName();
            if (name.startsWith("xmlns:")) {
                map.put(a.getNodeValue(), name.substring("xmlns:".length()));
            }
            ++j;
        }
        if (map.containsKey(taglibUri)) {
            return true;
        }
        if (node.getParentNode() == null) {
            return false;
        }
        return PaletteTaglibInserter.checkElement(map, node.getParentNode(), taglibUri);
    }

    public boolean inserTaglibInXml(IDocument d, Properties p) {
        if (!this.checkProperties(p)) {
            return false;
        }
        IStructuredModel model = null;
        try {
            Element root;
            IDOMDocument xmlDocument;
            model = StructuredModelManager.getModelManager().getModelForRead((IStructuredDocument)d);
            IDOMDocument iDOMDocument = xmlDocument = model instanceof IDOMModel ? ((IDOMModel)model).getDocument() : null;
            if (xmlDocument == null) {
                return false;
            }
            Properties tl = PaletteTaglibInserter.getPrefixes(d, p);
            if (tl == null) {
                tl = JSPPaletteInsertHelper.getPrefixes(d.get());
            }
            if ((root = xmlDocument.getDocumentElement()) != null) {
                IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                if (xmlDocument.getDoctype() != null) {
                    String publicId = xmlDocument.getDoctype().getPublicId();
                    if (publicId != null && publicId.toUpperCase().startsWith("-//W3C//DTD XHTML")) {
                        PaletteTaglibInserter.checkTL(root, p, d);
                        return true;
                    }
                } else if (xmlDocument.isXMLType() || root.getNodeName().equals(JSP_SOURCE_ROOT_ELEMENT) || editorPart != null && editorPart.getTitle().toLowerCase().endsWith(".jspx")) {
                    PaletteTaglibInserter.checkTL(root, p, d);
                    return true;
                }
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return false;
    }

    public static Properties getPrefixes(IDocument d, Properties properties) {
        List<TaglibData> list = PaletteTaglibInserter.getTaglibData(d, properties);
        Properties p = new Properties();
        int i = 0;
        while (i < list.size()) {
            TaglibData data = list.get(i);
            p.setProperty(data.getUri(), data.getPrefix());
            ++i;
        }
        return p;
    }

    private static List<TaglibData> getTaglibData(IDocument d, Properties p) {
        ISourceViewer viewer = PaletteTaglibInserter.getViewer(p);
        if (viewer != null) {
            VpeTaglibManager tldManager = null;
            if (viewer instanceof VpeTaglibManagerProvider && (tldManager = ((VpeTaglibManagerProvider)viewer).getTaglibManager()) != null) {
                return tldManager.getTagLibs();
            }
        } else {
            Node node;
            List<TaglibData> result = XmlUtil.getTaglibsForJSPDocument(d, new ArrayList<TaglibData>());
            if ((result == null || result.isEmpty()) && (node = PaletteTaglibInserter.getSelectedNode(d, p)) != null) {
                result = XmlUtil.processNode(node, new ArrayList<TaglibData>());
            }
            return result;
        }
        return null;
    }

    private static Properties checkTL(Element root, Properties p, IDocument d) {
        String uri_p = p.getProperty("library uri");
        String defaultPrefix_p = p.getProperty("default prefix");
        boolean forcePrefix = "true".equals(p.getProperty("force prefix"));
        HashMap<String, String> map = new HashMap<String, String>();
        NamedNodeMap attrs = root.getAttributes();
        int j = 0;
        while (attrs != null && j < attrs.getLength()) {
            Node a = attrs.item(j);
            String name = a.getNodeName();
            if (name.startsWith("xmlns:")) {
                map.put(a.getNodeValue(), name.substring("xmlns:".length()));
            }
            ++j;
        }
        if (!forcePrefix && (map.containsKey(uri_p) || PaletteTaglibInserter.checkSelectedElement(map, d, p))) {
            if (!((String)map.get(uri_p)).equals(defaultPrefix_p)) {
                p.setProperty("default prefix", map.get(uri_p));
            }
        } else if (!map.containsValue(defaultPrefix_p)) {
            StringBuffer attribute = new StringBuffer("xmlns:").append(defaultPrefix_p).append("=\"").append(uri_p).append("\"");
            int so = ((IDOMElement)root).getStartOffset();
            int seo = ((IDOMElement)root).getStartEndOffset();
            try {
                String lineDelimiter = PaletteInsertHelper.getLineDelimiter((IDocument)d);
                StringBuffer selectedSource = new StringBuffer().append(d.get(so, seo - so));
                int xmlns = selectedSource.indexOf("xmlns");
                attribute = new StringBuffer().append(PaletteTaglibInserter.createEmptyCharArray(xmlns)).append("xmlns:").append(defaultPrefix_p).append("=\"").append(uri_p).append("\"");
                if (d.getLineOffset(d.getLineOfOffset(so)) != so) {
                    attribute.insert(0, PaletteTaglibInserter.analyseSubstring(d.get(d.getLineOffset(d.getLineOfOffset(so)), so - d.getLineOffset(d.getLineOfOffset(so)))));
                }
                if (xmlns > 0) {
                    attribute.insert(0, lineDelimiter);
                } else {
                    attribute.insert(0, ' ');
                }
                selectedSource.insert(selectedSource.length() - 1, attribute);
                d.replace(so, seo - so, selectedSource.toString());
            }
            catch (BadLocationException t) {
                ModelUIPlugin.getPluginLog().logError("", (Throwable)t);
            }
        }
        return p;
    }

    private static char[] createEmptyCharArray(int n) {
        if (n < 1) {
            return new char[0];
        }
        char[] ca = new char[n];
        int i = 0;
        while (i < n) {
            ca[i] = 32;
            ++i;
        }
        return ca;
    }

    private static ISourceViewer getViewer(Properties p) {
        return (ISourceViewer)p.get("viewer");
    }

    private static void mouveFocusOnPage(Properties p, int length, int pos) {
        ISourceViewer v = PaletteTaglibInserter.getViewer(p);
        ISelectionProvider selProvider = (ISelectionProvider)p.get("selectionProvider");
        IDocument doc = v.getDocument();
        if (doc == null || selProvider == null) {
            return;
        }
        ITextSelection selection = (ITextSelection)selProvider.getSelection();
        if (selection.getOffset() == 0) {
            v.setSelectedRange(length, 0);
            p.put("selectionProvider", v.getSelectionProvider());
        } else if (selection.getOffset() == pos) {
            v.setSelectedRange(length, 0);
            p.put("selectionProvider", v.getSelectionProvider());
        }
    }

    private static StringBuffer analyseSubstring(String str) {
        StringBuffer st = new StringBuffer().append(str);
        int i = 0;
        while (i < st.length()) {
            if (st.charAt(i) != ' ' && st.charAt(i) != '\t') {
                st.setCharAt(i, ' ');
            }
            ++i;
        }
        return st;
    }

    private static boolean checkplace(IDOMDocument xmlDocument, IDocument d, String st, StringBuffer tg, Properties p) throws BadLocationException {
        NodeList nl = xmlDocument.getChildNodes();
        boolean docType = false;
        IndexedRegion irdt = null;
        if (xmlDocument.getDoctype() != null) {
            docType = true;
            String publicId = xmlDocument.getDoctype().getPublicId();
            if (publicId != null && publicId.toUpperCase().startsWith("-//W3C//DTD HTML")) {
                IndexedRegion indexedRegion = irdt = xmlDocument.getDoctype() instanceof IndexedRegion ? (IndexedRegion)xmlDocument.getDoctype() : null;
            }
        }
        if (nl != null && nl.getLength() != 0) {
            int i = 0;
            while (i < nl.getLength()) {
                Node n = nl.item(i);
                if (n.getNodeName().equals(st) && st.equals("jsp:directive.taglib")) {
                    int so = ((ElementImpl)n).getStartOffset();
                    if (d.getLineOffset(d.getLineOfOffset(so)) == so) {
                        d.replace(so, 0, tg.toString());
                    } else {
                        StringBuffer left = new StringBuffer().append(PaletteTaglibInserter.analyseSubstring(d.get(d.getLineOffset(d.getLineOfOffset(so)), so - d.getLineOffset(d.getLineOfOffset(so)))));
                        tg.insert(tg.length(), left);
                        d.replace(so, 0, tg.toString());
                    }
                    return true;
                }
                if (n.getNodeName().equals(st) && st.equals("jsp:directive.page")) {
                    tg.delete(tg.lastIndexOf(PaletteInsertHelper.getLineDelimiter((IDocument)d)), tg.length());
                    int so = ((ElementImpl)n).getStartOffset();
                    int eo = ((ElementImpl)n).getEndStartOffset();
                    StringBuffer tgleft = new StringBuffer().append(PaletteInsertHelper.getLineDelimiter((IDocument)d));
                    if (d.getLineOffset(d.getLineOfOffset(so)) == so) {
                        tgleft.append(tg);
                        d.replace(eo, 0, tgleft.toString());
                        PaletteTaglibInserter.mouveFocusOnPage(p, eo + tgleft.length(), eo);
                    } else {
                        tgleft.append(PaletteTaglibInserter.analyseSubstring(d.get(d.getLineOffset(d.getLineOfOffset(so)), so - d.getLineOffset(d.getLineOfOffset(so)))));
                        tgleft.append(tg);
                        d.replace(eo, 0, tgleft.toString());
                        PaletteTaglibInserter.mouveFocusOnPage(p, eo + tgleft.length(), eo);
                    }
                    return true;
                }
                if (docType && irdt != null) {
                    tg.delete(tg.lastIndexOf(PaletteInsertHelper.getLineDelimiter((IDocument)d)), tg.length());
                    int so = irdt.getStartOffset();
                    int eo = irdt.getEndOffset();
                    StringBuffer tgleft = new StringBuffer().append(PaletteInsertHelper.getLineDelimiter((IDocument)d));
                    if (d.getLineOffset(d.getLineOfOffset(so)) == so) {
                        tgleft.append(tg);
                        d.replace(eo, 0, tgleft.toString());
                        PaletteTaglibInserter.mouveFocusOnPage(p, eo + tgleft.length(), eo);
                    } else {
                        tgleft.append(PaletteTaglibInserter.analyseSubstring(d.get(d.getLineOffset(d.getLineOfOffset(so)), so - d.getLineOffset(d.getLineOfOffset(so)))));
                        tgleft.append(tg);
                        d.replace(eo, 0, tgleft.toString());
                        PaletteTaglibInserter.mouveFocusOnPage(p, eo + tgleft.length(), eo);
                    }
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

