/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.outline;

import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener2;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.ui.attribute.AttributeContentProposalProviderFactory;
import org.jboss.tools.common.model.ui.attribute.editor.DialogCellEditorEx;
import org.jboss.tools.common.model.ui.objecteditor.AttributeWrapper;
import org.jboss.tools.common.model.ui.objecteditor.ExtendedCellEditorProvider;
import org.jboss.tools.jst.web.ui.internal.editor.contentassist.JSPDialogContentProposalProvider;
import org.jboss.tools.jst.web.ui.internal.editor.messages.JstUIMessages;
import org.jboss.tools.jst.web.ui.internal.editor.outline.JSPTreeDialog;
import org.jboss.tools.jst.web.ui.internal.editor.outline.ValueHelper;
import org.jboss.tools.jst.web.ui.internal.editor.outline.css.CSSStyleClassSelectorDecorator;
import org.jboss.tools.jst.web.ui.internal.editor.outline.css.CSSStyleDialogDecorator;

public class JSPDialogCellEditor
extends DialogCellEditorEx
implements ExtendedCellEditorProvider.StoppableCellEditor {
    Properties context;
    JSPDialogContentProposalProvider cppEL;
    JSPDialogContentProposalProvider cppAttr;
    boolean hasProposals = false;

    public JSPDialogCellEditor(Composite parent, Properties context) {
        super(parent);
        this.context = context;
        this.addContentAssist(this.getTextField());
    }

    public void activate() {
        this.checkHasProposals();
        this.checkButtonEnablement();
        super.activate();
    }

    private void checkHasProposals() {
        this.hasProposals = false;
        if (this.context == null) {
            return;
        }
        String attributeName = this.context.getProperty("attributeName");
        if (attributeName.equalsIgnoreCase("style") || attributeName.equalsIgnoreCase("class")) {
            this.hasProposals = true;
            return;
        }
        if (this.cppEL == null) {
            this.cppEL = new JSPDialogContentProposalProvider();
        }
        this.cppEL.setContext(this.context);
        if (this.cppAttr == null) {
            this.cppAttr = new JSPDialogContentProposalProvider();
            this.cppAttr.setAttrMode();
        }
        this.cppAttr.setContext(this.context);
        IContentProposal[] ps = this.cppEL.getProposals("#{}", 2);
        this.hasProposals = ps != null && ps.length > 0;
    }

    private void checkButtonEnablement() {
        if (this.context == null) {
            return;
        }
        Button button = this.getButtonControl();
        if (button == null || button.isDisposed()) {
            return;
        }
        button.setVisible(this.hasProposals);
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        this.externalEditing = true;
        String attributeName = this.context.getProperty("attributeName");
        String nodeName = this.context.getProperty("nodeName");
        String query = "/";
        ValueHelper valueHelper = new ValueHelper();
        query = String.valueOf(query) + nodeName + "@" + attributeName;
        this.context.setProperty("query", query);
        this.context.setProperty("help", query);
        this.context.setProperty("title", MessageFormat.format(JstUIMessages.JSPDialogCellEditor_EditAttribute, WizardKeys.toDisplayName((String)attributeName)));
        this.context.setProperty("subtitle", "<" + this.context.getProperty("nodeName") + ">");
        String value = this.getValue() instanceof String ? this.getValue().toString() : (this.getValue() instanceof AttributeWrapper ? ((AttributeWrapper)this.getValue()).value : "");
        this.context.put("value", value);
        attributeName = attributeName.toLowerCase();
        if (attributeName.equalsIgnoreCase("class") || attributeName.endsWith("class".toLowerCase())) {
            CSSStyleClassSelectorDecorator dialog = new CSSStyleClassSelectorDecorator(cellEditorWindow.getShell());
            dialog.setCurrentStyleClass(value);
            if (dialog.open() == 0) {
                this.externalEditing = false;
                return dialog.getCSSStyleClasses();
            }
        } else if (attributeName.equalsIgnoreCase("style") || attributeName.endsWith("style".toLowerCase())) {
            CSSStyleDialogDecorator dialog = new CSSStyleDialogDecorator(cellEditorWindow.getShell(), value == null ? "" : value);
            if (dialog.open() == 0) {
                this.externalEditing = false;
                return dialog.getStyle();
            }
        } else {
            JSPTreeDialog dialog = new JSPTreeDialog();
            dialog.setObject(this.context);
            if (dialog.execute() != 0) {
                this.externalEditing = false;
                return null;
            }
        }
        this.externalEditing = false;
        value = this.context.getProperty("value");
        return value;
    }

    public void stopEditing() {
        super.fireApplyEditorValue();
    }

    protected Text getTextField() {
        return this.text;
    }

    protected Control createContents(Composite cell) {
        super.createContents(cell);
        return this.getTextControl();
    }

    protected void addContentAssist(Text text) {
        TextContentAdapter controlAdapter = new TextContentAdapter();
        this.cppEL = new JSPDialogContentProposalProvider();
        this.cppEL.setContext(this.context);
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)text, (IControlContentAdapter)controlAdapter, (IContentProposalProvider)this.cppEL, AttributeContentProposalProviderFactory.getCtrlSpaceKeyStroke(), null);
        adapter.setPropagateKeys(true);
        adapter.setProposalAcceptanceStyle(1);
        if (this.popup != null) {
            adapter.addContentProposalListener((IContentProposalListener2)this.popup);
        }
        this.cppAttr = new JSPDialogContentProposalProvider();
        this.cppAttr.setAttrMode();
        this.cppAttr.setContext(this.context);
        adapter = new ContentProposalAdapter((Control)text, (IControlContentAdapter)controlAdapter, (IContentProposalProvider)this.cppAttr, AttributeContentProposalProviderFactory.getCtrlSpaceKeyStroke(), null);
        adapter.setPropagateKeys(true);
        adapter.setProposalAcceptanceStyle(2);
        if (this.popup != null) {
            adapter.addContentProposalListener((IContentProposalListener2)this.popup);
        }
        int bits = 16512;
        ControlDecoration controlDecoration = new ControlDecoration(this.getTextControl(), bits){

            public Image getImage() {
                return super.getImage();
            }
        };
        controlDecoration.setMarginWidth(0);
        controlDecoration.setDescriptionText(JstUIMessages.JSPDialogCellEditor_CodeAssist);
        controlDecoration.setShowHover(true);
        controlDecoration.setShowOnlyOnFocus(true);
        FieldDecoration contentProposalImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
        controlDecoration.setImage(contentProposalImage.getImage());
    }

    public static void addContentAssist(Text text, Properties context, IContentProposalListener2 popup) {
        TextContentAdapter controlAdapter = new TextContentAdapter();
        JSPDialogContentProposalProvider cppEL = new JSPDialogContentProposalProvider();
        cppEL.setContext(context);
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)text, (IControlContentAdapter)controlAdapter, (IContentProposalProvider)cppEL, AttributeContentProposalProviderFactory.getCtrlSpaceKeyStroke(), null);
        adapter.setPropagateKeys(true);
        adapter.setProposalAcceptanceStyle(1);
        if (popup != null) {
            adapter.addContentProposalListener(popup);
        }
        JSPDialogContentProposalProvider cppAttr = new JSPDialogContentProposalProvider();
        cppAttr.setAttrMode();
        cppAttr.setContext(context);
        adapter = new ContentProposalAdapter((Control)text, (IControlContentAdapter)controlAdapter, (IContentProposalProvider)cppAttr, AttributeContentProposalProviderFactory.getCtrlSpaceKeyStroke(), null);
        adapter.setPropagateKeys(true);
        adapter.setProposalAcceptanceStyle(2);
        if (popup != null) {
            adapter.addContentProposalListener(popup);
        }
        int bits = 16512;
        ControlDecoration controlDecoration = new ControlDecoration((Control)text, bits){

            public Image getImage() {
                return super.getImage();
            }
        };
        controlDecoration.setMarginWidth(0);
        controlDecoration.setDescriptionText(JstUIMessages.JSPDialogCellEditor_CodeAssist);
        controlDecoration.setShowHover(true);
        controlDecoration.setShowOnlyOnFocus(true);
        FieldDecoration contentProposalImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
        controlDecoration.setImage(contentProposalImage.getImage());
    }
}

