/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.properties.advanced;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.jboss.tools.common.ui.widget.editor.CompositeEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.common.ui.widget.editor.SwtFieldEditorFactory;
import org.jboss.tools.jst.web.ui.internal.editor.outline.IFormPropertySource;
import org.jboss.tools.jst.web.ui.internal.properties.AbstractPropertySetViewer;
import org.jboss.tools.jst.web.ui.internal.properties.IPropertySheetModelListener;
import org.jboss.tools.jst.web.ui.internal.properties.advanced.IFieldEditorProvider;
import org.jboss.tools.jst.web.ui.internal.properties.advanced.LayoutUtil;
import org.jboss.tools.jst.web.ui.palette.html.wizard.ComboContentProposalProvider;

public abstract class AbstractAdvancedPropertySetViewer
extends AbstractPropertySetViewer
implements PropertyChangeListener {
    protected ScrolledComposite scroll;
    protected Composite fields = null;
    protected Map<String, IFieldEditorProvider> editorProviders = new HashMap<String, IFieldEditorProvider>();
    protected List<Entry> entries = new ArrayList<Entry>();
    private Map<String, Entry> entriesByID = new HashMap<String, Entry>();
    protected boolean isUpdating = false;
    boolean needsUpdateUI = false;

    public AbstractAdvancedPropertySetViewer() {
        this.initEditorProviders();
    }

    protected IFile getContextFile() {
        IEditorInput input;
        IWorkbenchPart part = this.model.getWorkbenchPart();
        if (part instanceof IEditorPart && (input = ((IEditorPart)part).getEditorInput()) instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        return null;
    }

    @Override
    public Composite createControl(Composite parent) {
        this.scroll = new ScrolledComposite(parent, 512);
        this.scroll.setLayout((Layout)new GridLayout());
        this.fields = new Composite((Composite)this.scroll, 0);
        GridData d = new GridData(1808);
        this.fields.setLayoutData((Object)d);
        this.fields.setLayout((Layout)new GridLayout(3, false));
        this.scroll.setContent((Control)this.fields);
        this.scroll.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (AbstractAdvancedPropertySetViewer.this.fields != null && !AbstractAdvancedPropertySetViewer.this.fields.isDisposed()) {
                    int x = AbstractAdvancedPropertySetViewer.this.scroll.getSize().x;
                    if (AbstractAdvancedPropertySetViewer.this.scroll.getVerticalBar() != null && AbstractAdvancedPropertySetViewer.this.scroll.getVerticalBar().isVisible()) {
                        x -= AbstractAdvancedPropertySetViewer.this.scroll.getVerticalBar().getSize().x;
                    }
                    AbstractAdvancedPropertySetViewer.this.fields.setSize(x, AbstractAdvancedPropertySetViewer.this.fields.getSize().y);
                    AbstractAdvancedPropertySetViewer.this.fields.layout(true);
                }
            }
        });
        return this.scroll;
    }

    @Override
    public Control getControl() {
        return this.scroll;
    }

    protected void initEditorProviders() {
    }

    protected abstract List<IPropertyDescriptor> getFilteredDescriptors(List<IPropertyDescriptor> var1);

    protected void selectDescriptor(String id, List<IPropertyDescriptor> result) {
        if (this.getModel().hasDescriptor(id)) {
            result.add(this.getModel().getDescriptor(id));
        }
    }

    protected void selectDescriptors(String[] ids, List<IPropertyDescriptor> result) {
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            this.selectDescriptor(id, result);
            ++n2;
        }
    }

    protected boolean isStructureChanged(List<IPropertyDescriptor> descriptors) {
        return false;
    }

    @Override
    public void refresh(List<IPropertyDescriptor> descriptors) {
        boolean isModified = this.isStructureChanged(descriptors);
        descriptors = this.getFilteredDescriptors(descriptors);
        this.isUpdating = true;
        if (!isModified && !this.isModified(descriptors)) {
            int i = 0;
            while (i < this.entries.size()) {
                Entry e = this.entries.get(i);
                e.update(descriptors.get(i));
                ++i;
            }
        } else {
            IPropertyDescriptor d;
            for (Entry e : this.entries) {
                if (!e.layout) continue;
                e.editor.removePropertyChangeListener((PropertyChangeListener)this);
                e.editor.dispose();
            }
            Control[] cs = this.fields.getChildren();
            int i = 0;
            while (i < cs.length) {
                cs[i].dispose();
                ++i;
            }
            this.entries.clear();
            this.entriesByID.clear();
            i = 0;
            while (i < descriptors.size()) {
                d = descriptors.get(i);
                Entry e = new Entry(d);
                if (e.editor != null) {
                    this.entries.add(e);
                    this.entriesByID.put(d.getId().toString(), e);
                }
                ++i;
            }
            if (this.entries.isEmpty()) {
                Label label = new Label(this.fields, 0);
                label.setText("There is no form for current selection.");
                d = new GridData();
                d.horizontalSpan = 3;
                label.setLayoutData((Object)d);
            } else {
                this.layoutEditors(this.fields, this.entries);
            }
            for (Entry e : this.entries) {
                e.update();
            }
            this.needsUpdateUI = true;
            if (this.fields.isVisible()) {
                this.updateUI();
            }
        }
        this.isUpdating = false;
    }

    @Override
    public void updateUI() {
        if (this.needsUpdateUI && this.scroll != null && !this.scroll.isDisposed() && this.fields != null && !this.fields.isDisposed()) {
            this.fields.pack(true);
            int x = this.scroll.getSize().x;
            if (this.scroll.getVerticalBar() != null && this.scroll.getVerticalBar().isVisible()) {
                x -= this.scroll.getVerticalBar().getSize().x;
            }
            this.fields.setSize(x, this.fields.getSize().y);
            this.needsUpdateUI = false;
        }
    }

    protected IFieldEditor createEditor(IPropertyDescriptor d) {
        IFieldEditorProvider editorProvider = this.editorProviders.get(d.getId().toString());
        if (editorProvider != null) {
            return editorProvider.createEditor();
        }
        return this.createTextEditor(d);
    }

    public IFieldEditor createTextEditor(IPropertyDescriptor d) {
        CompositeEditor editor = (CompositeEditor)SwtFieldEditorFactory.INSTANCE.createTextEditor(d.getId().toString(), String.valueOf(d.getDisplayName()) + ":", this.model.getValueAsString(d), "");
        return editor;
    }

    protected abstract void layoutEditors(Composite var1, List<Entry> var2);

    protected boolean isModified(List<IPropertyDescriptor> descriptors) {
        if (this.entries.size() != descriptors.size()) {
            return true;
        }
        int i = 0;
        while (i < this.entries.size()) {
            Entry e = this.entries.get(i);
            IPropertyDescriptor d = descriptors.get(i);
            if (!d.getId().equals(e.descriptor.getId())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.scroll.dispose();
        for (Entry e : this.entries) {
            e.editor.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public Entry getEditor(String id) {
        return this.entriesByID.get(id);
    }

    public boolean hasEditor(String id) {
        return this.entriesByID.containsKey(id);
    }

    public List<Entry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public int layoutEditor(String id, Composite parent) {
        if (this.getEditor(id) != null) {
            this.layoutEditor(this.getEditor(id), parent, true);
            return 1;
        }
        return 0;
    }

    public void layoutEditor(final Entry editor, Composite parent) {
        Text text;
        editor.layout(parent);
        editor.editor.addPropertyChangeListener((PropertyChangeListener)this);
        Combo c = LayoutUtil.findCombo(editor.editor);
        if (c != null) {
            new ComboContentProposalProvider(c);
        }
        if ((text = LayoutUtil.findText(editor.editor)) != null && this.getModel().getPropertySource() instanceof IFormPropertySource) {
            text.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    ((IFormPropertySource)AbstractAdvancedPropertySetViewer.this.getModel().getPropertySource()).addContentAssist(text, editor.descriptor);
                    text.removeFocusListener((FocusListener)this);
                }
            });
        }
        Object[] objectArray = editor.editor.getEditorControls();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof Widget && !(o instanceof Label)) {
                Widget w = (Widget)o;
                w.addListener(4, new Listener(){

                    public void handleEvent(Event event) {
                        AbstractAdvancedPropertySetViewer.this.editedDescriptor.setDescriptor(editor.descriptor);
                    }
                });
            }
            ++n2;
        }
    }

    public void layoutEditor(Entry editor, Composite parent, boolean expandCombo) {
        this.layoutEditor(editor, parent);
        if (expandCombo) {
            LayoutUtil.expandCombo(editor.editor);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.isUpdating) {
            return;
        }
        this.isUpdating = true;
        IPropertyDescriptor d = this.getModel().getDescriptor(evt.getPropertyName());
        if (d != null) {
            this.setModelValue(d, evt.getNewValue());
        }
        this.isUpdating = false;
    }

    protected String getVisualValue(IPropertyDescriptor d) {
        Entry e = this.getEditor(d.getId().toString());
        if (!this.isPropertySet(d) && e != null && e.defaultValue != null) {
            return e.defaultValue.toString();
        }
        return this.toVisualValue(this.model.getValueAsString(d), d);
    }

    protected void setModelValue(IPropertyDescriptor d, Object visualValue) {
        Object value = this.isOptionalDefaultValue(d, visualValue) ? null : this.toModelValue(visualValue, d);
        this.editedDescriptor.setDescriptor(d);
        this.editedDescriptor.applyValue(value);
    }

    protected boolean isOptionalDefaultValue(IPropertyDescriptor d, Object visualValue) {
        Entry e = this.getEditor(d.getId().toString());
        return e != null && e.isDefaultValue(visualValue) && ("true".equals(visualValue.toString()) || "false".equals(visualValue.toString()));
    }

    protected IPropertyDescriptor getOriginalDescriptor(IPropertyDescriptor d) {
        return d;
    }

    protected String toVisualValue(String modelValue, IPropertyDescriptor d) {
        return modelValue;
    }

    protected Object toModelValue(Object visualValue, IPropertyDescriptor d) {
        return visualValue;
    }

    @Override
    protected void createEntryListener() {
        this.entryListener = new IPropertySheetModelListener(){

            @Override
            public void valueChanged(IPropertyDescriptor descriptor) {
                String newValue;
                String editorValue;
                if (AbstractAdvancedPropertySetViewer.this.isUpdating) {
                    return;
                }
                AbstractAdvancedPropertySetViewer.this.isUpdating = true;
                Entry editor = AbstractAdvancedPropertySetViewer.this.getEditor(descriptor.getId().toString());
                if (editor != null && !(editorValue = editor.editor.getValueAsString()).equals(newValue = AbstractAdvancedPropertySetViewer.this.getVisualValue(descriptor))) {
                    editor.editor.setValue((Object)newValue);
                }
                AbstractAdvancedPropertySetViewer.this.isUpdating = false;
            }

            @Override
            public void descriptorsChanged() {
                if (AbstractAdvancedPropertySetViewer.this.isUpdating) {
                    return;
                }
                if (AbstractAdvancedPropertySetViewer.this.model != null) {
                    AbstractAdvancedPropertySetViewer.this.refresh(AbstractAdvancedPropertySetViewer.this.model.getPropertyDescriptors());
                }
            }
        };
    }

    public final class Entry {
        private IPropertyDescriptor descriptor;
        private IFieldEditor editor;
        private Object defaultValue = null;
        private boolean layout = false;

        Entry(IPropertyDescriptor descriptor) {
            this.descriptor = descriptor;
            this.editor = AbstractAdvancedPropertySetViewer.this.createEditor(descriptor);
            if (this.editor != null) {
                this.defaultValue = this.editor.getValue();
            }
        }

        public void update(IPropertyDescriptor d) {
            this.descriptor = d;
            this.update();
        }

        public void update() {
            if (this.layout) {
                this.editor.setValue((Object)AbstractAdvancedPropertySetViewer.this.getVisualValue(this.descriptor));
            }
        }

        public void layout(Composite parent) {
            this.editor.doFillIntoGrid((Object)parent);
            this.layout = true;
        }

        public boolean isDefaultValue(Object visualValue) {
            return this.defaultValue != null && visualValue != null && this.defaultValue.toString().equals(visualValue.toString());
        }

        public boolean isLayout() {
            return this.layout;
        }

        public IFieldEditor getEditor() {
            return this.editor;
        }

        public IPropertyDescriptor getDescriptor() {
            return this.descriptor;
        }

        public Object getModelValue() {
            return AbstractAdvancedPropertySetViewer.this.toModelValue(this.editor.getValue(), this.descriptor);
        }
    }
}

