/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.text.ext.hyperlink.jsp;

import java.text.MessageFormat;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.FindObjectHelper;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.xml.XMLElementNameHyperlinkPartitioner;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jst.web.tld.ITaglibMapping;
import org.jboss.tools.jst.web.tld.IWebProject;
import org.jboss.tools.jst.web.tld.WebProjectFactory;
import org.jboss.tools.jst.web.ui.internal.text.ext.util.TaglibManagerWrapper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JSPElementNameHyperlink
extends AbstractHyperlink {
    protected final String JAR_FILE_PROTOCOL = "jar:file:/";

    protected void doHyperlink(IRegion region) {
        XModelObject object = this.getFilename(region);
        if (object != null) {
            FindObjectHelper.findModelObject((XModelObject)object, (int)FindObjectHelper.IN_EDITOR_ONLY);
        } else {
            this.openFileFailed();
        }
    }

    protected void openFileInEditor(String fileString) {
        if (fileString.startsWith("jar:file:/")) {
            IEditorInput jarEditorInput = this.createEditorInput(fileString = fileString.substring("jar:file:/".length()));
            IEditorPart part = this.openFileInEditor(jarEditorInput, fileString);
            if (part == null) {
                this.openFileFailed();
            }
        } else {
            super.openFileInEditor(fileString);
        }
    }

    private XModelObject getFilename(IRegion region) {
        XModel xModel = this.getXModel();
        if (xModel == null) {
            return null;
        }
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(this.getDocument());
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            if (n == null || !(n instanceof IDOMElement)) {
                return null;
            }
            IHyperlinkRegion r = XMLElementNameHyperlinkPartitioner.getRegion((IDocument)this.getDocument(), (int)region.getOffset());
            if (r == null) {
                return null;
            }
            String nodePrefix = this.getTagPrefix((IRegion)r);
            if (nodePrefix == null) {
                return null;
            }
            TaglibManagerWrapper tmw = new TaglibManagerWrapper();
            tmw.init(this.getDocument(), r.getOffset());
            if (!tmw.exists()) {
                return null;
            }
            String uri = tmw.getUri(nodePrefix);
            if (uri == null) {
                return null;
            }
            IWebProject wp = WebProjectFactory.instance.getWebProject(xModel);
            if (wp == null) {
                return null;
            }
            ITaglibMapping tm = wp.getTaglibMapping();
            if (tm == null) {
                return null;
            }
            tm.invalidate();
            XModelObject xModelObject = tm.getTaglibObject(uri);
            return xModelObject;
        }
        finally {
            smw.dispose();
        }
    }

    private String getTagPrefix(IRegion region) {
        String nodePrefix;
        String nodeName;
        if (region == null) {
            return null;
        }
        try {
            nodeName = this.getDocument().get(region.getOffset(), region.getLength());
        }
        catch (BadLocationException e) {
            return null;
        }
        if (nodeName.indexOf(":") != -1 && (nodePrefix = nodeName.substring(0, nodeName.indexOf(":"))) != null && nodePrefix.length() > 0) {
            return nodePrefix;
        }
        return null;
    }

    public String getHyperlinkText() {
        String tagPrefix = this.getTagPrefix(this.getHyperlinkRegion());
        if (tagPrefix == null) {
            return MessageFormat.format(Messages.OpenA, Messages.TagLibrary);
        }
        return MessageFormat.format(Messages.OpenTagLibraryForPrefix, tagPrefix);
    }
}

