/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.navigator;

import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.Libs;
import org.jboss.tools.common.model.ui.navigator.NavigatorLabelProvider;
import org.jboss.tools.common.model.ui.navigator.decorator.DecoratorManager;
import org.jboss.tools.common.model.ui.navigator.decorator.XModelObjectDecorator;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;

public class WebProjectsLabelProvider
extends NavigatorLabelProvider {
    public String getText(Object element) {
        if (!(element instanceof XModelObject)) {
            return "";
        }
        XModelObject o = (XModelObject)element;
        String entity = o.getModelEntity().getName();
        XModelObjectDecorator d = DecoratorManager.getInstance().getDecoratorByEntity(entity);
        if (d != null) {
            String label = d.getLabel(o);
            return this.applyModification(o, label);
        }
        if (o.getFileType() != 1) {
            return super.getText(element);
        }
        if ("FilePROPERTIES".equals(entity)) {
            XModelObject fs = o;
            while (fs != null && fs.getFileType() != 3) {
                fs = fs.getParent();
            }
            if (fs == null || !fs.getAttributeValue("name").startsWith("src")) {
                return super.getText(element);
            }
            String res = XModelObjectLoaderUtil.getResourcePath((XModelObject)o);
            if (res == null || !res.endsWith(".properties")) {
                return super.getText(element);
            }
            res = res.substring(1, res.length() - 11).replace('/', '.');
            return this.applyModification(o, res);
        }
        if ("FileSystemFolder".equals(entity)) {
            String s = o.getAttributeValue("location").replace('\\', '/');
            return s.substring(s.lastIndexOf(47) + 1);
        }
        XModelObject p = o.getParent();
        while (p != null && p.getFileType() != 3) {
            p = p.getParent();
        }
        if (p != null && p.getModelEntity().getName().equals("FileSystemJar")) {
            String n = p.getAttributeValue("name");
            if (n != null && n.startsWith(Libs.LIB_PREFIX)) {
                n = n.substring(4);
            }
            String addition = n != null ? " - " + n : "";
            return String.valueOf(super.getText(element)) + addition;
        }
        return super.getText(element);
    }

    public void dispose() {
    }
}

