/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.navigator;

import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.meta.action.XActionList;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.action.XModelObjectAction;
import org.jboss.tools.common.model.ui.action.XModelObjectActionList;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jst.web.ui.Messages;
import org.jboss.tools.jst.web.ui.navigator.XOpenAction;

public class XActionProvider
extends CommonActionProvider {
    public void setContext(ActionContext context) {
        super.setContext(context);
    }

    public void fillActionBars(IActionBars actionBars) {
        ActionContext c = this.getContext();
        ISelection s = c.getSelection();
        if (s == null || s.isEmpty() || !(s instanceof IStructuredSelection)) {
            return;
        }
        Object e = ((IStructuredSelection)s).getFirstElement();
        if (e instanceof XModelObject) {
            XModelObject o = (XModelObject)e;
            this.registerAction(actionBars, o, "DeleteActions.Delete", ActionFactory.DELETE.getId());
            this.registerAction(actionBars, o, "CopyActions.Copy", ActionFactory.COPY.getId());
            this.registerAction(actionBars, o, "CopyActions.Paste", ActionFactory.PASTE.getId());
            this.registerAction(actionBars, o, "CopyActions.Cut", ActionFactory.CUT.getId());
            if (o.getFileType() <= 1) {
                XOpenAction x = new XOpenAction(o);
                actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)x);
                actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.Open", (IAction)x);
            }
        }
    }

    private void registerAction(IActionBars actionBars, XModelObject o, String path, String id) {
        XAction xa = o.getModelEntity().getActionList().getAction(path);
        if (xa != null) {
            XModelObjectAction a = new XModelObjectAction(xa, o, null, (Object)new Object[]{o, this.getRunningProperties()});
            actionBars.setGlobalActionHandler(id, (IAction)a.getEclipseAction());
        }
    }

    public void updateActionBars() {
    }

    public void fillContextMenu(IMenuManager menu) {
        ActionContext c = this.getContext();
        ISelection s = c.getSelection();
        if (s == null || s.isEmpty() || !(s instanceof IStructuredSelection)) {
            return;
        }
        Object e = ((IStructuredSelection)s).getFirstElement();
        if (e instanceof IFile) {
            IFile f = (IFile)e;
            XModelObject o = EclipseResourceUtil.getObjectByResource((IResource)f);
            if (o == null) {
                EclipseResourceUtil.createObjectForResource((IResource)f.getProject());
                o = EclipseResourceUtil.createObjectForResource((IResource)f);
            }
            if (o == null) {
                return;
            }
            this.add(o, menu, false);
        } else if (e instanceof XModelObject) {
            XModelObject o = (XModelObject)e;
            this.add(o, menu, true);
        }
    }

    void add(XModelObject o, IMenuManager menu, boolean removeAll) {
        IContributionItem[] is = menu.getItems();
        int i = 0;
        while (i < is.length) {
            if (is[i] instanceof XContributionItem) {
                return;
            }
            ++i;
        }
        XContributionItem item = new XContributionItem(removeAll);
        item.setModelObject(o);
        menu.add((IContributionItem)item);
    }

    private Properties getRunningProperties() {
        Properties p = new Properties();
        this.fillRunningProperties(p);
        return p;
    }

    protected void fillRunningProperties(Properties p) {
        p.setProperty("actionSourceGUIComponentID", "navigator");
    }

    class XContributionItem
    extends ContributionItem {
        XModelObject o;
        boolean removeAll = false;

        XContributionItem(boolean removeAll) {
            this.removeAll = removeAll;
        }

        public void setModelObject(XModelObject o) {
            this.o = o;
        }

        public void fill(Menu menu, int index) {
            if (this.o.getAdapter(IResource.class) != null && !this.removeAll) {
                MenuItem item = new MenuItem(menu, 64);
                item.setText(Messages.XActionProvider_CompanyName);
                menu = new Menu(item);
                item.setMenu(menu);
            }
            XModelObject[] os = null;
            XModelObjectActionList l = new XModelObjectActionList(this.getActionList(this.o), this.o, os, (Object)new Object[]{this.o, XActionProvider.this.getRunningProperties()});
            l.fillMenu(menu);
            l.removeLastSeparator(menu);
        }

        protected XActionList getActionList(XModelObject o) {
            return o.getModelEntity().getActionList();
        }
    }
}

