/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.html.jquery.wizard;

import org.jboss.tools.common.model.ui.editors.dnd.DropWizardMessages;
import org.jboss.tools.common.model.ui.editors.dnd.IElementGenerator;
import org.jboss.tools.jst.web.ui.JSTWebUIImages;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.JQueryConstants;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.NewHeadingWizardPage;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.NewJQueryWidgetWizard;

public class NewHeadingWizard
extends NewJQueryWidgetWizard<NewHeadingWizardPage>
implements JQueryConstants {
    static String PREFIX_HEADING = "heading-";

    public NewHeadingWizard() {
        this.setWindowTitle(DropWizardMessages.Wizard_Window_Title);
        this.setDefaultPageImageDescriptor(JSTWebUIImages.getInstance().getOrCreateImageDescriptor(JSTWebUIImages.HEADING_IMAGE));
    }

    @Override
    protected NewHeadingWizardPage createPage() {
        return new NewHeadingWizardPage();
    }

    @Override
    protected void addContent(IElementGenerator.ElementNode parent) {
        String title = ((NewHeadingWizardPage)this.page).getEditorValue("title");
        String content = "Content";
        String size = ((NewHeadingWizardPage)this.page).getEditorValue("heading-size");
        boolean corners = this.isTrue("data-corners");
        boolean contentCorners = this.isTrue("heading-content-corners");
        String themeValue = ((NewHeadingWizardPage)this.page).getEditorValue("theme");
        String contentThemeValue = ((NewHeadingWizardPage)this.page).getEditorValue("heading-content-theme");
        String layout = ((NewHeadingWizardPage)this.page).getEditorValue("heading-layout");
        if ("Default".equals(layout)) {
            IElementGenerator.ElementNode h3 = parent.addChild(size, title);
            this.addID(PREFIX_HEADING, h3);
            StringBuilder cls = new StringBuilder();
            cls.append("ui-bar");
            if (themeValue.length() > 0) {
                NewHeadingWizard.addClass(cls, "ui-bar-" + themeValue);
            }
            if (corners) {
                NewHeadingWizard.addClass(cls, "ui-corner-all");
            }
            h3.addAttribute("class", cls.toString());
            IElementGenerator.ElementNode div = parent.addChild("div");
            cls = new StringBuilder();
            cls.append("ui-body");
            if (contentThemeValue.length() > 0) {
                NewHeadingWizard.addClass(cls, "ui-body-" + contentThemeValue);
            }
            if (contentCorners) {
                NewHeadingWizard.addClass(cls, "ui-corner-all");
            }
            div.addAttribute("class", cls.toString());
            div.addChild("p", content);
        } else if ("Combined".equals(layout)) {
            IElementGenerator.ElementNode div = parent.addChild("div");
            this.addID(PREFIX_HEADING, div);
            div.addChild(size, title);
            div.addChild("p", content);
            StringBuilder cls = new StringBuilder();
            cls.append("ui-body");
            if (themeValue.length() > 0) {
                NewHeadingWizard.addClass(cls, "ui-body-" + themeValue);
            }
            if (corners) {
                NewHeadingWizard.addClass(cls, "ui-corner-all");
            }
            div.addAttribute("class", cls.toString());
        } else if ("Attached".equals(layout)) {
            IElementGenerator.ElementNode div = parent.addChild("div");
            this.addID(PREFIX_HEADING, div);
            StringBuilder cls = new StringBuilder();
            if (corners || contentCorners) {
                NewHeadingWizard.addClass(cls, "ui-corner-all");
                NewHeadingWizard.addClass(cls, "custom-corners");
                div.addAttribute("class", cls.toString());
            }
            IElementGenerator.ElementNode div_h3 = div.addChild("div");
            cls = new StringBuilder();
            NewHeadingWizard.addClass(cls, "ui-bar");
            if (themeValue.length() > 0) {
                NewHeadingWizard.addClass(cls, "ui-bar-" + themeValue);
            }
            div_h3.addAttribute("class", cls.toString());
            div_h3.addChild("h3", title);
            IElementGenerator.ElementNode div_p = div.addChild("div");
            cls = new StringBuilder();
            NewHeadingWizard.addClass(cls, "ui-body");
            if (contentThemeValue.length() > 0) {
                NewHeadingWizard.addClass(cls, "ui-body-" + contentThemeValue);
            }
            div_p.addAttribute("class", cls.toString());
            div_p.addChild("p", content);
            if (corners || contentCorners) {
                StringBuilder styleText = new StringBuilder();
                if (corners) {
                    String styleText1 = ".custom-corners .ui-bar {\n  -webkit-border-top-left-radius: inherit;\n  border-top-left-radius: inherit;  -webkit-border-top-right-radius: inherit;  border-top-right-radius: inherit;}\n";
                    styleText.append(styleText1);
                }
                if (contentCorners) {
                    String styleText2 = ".custom-corners .ui-body {  border-top-width: 0;  -webkit-border-bottom-left-radius: inherit;  border-bottom-left-radius: inherit;  -webkit-border-bottom-right-radius: inherit;  border-bottom-right-radius: inherit;}";
                    styleText.append(styleText2);
                }
                IElementGenerator.ElementNode style = div.addChild("style");
                style.addAttribute("scoped", "scoped");
                style.addTextChild(styleText.toString());
            }
        }
    }

    @Override
    protected void createBodyForBrowser(IElementGenerator.ElementNode body) {
        IElementGenerator.ElementNode form = this.getFormNode(body);
        IElementGenerator.ElementNode div = form.addChild("div");
        div.addAttribute("style", "padding: 20px 20px 20px 20px;");
        this.addContent(div);
    }
}

