/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.html.jquery.wizard;

import java.util.ArrayList;
import org.jboss.tools.common.model.ui.editors.dnd.DropWizardMessages;
import org.jboss.tools.common.model.ui.editors.dnd.IElementGenerator;
import org.jboss.tools.jst.web.ui.JSTWebUIImages;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.JQueryConstants;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.NewJQueryWidgetWizard;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.NewTabsWizardPage;

public class NewTabsWizard
extends NewJQueryWidgetWizard<NewTabsWizardPage>
implements JQueryConstants {
    static String PREFIX_TABS = "tabs-";
    static String PREFIX_TAB = "tab-";

    public NewTabsWizard() {
        this.setWindowTitle(DropWizardMessages.Wizard_Window_Title);
        this.setDefaultPageImageDescriptor(JSTWebUIImages.getInstance().getOrCreateImageDescriptor(JSTWebUIImages.TABS_IMAGE));
    }

    @Override
    protected NewTabsWizardPage createPage() {
        return new NewTabsWizardPage();
    }

    @Override
    protected void addContent(IElementGenerator.ElementNode parent) {
        String themeValue = ((NewTabsWizardPage)this.page).getEditorValue("theme");
        IElementGenerator.ElementNode div = parent.addChild("div");
        div.addAttribute("data-role", "tabs");
        this.addID(PREFIX_TABS, div);
        String layout = ((NewTabsWizardPage)this.page).getEditorValue("tabs-layout");
        boolean isNavbar = "navbar".equals(layout);
        if (!isNavbar) {
            String styleText = ".tablist-left {width: 35%; display: inline-block;}\n.tablist-content {width: 50%; display: inline-block;vertical-align: top;margin-left: 5%;}";
            IElementGenerator.ElementNode style = div.addChild("style");
            style.addAttribute("scoped", "scoped");
            style.addTextChild(styleText);
        }
        IElementGenerator.ElementNode ul = null;
        if (isNavbar) {
            IElementGenerator.ElementNode navbar = div.addChild("div");
            navbar.addAttribute("data-role", "navbar");
            ul = navbar.addChild("ul");
        } else {
            ul = div.addChild("ul");
            ul.addAttribute("data-role", "listview");
            ul.addAttribute("data-inset", "true");
            ul.addAttribute("class", "tablist-left");
            if (themeValue.length() > 0) {
                ul.addAttribute("data-theme", themeValue);
            }
        }
        int activeIndex = -1;
        ArrayList<Integer> disabled = new ArrayList<Integer>();
        String[] ids = new String[((NewTabsWizardPage)this.page).tabs.getNumber()];
        int commonTabIDIndex = this.getMinCommonTabIDIndex(0);
        int i = 0;
        while (i < ids.length) {
            String suffix = "" + (char)(97 + i);
            ids[i] = String.valueOf(PREFIX_TAB) + commonTabIDIndex + suffix;
            String tabName = ((NewTabsWizardPage)this.page).tabs.getLabel(i);
            if (((NewTabsWizardPage)this.page).tabs.isActive(i)) {
                activeIndex = i;
            }
            if (((NewTabsWizardPage)this.page).tabs.isDisabled(i)) {
                disabled.add(i);
            }
            IElementGenerator.ElementNode li = ul.addChild("li", "");
            IElementGenerator.ElementNode a = li.addChild("a", tabName);
            a.addAttribute("href", "#" + ids[i]);
            a.addAttribute("data-ajax", "false");
            if (isNavbar && themeValue.length() > 0) {
                a.addAttribute("data-theme", themeValue);
            }
            ++i;
        }
        i = 0;
        while (i < ids.length) {
            String tabName = ((NewTabsWizardPage)this.page).tabs.getLabel(i);
            IElementGenerator.ElementNode div_i = div.addChild("div");
            div_i.addAttribute("id", ids[i]);
            div_i.addChild("h4", tabName);
            String cls = isNavbar ? "ui-body-d ui-content" : "ui-body-d tablist-content";
            div_i.addAttribute("class", cls);
            ++i;
        }
        StringBuilder options = new StringBuilder();
        boolean isCollapsible = this.isTrue("tabs-collapsible");
        if (isCollapsible || activeIndex >= 0) {
            if (isCollapsible) {
                this.addOption(options, "collapsible", "true");
            }
            if (isCollapsible && this.isTrue("data-collapsed")) {
                this.addOption(options, "active", "false");
            } else if (activeIndex > 0) {
                this.addOption(options, "active", "" + activeIndex);
            }
        }
        if ("mouseover".equals(((NewTabsWizardPage)this.page).getEditorValue("tabs-activation"))) {
            this.addOption(options, "event", "\"mouseover\"");
        }
        if (this.isTrue("tabs-animated")) {
            this.addOption(options, "show", "true");
            this.addOption(options, "hide", "true");
        }
        if (!disabled.isEmpty()) {
            StringBuilder d = new StringBuilder();
            int i2 = 0;
            while (i2 < disabled.size()) {
                if (i2 > 0) {
                    d.append(", ");
                }
                d.append((Integer)disabled.get(i2));
                ++i2;
            }
            this.addOption(options, "disabled", "[" + d.toString() + "]");
        }
        if (options.length() > 0) {
            IElementGenerator.ElementNode script = parent.addChild("script");
            String scriptText = "$(\"#" + this.getID(PREFIX_TABS) + "\").tabs({" + options + "});";
            script.addTextChild(scriptText);
        }
    }

    int getMinCommonTabIDIndex(int start) {
        int max = 1;
        while (max > start) {
            start = max;
            int i = 0;
            while (i < ((NewTabsWizardPage)this.page).tabs.number) {
                String suffix = "" + (char)(97 + i);
                int m = this.generateIndex(PREFIX_TAB, suffix, start);
                if (m > max) {
                    max = m;
                }
                ++i;
            }
        }
        return max;
    }

    private void addOption(StringBuilder options, String name, String value) {
        if (options.length() > 0) {
            options.append(", ");
        }
        options.append(name).append(": ").append(value);
    }

    @Override
    protected void createBodyForBrowser(IElementGenerator.ElementNode body) {
        IElementGenerator.ElementNode form = this.getFormNode(body);
        IElementGenerator.ElementNode div = form.addChild("div");
        div.addAttribute("style", "padding: 20px 20px 20px 20px;");
        this.addContent(div);
    }
}

