/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.internal;

import org.eclipse.draw2d.ButtonModel;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.swt.widgets.Control;
import org.jboss.tools.jst.web.ui.palette.CustomDrawerFigure;
import org.jboss.tools.jst.web.ui.palette.MobileDrawerEditPart;
import org.jboss.tools.jst.web.ui.palette.internal.ListFigure;
import org.jboss.tools.jst.web.ui.palette.internal.PaletteSettings;
import org.jboss.tools.jst.web.ui.palette.internal.html.impl.HTML5DynamicPaletteGroup;
import org.jboss.tools.jst.web.ui.palette.internal.html.impl.PaletteDrawerImpl;

public class HTML5DynamicDrawerFigure
extends CustomDrawerFigure {
    private PaletteDrawerImpl drawer;
    private HTML5DynamicPaletteGroup group;
    private String[] numbers = new String[]{"  5", "10", "15", "20", "25"};
    private String[] types = new String[]{PaletteSettings.TYPE_MOST_POPULAR, PaletteSettings.TYPE_LAST_USED};
    private NumberFigure numberFigure;
    private TypeFigure typeFigure;

    public HTML5DynamicDrawerFigure(PaletteDrawerImpl category, Control control) {
        super(control);
        this.drawer = category;
        this.group = (HTML5DynamicPaletteGroup)category.getPaletteGroup();
        Figure collapseToggle = (Figure)this.getChildren().get(0);
        Figure title = (Figure)collapseToggle.getChildren().get(0);
        Figure pinFigure = (Figure)title.getChildren().get(0);
        Figure drawerFigure = (Figure)title.getChildren().get(1);
        this.numberFigure = new NumberFigure("" + PaletteSettings.getInstance().getDynamicGroupNumber(), control);
        this.typeFigure = new TypeFigure(PaletteSettings.getInstance().getDynamicGroupType(), control);
        GridLayout layout = new GridLayout(4, false);
        layout.horizontalSpacing = 7;
        title.setLayoutManager((LayoutManager)layout);
        layout.setConstraint((IFigure)drawerFigure, (Object)new GridData(768));
        title.add((IFigure)drawerFigure);
        title.add((IFigure)this.numberFigure);
        title.add((IFigure)this.typeFigure);
        title.add((IFigure)pinFigure);
    }

    public void refresh() {
        if (!this.numberFigure.getSelected().equals("" + PaletteSettings.getInstance().getDynamicGroupNumber())) {
            this.numberFigure.setSelected("" + PaletteSettings.getInstance().getDynamicGroupNumber());
        }
        if (!this.typeFigure.getSelected().equals(PaletteSettings.getInstance().getDynamicGroupType())) {
            this.typeFigure.setSelected(PaletteSettings.getInstance().getDynamicGroupType());
        }
    }

    protected void handleExpandStateChanged() {
        super.handleExpandStateChanged();
        if (this.isCalledByButtonModel()) {
            this.group.getPaletteModel().onCategoryExpandChange("Dynamic Palette Group", this.isExpanded());
        }
    }

    private boolean isCalledByButtonModel() {
        boolean buttonModel = false;
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement s = stackTraceElementArray[n2];
            if (ButtonModel.class.getName().endsWith(s.getClassName())) {
                buttonModel = true;
            } else if (MobileDrawerEditPart.class.getName().equals(s.getClassName())) {
                return false;
            }
            ++n2;
        }
        return buttonModel;
    }

    public class NumberFigure
    extends ListFigure {
        public NumberFigure(String text, Control control) {
            super(text, control);
        }

        @Override
        public String[] getValues() {
            return HTML5DynamicDrawerFigure.this.numbers;
        }

        @Override
        public void setSelected(String value) {
            this.getLabel().setText(value);
            PaletteSettings.getInstance().setDynamicGroupNumber(new Integer(value.trim()));
            HTML5DynamicDrawerFigure.this.drawer.loadVersion(HTML5DynamicDrawerFigure.this.group.getSelectedVersionGroup().getVersion());
        }
    }

    public class TypeFigure
    extends ListFigure {
        public TypeFigure(String text, Control control) {
            super(text, control);
        }

        @Override
        public String[] getValues() {
            return HTML5DynamicDrawerFigure.this.types;
        }

        @Override
        public void setSelected(String value) {
            this.getLabel().setText(value);
            PaletteSettings.getInstance().setDynamicGroupType(value);
            HTML5DynamicDrawerFigure.this.drawer.loadVersion(HTML5DynamicDrawerFigure.this.group.getSelectedVersionGroup().getVersion());
        }
    }
}

